/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.info.ElementManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ElementInfo {
    public String name = "default";
    protected List<String> componentNames = new ArrayList<String>();
    public List<ElementInfo> components = new ArrayList<ElementInfo>();
    public String type;
    public List<String> buffs = new ArrayList<String>();
    public List<String> debuffs = new ArrayList<String>();
    public double buffDurationMultiplier = 1.0;
    public double debuffDurationMultiplier = 1.0;
    public boolean canBurn = true;
    public boolean canFreeze = true;

    public void loadFromJSON(JsonObject json) {
        if (json.has("name")) {
            this.name = json.get("name").getAsString();
        }
        if (json.has("components")) {
            this.componentNames = JSONHelper.getJsonStrings(json.get("components").getAsJsonArray());
        }
        if (json.has("type")) {
            this.type = json.get("type").getAsString();
        } else {
            String string = this.type = this.componentNames.isEmpty() ? "primal" : "compound";
        }
        if (json.has("buffs")) {
            this.buffs = JSONHelper.getJsonStrings(json.get("buffs").getAsJsonArray());
        }
        if (json.has("debuffs")) {
            this.debuffs = JSONHelper.getJsonStrings(json.get("debuffs").getAsJsonArray());
        }
        if (json.has("buffDurationMultiplier")) {
            this.buffDurationMultiplier = json.get("buffDurationMultiplier").getAsDouble();
        }
        if (json.has("debuffDurationMultiplier")) {
            this.debuffDurationMultiplier = json.get("debuffDurationMultiplier").getAsDouble();
        }
        if (json.has("canBurn")) {
            this.canBurn = json.get("canBurn").getAsBoolean();
        }
        if (json.has("canFreeze")) {
            this.canFreeze = json.get("canFreeze").getAsBoolean();
        }
    }

    public void init() {
        if (this.type.equalsIgnoreCase("compound")) {
            for (String componentName : this.componentNames) {
                if (!ElementManager.getInstance().elements.containsKey(componentName)) continue;
                this.components.add(ElementManager.getInstance().elements.get(componentName));
            }
        }
    }

    public void buffEntity(EntityLivingBase targetEntity, int duration, int amplifier) {
        duration = Math.round((float)duration * (float)this.buffDurationMultiplier);
        for (String buff : this.buffs) {
            Potion potion = (Potion)GameRegistry.findRegistry(Potion.class).getValue(new ResourceLocation(buff));
            if (potion == null) continue;
            targetEntity.func_70690_d(new PotionEffect(potion, duration, amplifier));
        }
    }

    public void debuffEntity(EntityLivingBase targetEntity, int duration, int amplifier) {
        duration = Math.round((float)duration * (float)this.debuffDurationMultiplier);
        for (String debuff : this.debuffs) {
            if ("burning".equalsIgnoreCase(debuff)) {
                targetEntity.func_70015_d(duration);
                continue;
            }
            Potion potion = (Potion)GameRegistry.findRegistry(Potion.class).getValue(new ResourceLocation(debuff));
            if (potion == null) continue;
            targetEntity.func_70690_d(new PotionEffect(potion, duration, amplifier));
        }
    }

    public boolean isEffectApplicable(PotionEffect effect) {
        if (effect == null || effect.func_188419_a().getRegistryName() == null) {
            return false;
        }
        if (this.debuffs.contains(effect.func_188419_a().getRegistryName().toString())) {
            return false;
        }
        for (ElementInfo element : this.components) {
            if (element.isEffectApplicable(effect)) continue;
            return false;
        }
        return true;
    }

    public boolean canBurn() {
        if (!this.canBurn) {
            return false;
        }
        for (ElementInfo element : this.components) {
            if (element.canBurn()) continue;
            return false;
        }
        return true;
    }

    public boolean canFreeze() {
        if (!this.canFreeze) {
            return false;
        }
        for (ElementInfo element : this.components) {
            if (element.canFreeze()) continue;
            return false;
        }
        return true;
    }
}

