/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.spawner.SpawnerMobRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class CreatureSpawn {
    public boolean enabled = true;
    public boolean disableSubspecies = false;
    public List<String> spawners = new ArrayList<String>();
    public List<EnumCreatureType> creatureTypes = new ArrayList<EnumCreatureType>();
    public int[] dimensionIds;
    public String dimensionListType = "whitelist";
    public List<String> biomeTags = new ArrayList<String>();
    public List<Biome> biomes = null;
    public boolean ignoreBiome = false;
    public int spawnWeight = 8;
    public int dungeonWeight = 200;
    public int spawnAreaLimit = 5;
    public int spawnGroupMin = 1;
    public int spawnGroupMax = 3;
    public boolean spawnsInLight = false;
    public boolean spawnsInDark = true;
    public double worldDayMin = -1.0;
    public boolean despawnNatural = true;
    public boolean despawnForced = false;

    public void loadFromJSON(JsonObject json) {
        if (json.has("enabled")) {
            this.enabled = json.get("enabled").getAsBoolean();
        }
        if (json.has("disableSubspecies")) {
            this.disableSubspecies = json.get("disableSubspecies").getAsBoolean();
        }
        this.spawners.clear();
        this.creatureTypes.clear();
        if (json.has("spawners")) {
            this.spawners = JSONHelper.getJsonStrings(json.get("spawners").getAsJsonArray());
            for (String spawner : this.spawners) {
                if ("monster".equalsIgnoreCase(spawner)) {
                    this.creatureTypes.add(EnumCreatureType.MONSTER);
                    continue;
                }
                if ("creature".equalsIgnoreCase(spawner)) {
                    this.creatureTypes.add(EnumCreatureType.CREATURE);
                    continue;
                }
                if ("watercreature".equalsIgnoreCase(spawner)) {
                    this.creatureTypes.add(EnumCreatureType.WATER_CREATURE);
                    continue;
                }
                if (!"ambient".equalsIgnoreCase(spawner)) continue;
                this.creatureTypes.add(EnumCreatureType.AMBIENT);
            }
        }
        if (json.has("dimensionIds")) {
            JsonArray jsonArray = json.get("dimensionIds").getAsJsonArray();
            this.dimensionIds = new int[jsonArray.size()];
            Iterator jsonIterator = jsonArray.iterator();
            int i = 0;
            while (jsonIterator.hasNext()) {
                this.dimensionIds[i] = ((JsonElement)jsonIterator.next()).getAsInt();
                ++i;
            }
        }
        if (json.has("dimensionListType")) {
            this.dimensionListType = json.get("dimensionListType").getAsString();
        }
        if (json.has("ignoreBiome")) {
            this.ignoreBiome = json.get("ignoreBiome").getAsBoolean();
        }
        if (json.has("biomes")) {
            this.biomeTags.clear();
            this.biomes = null;
            this.biomeTags = JSONHelper.getJsonStrings(json.get("biomes").getAsJsonArray());
        }
        if (json.has("spawnWeight")) {
            this.spawnWeight = json.get("spawnWeight").getAsInt();
        }
        if (json.has("dungeonWeight")) {
            this.dungeonWeight = json.get("dungeonWeight").getAsInt();
        }
        if (json.has("spawnAreaLimit")) {
            this.spawnAreaLimit = json.get("spawnAreaLimit").getAsInt();
        }
        if (json.has("spawnGroupMin")) {
            this.spawnGroupMin = json.get("spawnGroupMin").getAsInt();
        }
        if (json.has("spawnGroupMax")) {
            this.spawnGroupMax = json.get("spawnGroupMax").getAsInt();
        }
        if (json.has("spawnsInLight")) {
            this.spawnsInLight = json.get("spawnsInLight").getAsBoolean();
        }
        if (json.has("spawnsInDark")) {
            this.spawnsInDark = json.get("spawnsInDark").getAsBoolean();
        }
        if (json.has("worldDayMin")) {
            this.worldDayMin = json.get("worldDayMin").getAsInt();
        }
        if (json.has("despawnNatural")) {
            this.despawnNatural = json.get("despawnNatural").getAsBoolean();
        }
        if (json.has("despawnForced")) {
            this.despawnForced = json.get("despawnForced").getAsBoolean();
        }
    }

    public void init(CreatureInfo creatureInfo) {
        for (String spawner : this.spawners) {
            LycanitesMobs.printDebug("Creature", "Adding " + creatureInfo.getName() + " to " + spawner + " global spawn list.");
            SpawnerMobRegistry.createSpawn(creatureInfo, spawner);
        }
    }

    public void register(CreatureInfo creatureInfo) {
        if (this.biomes == null) {
            this.biomes = JSONHelper.getJsonBiomes(this.biomeTags);
        }
        if (!CreatureManager.getInstance().spawnConfig.disableAllSpawning && this.enabled && this.spawnWeight > 0 && this.spawnGroupMax > 0) {
            block0: for (EnumCreatureType creatureType : this.creatureTypes) {
                EntityRegistry.addSpawn(creatureInfo.entityClass, (int)this.spawnWeight, (int)(CreatureManager.getInstance().spawnConfig.ignoreWorldGenSpawning ? 0 : this.spawnGroupMin), (int)(CreatureManager.getInstance().spawnConfig.ignoreWorldGenSpawning ? 0 : this.spawnGroupMax), (EnumCreatureType)creatureType, (Biome[])this.biomes.toArray(new Biome[this.biomes.size()]));
                for (Biome biome : this.biomes) {
                    if (biome != Biomes.field_76778_j) continue;
                    EntityRegistry.addSpawn(creatureInfo.entityClass, (int)(this.spawnWeight * 10), (int)(CreatureManager.getInstance().spawnConfig.ignoreWorldGenSpawning ? 0 : this.spawnGroupMin), (int)(CreatureManager.getInstance().spawnConfig.ignoreWorldGenSpawning ? 0 : this.spawnGroupMax), (EnumCreatureType)creatureType, (Biome[])new Biome[]{biome});
                    continue block0;
                }
            }
        }
        if (!CreatureManager.getInstance().spawnConfig.disableDungeonSpawners && this.dungeonWeight > 0) {
            DungeonHooks.addDungeonMob((ResourceLocation)creatureInfo.getResourceLocation(), (int)this.dungeonWeight);
            LycanitesMobs.printDebug("MobSetup", "Dungeon Spawn Added - Weight: " + this.dungeonWeight);
        }
    }

    public boolean isAllowedDimension(World world) {
        if (world == null || world.field_73011_w == null || this.dimensionIds.length == 0) {
            LycanitesMobs.printDebug("MobSpawns", "No world or dimension spawn settings were found, defaulting to valid.");
            return true;
        }
        if (!CreatureManager.getInstance().spawnConfig.isAllowedGlobal(world)) {
            return false;
        }
        for (int dimensionId : this.dimensionIds) {
            if (world.field_73011_w.getDimension() != dimensionId) continue;
            LycanitesMobs.printDebug("MobSpawns", "Dimension is in " + this.dimensionListType + ".");
            return this.dimensionListType.equalsIgnoreCase("whitelist");
        }
        LycanitesMobs.printDebug("MobSpawns", "Dimension was not in " + this.dimensionListType + ".");
        return this.dimensionListType.equalsIgnoreCase("blacklist");
    }

    public boolean isValidBiome(List<Biome> biomes) {
        if (this.ignoreBiome) {
            return true;
        }
        if (this.biomes == null) {
            this.biomes = JSONHelper.getJsonBiomes(this.biomeTags);
        }
        for (Biome validBiome : this.biomes) {
            if (!biomes.contains(validBiome)) continue;
            return true;
        }
        return false;
    }
}

