/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.JSONLoader;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.CreatureStats;
import com.lycanitesmobs.core.info.CreatureConfig;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureSpawnConfig;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.spawner.SpawnerMobRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreatureManager
extends JSONLoader {
    public static CreatureManager INSTANCE;
    public CreatureConfig config;
    public CreatureSpawnConfig spawnConfig;
    public Map<String, CreatureInfo> creatures = new HashMap<String, CreatureInfo>();
    public Map<Class, CreatureInfo> creatureClassMap = new HashMap<Class, CreatureInfo>();
    public List<GroupInfo> loadedGroups = new ArrayList<GroupInfo>();
    public Map<String, Double> difficultyMultipliers = new HashMap<String, Double>();
    public Map<String, Double> levelMultipliers = new HashMap<String, Double>();
    public double tamedHealthMultiplier = 3.0;
    public boolean dlDungeonsLoaded = false;

    public static CreatureManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CreatureManager();
        }
        return INSTANCE;
    }

    public CreatureManager() {
        this.config = new CreatureConfig();
        this.spawnConfig = new CreatureSpawnConfig();
    }

    public void loadConfig() {
        ConfigBase config = ConfigBase.getConfig(LycanitesMobs.group, "general");
        this.config.loadConfig(config);
        this.spawnConfig.loadConfig(ConfigBase.getConfig(LycanitesMobs.group, "spawning"));
        String[] difficultyNames = new String[]{"easy", "normal", "hard"};
        double[] difficultyDefaults = new double[]{0.8, 1.0, 1.1};
        this.difficultyMultipliers = new HashMap<String, Double>();
        config.setCategoryComment("Difficulty Multipliers", "Here you can scale the stats of every mob on a per difficulty basis. Note that on easy, speed is kept at 1.0 by default as 0.5 makes them stupidly slow.");
        int difficultyIndex = 0;
        for (String difficultyName : difficultyNames) {
            for (String statName : CreatureStats.STAT_NAMES) {
                double defaultValue = difficultyDefaults[difficultyIndex];
                if ("easy".equalsIgnoreCase(difficultyName) && "speed".equalsIgnoreCase(statName)) {
                    defaultValue = 1.0;
                }
                if ("hard".equalsIgnoreCase(difficultyName) && ("attackSpeed".equalsIgnoreCase(statName) || "rangedSpeed".equalsIgnoreCase(statName))) {
                    defaultValue = 1.5;
                }
                if ("armor".equalsIgnoreCase(statName)) {
                    defaultValue = 1.0;
                }
                if ("sight".equalsIgnoreCase(statName)) {
                    defaultValue = 1.0;
                }
                this.difficultyMultipliers.put((difficultyName + "-" + statName).toUpperCase(), config.getDouble("Difficulty Multipliers", difficultyName + " " + statName, defaultValue));
            }
            ++difficultyIndex;
        }
        config.setCategoryComment("Mob Level Multipliers", "Normally mobs are level 1, but Spawners can increase their level. Here you can adjust the percentage of each stat that is added per extra level. So by default at level 2 a mobs health is increased by 10%, at level 3 20% and so on.");
        for (String statName : CreatureStats.STAT_NAMES) {
            double levelValue = 0.01;
            if ("health".equalsIgnoreCase(statName)) {
                levelValue = 0.1;
            }
            if ("defense".equalsIgnoreCase(statName)) {
                levelValue = 0.01;
            }
            if ("armor".equalsIgnoreCase(statName)) {
                levelValue = 0.0;
            }
            if ("speed".equalsIgnoreCase(statName)) {
                levelValue = 0.01;
            }
            if ("damage".equalsIgnoreCase(statName)) {
                levelValue = 0.02;
            }
            if ("attackSpeed".equalsIgnoreCase(statName)) {
                levelValue = 0.01;
            }
            if ("rangedSpeed".equalsIgnoreCase(statName)) {
                levelValue = 0.01;
            }
            if ("effect".equalsIgnoreCase(statName)) {
                levelValue = 0.02;
            }
            if ("pierce".equalsIgnoreCase(statName)) {
                levelValue = 0.02;
            }
            if ("sight".equalsIgnoreCase(statName)) {
                levelValue = 0.0;
            }
            this.levelMultipliers.put(statName.toUpperCase(), config.getDouble("Mob Level Multipliers", statName, levelValue));
        }
    }

    public void loadAllFromJSON(GroupInfo groupInfo) {
        try {
            if (!this.loadedGroups.contains(groupInfo)) {
                this.loadedGroups.add(groupInfo);
            }
            this.loadAllJson(groupInfo, "Creature", "creatures", "name", false);
            LycanitesMobs.printDebug("Creature", "Complete! " + this.creatures.size() + " JSON Creature Info Loaded In Total.");
        }
        catch (Exception e) {
            LycanitesMobs.printWarning("", "No Creatures loaded for: " + groupInfo.name);
        }
    }

    @Override
    public void parseJson(GroupInfo groupInfo, String name, JsonObject json) {
        CreatureInfo creatureInfo = new CreatureInfo(groupInfo);
        creatureInfo.loadFromJSON(json);
        if (creatureInfo.name == null) {
            LycanitesMobs.printWarning("", "[Creature] Unable to load " + name + " json due to missing name.");
            return;
        }
        if (this.creatures.containsKey(creatureInfo.name)) {
            creatureInfo = this.creatures.get(creatureInfo.name);
            creatureInfo.loadFromJSON(json);
        }
        this.creatures.put(creatureInfo.name, creatureInfo);
        this.creatureClassMap.put(creatureInfo.entityClass, creatureInfo);
    }

    public void initAll() {
        LycanitesMobs.printDebug("Creature", "Initialising all " + this.creatures.size() + " creatures...");
        SpawnerMobRegistry.SPAWNER_MOB_REGISTRIES.clear();
        for (CreatureInfo creature : this.creatures.values()) {
            creature.init();
        }
    }

    public void registerAll(GroupInfo group) {
        LycanitesMobs.printDebug("Creature", "Registering " + this.creatures.size() + " creatures from the group " + group.name + "...");
        for (CreatureInfo creature : this.creatures.values()) {
            if (creature.group != group) continue;
            creature.register();
        }
    }

    public void reload() {
        this.loadConfig();
        for (GroupInfo group : this.loadedGroups) {
            this.loadAllFromJSON(group);
        }
        this.initAll();
    }

    public CreatureInfo getCreature(String creatureName) {
        if (!this.creatures.containsKey(creatureName)) {
            return null;
        }
        return this.creatures.get(creatureName);
    }

    public CreatureInfo getCreature(Class creatureClass) {
        if (!this.creatureClassMap.containsKey(creatureClass)) {
            return null;
        }
        return this.creatureClassMap.get(creatureClass);
    }

    public CreatureInfo getCreatureFromId(String entityId) {
        entityId = entityId.replace(".", ":");
        String[] mobIdParts = entityId.toLowerCase().split(":");
        return this.getCreature(mobIdParts[mobIdParts.length - 1]);
    }

    public double getDifficultyMultiplier(String difficultyName, String statName) {
        String key = difficultyName.toUpperCase() + "-" + statName.toUpperCase();
        if (!this.difficultyMultipliers.containsKey(key)) {
            return 1.0;
        }
        return this.difficultyMultipliers.get(key);
    }

    public double getLevelMultiplier(String statName) {
        if (!this.levelMultipliers.containsKey(statName.toUpperCase())) {
            return 1.0;
        }
        return this.levelMultipliers.get(statName.toUpperCase());
    }
}

