/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.info.CreatureSpawn;
import com.lycanitesmobs.core.info.ElementInfo;
import com.lycanitesmobs.core.info.ElementManager;
import com.lycanitesmobs.core.info.EntityListCustom;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.info.ItemDrop;
import com.lycanitesmobs.core.info.Subspecies;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class CreatureInfo {
    public static ElementInfo DEFAULT_ELEMENT = new ElementInfo();
    protected String name;
    public Class<? extends EntityLiving> entityClass;
    public GroupInfo group;
    public boolean enabled = true;
    public boolean dummy = false;
    public CreatureSpawn creatureSpawn;
    public double width = 0.8;
    public double height = 1.8;
    public int experience = 5;
    public double health = 20.0;
    public double defense = 0.0;
    public double armor = 0.0;
    public double speed = 24.0;
    public double damage = 2.0;
    public double attackSpeed = 1.0;
    public double rangedSpeed = 0.5;
    public double effect = 1.0;
    public double amplifier = -1.0;
    public double pierce = 1.0;
    public double sight = 16.0;
    public double knockbackResistance = 0.0;
    public int eggBackColor;
    public int eggForeColor;
    public boolean boss = false;
    public Map<Integer, Subspecies> subspecies = new HashMap<Integer, Subspecies>();
    protected String elementName;
    public ElementInfo element;
    public boolean peaceful = false;
    public boolean summonable = false;
    public boolean tameable = false;
    public boolean mountable = false;
    public int summonCost = 1;
    public int dungeonLevel = -1;
    public List<ItemDrop> drops = new ArrayList<ItemDrop>();
    protected JsonArray dropsJson;
    public double sizeScale = 1.0;
    public double hitboxScale = 1.0;

    public CreatureInfo(GroupInfo group) {
        this.group = group;
        this.creatureSpawn = new CreatureSpawn();
        this.element = DEFAULT_ELEMENT;
    }

    public void loadFromJSON(JsonObject json) {
        this.name = json.get("name").getAsString();
        try {
            this.entityClass = Class.forName(json.get("class").getAsString());
        }
        catch (Exception e) {
            LycanitesMobs.printWarning("", "[Creature] Unable to find the Java Entity Class: " + json.get("class").getAsString() + " for " + this.getName());
        }
        if (json.has("enabled")) {
            this.enabled = json.get("enabled").getAsBoolean();
        }
        if (json.has("dummy")) {
            this.dummy = json.get("dummy").getAsBoolean();
        }
        if (this.dummy) {
            return;
        }
        this.creatureSpawn.loadFromJSON(json.get("spawning").getAsJsonObject());
        if (json.has("width")) {
            this.width = json.get("width").getAsDouble();
        }
        if (json.has("height")) {
            this.height = json.get("height").getAsDouble();
        }
        if (json.has("experience")) {
            this.experience = json.get("experience").getAsInt();
        }
        if (json.has("health")) {
            this.health = json.get("health").getAsDouble();
        }
        if (json.has("defense")) {
            this.defense = json.get("defense").getAsDouble();
        }
        if (json.has("armor")) {
            this.armor = json.get("armor").getAsDouble();
        }
        if (json.has("speed")) {
            this.speed = json.get("speed").getAsDouble();
        }
        if (json.has("damage")) {
            this.damage = json.get("damage").getAsDouble();
        }
        if (json.has("attackSpeed")) {
            this.attackSpeed = json.get("attackSpeed").getAsDouble();
        }
        if (json.has("rangedSpeed")) {
            this.rangedSpeed = json.get("rangedSpeed").getAsDouble();
        }
        if (json.has("effect")) {
            this.effect = json.get("effect").getAsDouble();
        }
        if (json.has("amplifier")) {
            this.amplifier = json.get("amplifier").getAsDouble();
        }
        if (json.has("pierce")) {
            this.pierce = json.get("pierce").getAsDouble();
        }
        if (json.has("knockbackResistance")) {
            this.knockbackResistance = json.get("knockbackResistance").getAsDouble();
        }
        if (json.has("sight")) {
            this.sight = json.get("sight").getAsDouble();
        }
        this.eggBackColor = Color.decode(json.get("eggBackColor").getAsString()).getRGB();
        this.eggForeColor = Color.decode(json.get("eggForeColor").getAsString()).getRGB();
        if (json.has("boss")) {
            this.boss = json.get("boss").getAsBoolean();
        }
        if (json.has("subspecies")) {
            Iterator jsonIterator = json.get("subspecies").getAsJsonArray().iterator();
            while (jsonIterator.hasNext()) {
                JsonObject jsonObject = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                Subspecies subspecies = new Subspecies(jsonObject.get("name").getAsString().toLowerCase(), jsonObject.get("type").getAsString().toLowerCase());
                subspecies.index = jsonObject.get("index").getAsInt();
                this.subspecies.put(subspecies.index, subspecies);
            }
        }
        this.elementName = json.get("element").getAsString();
        if (json.has("peaceful")) {
            this.peaceful = json.get("peaceful").getAsBoolean();
        }
        if (json.has("summonable")) {
            this.summonable = json.get("summonable").getAsBoolean();
        }
        if (json.has("tameable")) {
            this.tameable = json.get("tameable").getAsBoolean();
        }
        if (json.has("mountable")) {
            this.mountable = json.get("mountable").getAsBoolean();
        }
        if (json.has("summonCost")) {
            this.summonCost = json.get("summonCost").getAsInt();
        }
        if (json.has("dungeonLevel")) {
            this.dungeonLevel = json.get("dungeonLevel").getAsInt();
        }
        if (json.has("drops")) {
            this.dropsJson = json.getAsJsonArray("drops");
        }
        if (json.has("sizeScale")) {
            this.sizeScale = json.get("sizeScale").getAsDouble();
        }
        if (json.has("hitboxScale")) {
            this.hitboxScale = json.get("hitboxScale").getAsDouble();
        }
    }

    public void init() {
        if (this.dummy) {
            return;
        }
        this.element = ElementManager.getInstance().getElement(this.elementName);
        if (this.element == null) {
            throw new RuntimeException("[Creature] Unable to initialise Creature Info for " + this.getName() + " as the element " + this.elementName + " cannot be found.");
        }
        this.drops.clear();
        if (this.dropsJson != null) {
            for (JsonElement mobDropJson : this.dropsJson) {
                ItemDrop itemDrop = ItemDrop.createFromJSON(mobDropJson.getAsJsonObject());
                if (itemDrop != null) {
                    this.drops.add(itemDrop);
                    continue;
                }
                LycanitesMobs.printWarning("", "[Creature] Unable to add item drop to creature: " + this.name + ".");
            }
        }
        this.creatureSpawn.init(this);
    }

    public void register() {
        if (this.dummy) {
            return;
        }
        if (!this.enabled) {
            LycanitesMobs.printDebug("Creature", "Creature Disabled: " + this.getName() + " - " + this.entityClass + " (" + this.group.name + ")");
        }
        if (!ObjectManager.entityLists.containsKey(this.group.filename)) {
            ObjectManager.entityLists.put(this.group.filename, new EntityListCustom());
        }
        ObjectManager.entityLists.get(this.group.filename).addMapping(this.entityClass, this.getResourceLocation(), this.eggBackColor, this.eggForeColor);
        EntityRegistry.registerModEntity((ResourceLocation)this.getResourceLocation(), this.entityClass, (String)this.getName(), (int)this.group.getNextMobID(), (Object)this.group.mod, (int)128, (int)3, (boolean)true);
        ItemStack achievementStack = new ItemStack(ObjectManager.getItem("mobtoken"));
        achievementStack.func_77983_a("Mob", (NBTBase)new NBTTagString(this.getName()));
        ObjectManager.addStat(this.getName() + ".kill", new StatBase(this.getName() + ".kill", (ITextComponent)new TextComponentString(this.getName() + ".kill")));
        ObjectManager.addStat(this.getName() + ".learn", new StatBase(this.getName() + ".learn", (ITextComponent)new TextComponentString(this.getName() + ".learn")));
        if (this.isSummonable()) {
            ObjectManager.addStat(this.getName() + ".summon", new StatBase(this.getName() + ".summon", (ITextComponent)new TextComponentString(this.getName() + ".summon")));
        }
        if (this.isTameable()) {
            ObjectManager.addStat(this.getName() + ".tame", new StatBase(this.getName() + ".tame", (ITextComponent)new TextComponentString(this.getName() + ".tame")));
        }
        AssetManager.addSound(this.name + "_say", this.group, "entity." + this.name + ".say");
        AssetManager.addSound(this.name + "_hurt", this.group, "entity." + this.name + ".hurt");
        AssetManager.addSound(this.name + "_death", this.group, "entity." + this.name + ".death");
        AssetManager.addSound(this.name + "_step", this.group, "entity." + this.name + ".step");
        AssetManager.addSound(this.name + "_attack", this.group, "entity." + this.name + ".attack");
        AssetManager.addSound(this.name + "_jump", this.group, "entity." + this.name + ".jump");
        AssetManager.addSound(this.name + "_fly", this.group, "entity." + this.name + ".fly");
        if (this.isSummonable() || this.isTameable()) {
            AssetManager.addSound(this.name + "_tame", this.group, "entity." + this.name + ".tame");
        }
        if (this.isSummonable() || this.isTameable()) {
            AssetManager.addSound(this.name + "_beg", this.group, "entity." + this.name + ".beg");
        }
        if (this.isTameable()) {
            AssetManager.addSound(this.name + "_eat", this.group, "entity." + this.name + ".eat");
        }
        if (EntityCreatureRideable.class.isAssignableFrom(this.entityClass) && (this.isSummonable() || this.isTameable())) {
            AssetManager.addSound(this.name + "_mount", this.group, "entity." + this.name + ".mount");
        }
        if (this.isBoss()) {
            AssetManager.addSound(this.name + "_phase", this.group, "entity." + this.name + ".phase");
        }
        this.creatureSpawn.register(this);
        LycanitesMobs.printDebug("Creature", "Creature Added: " + this.getName() + " - " + this.entityClass + " (" + this.group.name + ")");
    }

    public String getName() {
        return this.name;
    }

    public String getEntityId() {
        return this.group.filename + ":" + this.getName();
    }

    public ResourceLocation getResourceLocation() {
        return new ResourceLocation(this.group.filename, this.getName());
    }

    public String getLocalisationKey() {
        return this.group.filename + "." + this.getName();
    }

    public String getTitle() {
        return I18n.func_74838_a((String)("entity." + this.getLocalisationKey() + ".name"));
    }

    public String getDescription() {
        return I18n.func_74838_a((String)("entity." + this.getLocalisationKey() + ".description"));
    }

    public ResourceLocation getIcon() {
        ResourceLocation texture = AssetManager.getTexture(this.getName() + "_icon");
        if (texture == null) {
            AssetManager.addTexture(this.getName() + "_icon", this.group, "textures/guis/" + this.getName() + "_icon.png");
            texture = AssetManager.getTexture(this.getName() + "_icon");
        }
        return texture;
    }

    public boolean isSummonable() {
        return this.summonable && EntityCreatureTameable.class.isAssignableFrom(this.entityClass);
    }

    public boolean isTameable() {
        return this.tameable && EntityCreatureTameable.class.isAssignableFrom(this.entityClass);
    }

    public boolean isMountable() {
        return this.mountable && EntityCreatureRideable.class.isAssignableFrom(this.entityClass);
    }

    public boolean isBoss() {
        return this.boss;
    }

    public Subspecies getSubspecies(int index) {
        if (!this.subspecies.containsKey(index)) {
            return null;
        }
        return this.subspecies.get(index);
    }

    public Subspecies getRandomSubspecies(EntityLivingBase entity, boolean rare) {
        LycanitesMobs.printDebug("Subspecies", "~0===== Subspecies =====0~");
        LycanitesMobs.printDebug("Subspecies", "Selecting random subspecies for: " + entity);
        if (rare) {
            LycanitesMobs.printDebug("Subspecies", "The conditions have been set to rare increasing the chances of a subspecies being picked.");
        }
        if (this.subspecies.isEmpty()) {
            LycanitesMobs.printDebug("Subspecies", "No species available, will be base species.");
            return null;
        }
        LycanitesMobs.printDebug("Subspecies", "Subspecies Available: " + this.subspecies.size());
        int baseSpeciesWeightScaled = Subspecies.baseSpeciesWeight;
        if (rare) {
            baseSpeciesWeightScaled /= 4;
        }
        int totalWeight = baseSpeciesWeightScaled;
        for (Subspecies subspeciesEntry : this.subspecies.values()) {
            totalWeight += subspeciesEntry.weight;
        }
        LycanitesMobs.printDebug("Subspecies", "Total Weight: " + totalWeight);
        int roll = entity.func_70681_au().nextInt(totalWeight);
        LycanitesMobs.printDebug("Subspecies", "Rolled: " + roll);
        if (roll <= baseSpeciesWeightScaled) {
            LycanitesMobs.printDebug("Subspecies", "Base species selected: " + baseSpeciesWeightScaled);
            return null;
        }
        int checkWeight = baseSpeciesWeightScaled;
        for (Subspecies subspeciesEntry : this.subspecies.values()) {
            if (roll > (checkWeight += subspeciesEntry.weight)) continue;
            LycanitesMobs.printDebug("Subspecies", "Subspecies selected: " + subspeciesEntry.name + " - " + subspeciesEntry.weight);
            return subspeciesEntry;
        }
        LycanitesMobs.printWarning("Subspecies", "The roll was higher than the Total Weight, this shouldn't happen.");
        return null;
    }

    public Subspecies getRandomSubspecies(EntityLivingBase entity) {
        return this.getRandomSubspecies(entity, false);
    }

    public Subspecies getChildSubspecies(EntityLivingBase entity, int hostSubspeciesIndex, Subspecies partnerSubspecies) {
        int partnerSubspeciesIndex;
        Subspecies hostSubspecies = this.getSubspecies(hostSubspeciesIndex);
        int n = partnerSubspeciesIndex = partnerSubspecies != null ? partnerSubspecies.index : 0;
        if (hostSubspeciesIndex == partnerSubspeciesIndex) {
            return hostSubspecies;
        }
        int hostWeight = hostSubspecies != null ? hostSubspecies.weight : Subspecies.baseSpeciesWeight;
        int partnerWeight = partnerSubspecies != null ? partnerSubspecies.weight : Subspecies.baseSpeciesWeight;
        int roll = entity.func_70681_au().nextInt(hostWeight + partnerWeight);
        if (roll > hostWeight) {
            return partnerSubspecies;
        }
        return hostSubspecies;
    }
}

