/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureKnowledge;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.network.MessageBeastiary;
import com.lycanitesmobs.core.network.MessageCreatureKnowledge;
import com.lycanitesmobs.core.pets.SummonSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;

public class Beastiary {
    public ExtendedPlayer extendedPlayer;
    public Map<String, CreatureKnowledge> creatureKnowledgeList = new HashMap<String, CreatureKnowledge>();

    public Beastiary(ExtendedPlayer extendedPlayer) {
        this.extendedPlayer = extendedPlayer;
    }

    public void newKnowledgeList(Map<String, CreatureKnowledge> newKnowledgeList) {
        this.creatureKnowledgeList = newKnowledgeList;
    }

    public void addToKnowledgeList(CreatureKnowledge newKnowledge) {
        CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(newKnowledge.creatureName);
        if (creatureInfo == null) {
            return;
        }
        if (creatureInfo.dummy) {
            return;
        }
        this.creatureKnowledgeList.put(newKnowledge.creatureName, newKnowledge);
    }

    public void sendAddedMessage(CreatureInfo creatureInfo) {
        if (this.extendedPlayer.player.func_130014_f_().field_72995_K) {
            return;
        }
        String message = I18n.func_74838_a((String)"message.soulgazer.new");
        message = message.replace("%creature%", creatureInfo.getTitle());
        this.extendedPlayer.player.func_145747_a((ITextComponent)new TextComponentString(message));
        if (creatureInfo.isSummonable()) {
            String summonMessage = I18n.func_74838_a((String)"message.soulgazer.summonable");
            summonMessage = summonMessage.replace("%creature%", creatureInfo.getTitle());
            this.extendedPlayer.player.func_145747_a((ITextComponent)new TextComponentString(summonMessage));
        }
        this.extendedPlayer.player.func_71064_a(ObjectManager.getStat(creatureInfo.name + ".learn"), 1);
    }

    public boolean hasFullKnowledge(String creatureName) {
        if (!this.creatureKnowledgeList.containsKey(creatureName)) {
            return false;
        }
        return !(this.creatureKnowledgeList.get((Object)creatureName).completion < 1.0);
    }

    public boolean hasCreatureFromGroup(GroupInfo group) {
        if (this.creatureKnowledgeList.size() == 0) {
            return false;
        }
        for (Map.Entry<String, CreatureKnowledge> creatureKnowledgeEntry : this.creatureKnowledgeList.entrySet()) {
            if (creatureKnowledgeEntry.getValue() == null || creatureKnowledgeEntry.getValue().creatureInfo.group != group) continue;
            return true;
        }
        return false;
    }

    public Map<Integer, String> getSummonableList() {
        HashMap<Integer, String> minionList = new HashMap<Integer, String>();
        int minionIndex = 0;
        for (String minionName : this.creatureKnowledgeList.keySet()) {
            if (!SummonSet.isSummonableCreature(minionName)) continue;
            minionList.put(minionIndex++, minionName);
        }
        return minionList;
    }

    public void sendNewToClient(CreatureKnowledge newKnowledge) {
        MessageCreatureKnowledge message = new MessageCreatureKnowledge(newKnowledge);
        LycanitesMobs.packetHandler.sendToPlayer(message, (EntityPlayerMP)this.extendedPlayer.getPlayer());
    }

    public void sendAllToClient() {
        MessageBeastiary message = new MessageBeastiary(this);
        LycanitesMobs.packetHandler.sendToPlayer(message, (EntityPlayerMP)this.extendedPlayer.getPlayer());
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (!nbtTagCompound.func_74764_b("CreatureKnowledge")) {
            return;
        }
        this.newKnowledgeList(new HashMap<String, CreatureKnowledge>());
        NBTTagList knowledgeList = nbtTagCompound.func_150295_c("CreatureKnowledge", 10);
        for (int i = 0; i < knowledgeList.func_74745_c(); ++i) {
            NBTTagCompound nbtKnowledge = knowledgeList.func_150305_b(i);
            if (!nbtKnowledge.func_74764_b("CreatureName") || !nbtKnowledge.func_74764_b("Completion")) continue;
            CreatureKnowledge creatureKnowledge = new CreatureKnowledge(this, nbtKnowledge.func_74779_i("CreatureName"), nbtKnowledge.func_74769_h("Completion"));
            this.addToKnowledgeList(creatureKnowledge);
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList knowledgeList = new NBTTagList();
        for (Map.Entry<String, CreatureKnowledge> creatureKnowledgeEntry : this.creatureKnowledgeList.entrySet()) {
            CreatureKnowledge creatureKnowledge = creatureKnowledgeEntry.getValue();
            NBTTagCompound nbtKnowledge = new NBTTagCompound();
            nbtKnowledge.func_74778_a("CreatureName", creatureKnowledge.creatureName);
            nbtKnowledge.func_74780_a("Completion", creatureKnowledge.completion);
            knowledgeList.func_74742_a((NBTBase)nbtKnowledge);
        }
        nbtTagCompound.func_74782_a("CreatureKnowledge", (NBTBase)knowledgeList);
    }
}

