/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.gui;

import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.core.gui.GUIFamiliar;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.pets.PetEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.fml.client.GuiScrollingList;

public class GUIFamiliarList
extends GuiScrollingList {
    GUIFamiliar parentGUI;
    List<PetEntry> familiarList = new ArrayList<PetEntry>();

    public GUIFamiliarList(GUIFamiliar parentGUI, ExtendedPlayer playerExt, int width, int height, int top, int bottom, int left) {
        super(Minecraft.func_71410_x(), width, height, top, bottom, left, 20);
        this.parentGUI = parentGUI;
        this.familiarList = playerExt.petManager.getEntryList("familiar");
    }

    protected int getSize() {
        return this.familiarList.size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.parentGUI.selectPetEntry(this.familiarList.get(index));
    }

    protected boolean isSelected(int index) {
        return this.parentGUI.getSelectedPetEntry() == this.familiarList.get(index);
    }

    protected void drawBackground() {
    }

    protected void drawSlot(int index, int boxRight, int boxTop, int boxBottom, Tessellator tessellator) {
        PetEntry petEntry = this.familiarList.get(index);
        CreatureInfo creatureInfo = petEntry.summonSet.getCreatureInfo();
        if (creatureInfo == null) {
            return;
        }
        int boxLeft = this.left;
        if (petEntry.spawningActive) {
            if (this.isSelected(index)) {
                super.drawGradientRect(boxLeft, boxTop, boxRight, boxBottom, 0x99FFEE, 0x99FFEE);
            }
            super.drawGradientRect(boxLeft, boxTop, boxRight, boxBottom, 0x448877, 0x448877);
        }
        this.parentGUI.getFontRenderer().func_78276_b(petEntry.getDisplayName(), boxLeft + 20, boxTop + 4, 0xFFFFFF);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(creatureInfo.getIcon());
        this.parentGUI.drawTexturedModalRect(this.left + 2, boxTop, 0, 0, 16, 16, 16);
    }
}

