/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.gui;

import com.lycanitesmobs.core.gui.GUIBeastiary;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.fml.client.GuiScrollingList;

public class GUIBeastiaryCreatureList
extends GuiScrollingList {
    private GUIBeastiary parentGUI;
    private Map<Integer, CreatureInfo> creatureList = new HashMap<Integer, CreatureInfo>();

    public GUIBeastiaryCreatureList(GUIBeastiary parentGUI, int width, int height, int top, int bottom, int left) {
        super(Minecraft.func_71410_x(), width, height, top, bottom, left, 20);
        this.parentGUI = parentGUI;
        this.updateList();
    }

    public void updateList() {
        this.creatureList = new HashMap<Integer, CreatureInfo>();
        if (this.parentGUI.getSelectedGroup() == null) {
            return;
        }
        int creatureIndex = 0;
        for (String minionName : this.parentGUI.playerExt.getBeastiary().creatureKnowledgeList.keySet()) {
            CreatureInfo mobInfo = CreatureManager.getInstance().getCreature(minionName.toLowerCase());
            if (mobInfo == null || mobInfo.group != this.parentGUI.getSelectedGroup()) continue;
            this.creatureList.put(creatureIndex++, mobInfo);
        }
    }

    protected int getSize() {
        return this.creatureList.size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.parentGUI.selectCreature(this.creatureList.get(index));
    }

    protected boolean isSelected(int index) {
        return this.parentGUI.getSelectedCreature() != null && this.parentGUI.getSelectedCreature().equals(this.creatureList.get(index));
    }

    protected void drawBackground() {
    }

    protected int getContentHeight() {
        return this.getSize() * 24;
    }

    protected void drawSlot(int index, int boxRight, int boxTop, int boxBottom, Tessellator tessellator) {
        CreatureInfo creatureInfo = this.creatureList.get(index);
        if (creatureInfo == null) {
            return;
        }
        this.parentGUI.getFontRenderer().func_78276_b(creatureInfo.getTitle(), this.left + 20, boxTop + 4, 0xFFFFFF);
        if (creatureInfo.getIcon() != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(creatureInfo.getIcon());
            this.parentGUI.drawTexturedModalRect(this.left + 2, boxTop, 0, 0, 16, 16, 16);
        }
    }
}

