/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.ai;

import com.google.common.base.Predicate;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.api.IGroupAlpha;
import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.ai.EntityAITarget;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;

public class EntityAITargetAttack
extends EntityAITarget {
    public Class targetClass = EntityLivingBase.class;
    private List<Class> targetClasses = null;
    private int targetChance = 0;
    protected boolean tameTargeting = false;
    private int allySize = 0;
    private int enemySize = 0;

    public EntityAITargetAttack(EntityCreatureBase setHost) {
        super(setHost);
        this.func_75248_a(1);
    }

    public EntityAITargetAttack setChance(int setChance) {
        this.targetChance = setChance;
        return this;
    }

    public EntityAITargetAttack setCheckSight(boolean bool) {
        this.checkSight = bool;
        return this;
    }

    public EntityAITargetAttack setTargetClass(Class setTargetClass) {
        this.targetClass = setTargetClass;
        return this;
    }

    public EntityAITargetAttack setTargetClasses(List<Class> classList) {
        this.targetClasses = classList;
        return this;
    }

    public EntityAITargetAttack setOnlyNearby(boolean setNearby) {
        this.nearbyOnly = setNearby;
        return this;
    }

    public EntityAITargetAttack setCantSeeTimeMax(int setCantSeeTimeMax) {
        this.cantSeeTimeMax = setCantSeeTimeMax;
        return this;
    }

    public EntityAITargetAttack setRange(double range) {
        this.targetingRange = range;
        return this;
    }

    public EntityAITargetAttack setHelpCall(boolean setHelp) {
        this.callForHelp = setHelp;
        return this;
    }

    public EntityAITargetAttack setTameTargetting(boolean setTargetting) {
        this.tameTargeting = setTargetting;
        return this;
    }

    public EntityAITargetAttack setPackHuntingScale(int setAllySize, int setEnemySize) {
        this.allySize = setAllySize;
        this.enemySize = setEnemySize;
        return this;
    }

    @Override
    protected EntityLivingBase getTarget() {
        return this.host.func_70638_az();
    }

    @Override
    protected void setTarget(EntityLivingBase newTarget) {
        this.host.func_70624_b(newTarget);
    }

    @Override
    protected boolean isValidTarget(EntityLivingBase target) {
        if (this.targetClass != null && !this.targetClass.isAssignableFrom(target.getClass())) {
            return false;
        }
        if (this.targetClass != ((Object)((Object)this.host)).getClass() && target.getClass() == ((Object)((Object)this.host)).getClass()) {
            return false;
        }
        if ((this.targetClass == IGroupAnimal.class || this.targetClass == IGroupAlpha.class) && target instanceof IGroupPredator) {
            return false;
        }
        if (!this.host.func_70686_a(target.getClass())) {
            return false;
        }
        if (!this.host.canAttackEntity(target)) {
            return false;
        }
        if (this.host instanceof IEntityOwnable && this.host.getOwner() != null) {
            if (target instanceof IEntityOwnable && this.host.getOwner() == ((IEntityOwnable)target).func_70902_q()) {
                return false;
            }
            if (target == this.host.getOwner()) {
                return false;
            }
        }
        if (!this.tameTargeting && this.host instanceof EntityCreatureTameable && ((EntityCreatureTameable)this.host).isTamed()) {
            return false;
        }
        if (this.allySize > 0 && this.enemySize > 0) {
            try {
                double hostPackRange = 32.0;
                double hostPackSize = this.host.func_130014_f_().func_72872_a(((Object)((Object)this.host)).getClass(), this.host.func_174813_aQ().func_72314_b(hostPackRange, hostPackRange, hostPackRange)).size();
                double hostPackScale = hostPackSize / (double)this.allySize;
                double targetPackRange = 64.0;
                double targetPackSize = target.func_130014_f_().func_175647_a(EntityLivingBase.class, target.func_174813_aQ().func_72314_b(targetPackRange, targetPackRange, targetPackRange), (Predicate)new Predicate<EntityLivingBase>(){

                    public boolean apply(EntityLivingBase entity) {
                        return entity.getClass().isAssignableFrom(EntityAITargetAttack.this.targetClass);
                    }
                }).size();
                double targetPackScale = targetPackSize / (double)this.enemySize;
                if (hostPackScale < targetPackScale) {
                    return false;
                }
            }
            catch (Exception e) {
                LycanitesMobs.printWarning("", "An exception occurred when assessing pack sizes, this has been skipped to prevent a crash.");
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean func_75250_a() {
        if (!this.host.isAggressive() || this.host.hasFixateTarget()) {
            return false;
        }
        if (this.targetClass == EntityPlayer.class ? this.host.updateTick % 10L != 0L : this.host.updateTick % 40L != 0L) {
            return false;
        }
        if (this.targetChance > 0 && this.host.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        this.target = null;
        double distance = this.getTargetDistance();
        double heightDistance = 4.0 + (double)this.host.field_70131_O;
        if (this.host.useDirectNavigator()) {
            heightDistance = distance;
        }
        this.target = this.getNewTarget(distance, heightDistance, distance);
        if (this.callForHelp) {
            this.callNearbyForHelp();
        }
        return this.target != null;
    }

    @Override
    public EntityLivingBase getNewTarget(double rangeX, double rangeY, double rangeZ) {
        if (this.targetClass == EntityPlayer.class) {
            EntityLivingBase newTarget = null;
            try {
                List possibleTargets = this.host.func_130014_f_().func_175661_b(EntityPlayer.class, this.targetSelector);
                if (possibleTargets.isEmpty()) {
                    return null;
                }
                Collections.sort(possibleTargets, this.nearestSorter);
                newTarget = (EntityLivingBase)possibleTargets.get(0);
            }
            catch (Exception e) {
                LycanitesMobs.printWarning("", "An exception occurred when player target selecting, this has been skipped to prevent a crash.");
                e.printStackTrace();
            }
            return newTarget;
        }
        return super.getNewTarget(rangeX, rangeY, rangeZ);
    }
}

