/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.ai;

import com.google.common.base.Predicate;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.ai.TargetSorterNearest;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.MathHelper;

public abstract class EntityAITarget
extends EntityAIBase {
    protected EntityCreatureBase host;
    protected EntityLivingBase target;
    protected Predicate<EntityLivingBase> targetSelector;
    protected Predicate<EntityLivingBase> allySelector;
    protected TargetSorterNearest nearestSorter;
    protected boolean checkSight = true;
    protected boolean nearbyOnly = false;
    protected boolean callForHelp = false;
    private int cantSeeTime;
    protected int cantSeeTimeMax = 60;
    protected double targetingRange = 0.0;
    private int targetSearchStatus;
    private int targetSearchDelay;

    public EntityAITarget(EntityCreatureBase setHost) {
        this.host = setHost;
        this.targetSelector = entity -> {
            double d0 = this.getTargetDistance();
            return !((double)entity.func_70032_d((Entity)this.host) > d0) && this.isSuitableTarget((EntityLivingBase)entity, false);
        };
        this.allySelector = entity -> {
            double d0 = this.getTargetDistance();
            return !((double)entity.func_70032_d((Entity)this.host) > d0) && this.isAllyTarget((EntityLivingBase)entity, false);
        };
        this.nearestSorter = new TargetSorterNearest((Entity)setHost);
    }

    public void func_75249_e() {
        this.setTarget(this.target);
        this.targetSearchStatus = 0;
        this.targetSearchDelay = 0;
        this.cantSeeTime = 0;
    }

    public boolean func_75253_b() {
        if (this.getTarget() == null) {
            return false;
        }
        if (!this.getTarget().func_70089_S()) {
            return false;
        }
        double distance = this.getTargetDistance() + 2.0;
        if (Math.sqrt(this.host.func_70068_e((Entity)this.getTarget())) > distance) {
            return false;
        }
        if (this.checkSight) {
            if (this.host.func_70635_at().func_75522_a((Entity)this.getTarget())) {
                this.cantSeeTime = 0;
            } else if (++this.cantSeeTime > this.cantSeeTimeMax) {
                return false;
            }
        }
        return true;
    }

    public void func_75251_c() {
        this.setTarget(null);
    }

    protected EntityLivingBase getTarget() {
        return null;
    }

    protected void setTarget(EntityLivingBase newTarget) {
    }

    public EntityLivingBase getNewTarget(double rangeX, double rangeY, double rangeZ) {
        EntityLivingBase newTarget = null;
        try {
            List<EntityLivingBase> possibleTargets = this.getPossibleTargets(EntityLivingBase.class, rangeX, rangeY, rangeZ);
            if (possibleTargets.isEmpty()) {
                return null;
            }
            Collections.sort(possibleTargets, this.nearestSorter);
            newTarget = possibleTargets.get(0);
        }
        catch (Exception e) {
            LycanitesMobs.printWarning("", "An exception occurred when target selecting, this has been skipped to prevent a crash.");
            e.printStackTrace();
        }
        return newTarget;
    }

    public <T extends EntityLivingBase> List<T> getPossibleTargets(Class<? extends T> clazz, double rangeX, double rangeY, double rangeZ) {
        return this.host.func_130014_f_().func_175647_a(clazz, this.host.func_174813_aQ().func_72314_b(rangeX, rangeY, rangeZ), this.targetSelector);
    }

    protected double getTargetDistance() {
        if (this.targetingRange > 0.0) {
            return this.targetingRange;
        }
        IAttributeInstance attributeInstance = this.host.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return attributeInstance == null ? 16.0 : attributeInstance.func_111126_e();
    }

    public void callNearbyForHelp() {
        if (this.allySelector == null || this.target == null) {
            return;
        }
        try {
            double d0 = this.getTargetDistance();
            List allies = this.host.func_130014_f_().func_175647_a(((Object)((Object)this.host)).getClass(), this.host.func_174813_aQ().func_72314_b(d0, 4.0, d0), this.allySelector);
            for (EntityLivingBase possibleAlly : allies) {
                if (possibleAlly instanceof EntityCreatureBase) {
                    EntityCreatureBase possibleCreatureAlly = (EntityCreatureBase)possibleAlly;
                    if (possibleCreatureAlly.func_70638_az() != null || possibleAlly.func_184191_r((Entity)this.target) || !possibleCreatureAlly.func_70686_a(this.target.getClass()) || !possibleCreatureAlly.canAttackEntity(this.target)) continue;
                    possibleCreatureAlly.func_70624_b(this.target);
                    continue;
                }
                if (possibleAlly.func_70643_av() != null || possibleAlly.func_184191_r((Entity)this.target)) continue;
                possibleAlly.func_70604_c(this.target);
            }
        }
        catch (Exception e) {
            LycanitesMobs.printWarning("", "An exception occurred when calling for help, this has been skipped to prevent a crash.");
            e.printStackTrace();
        }
    }

    protected boolean isSuitableTarget(EntityLivingBase checkTarget, boolean targetCreative) {
        if (checkTarget == null) {
            return false;
        }
        if (checkTarget == this.host) {
            return false;
        }
        if (!checkTarget.func_70089_S()) {
            return false;
        }
        if (checkTarget instanceof EntityPlayer && !targetCreative && (((EntityPlayer)checkTarget).func_184812_l_() || ((EntityPlayer)checkTarget).func_175149_v())) {
            return false;
        }
        if (!this.isValidTarget(checkTarget)) {
            return false;
        }
        if (!this.host.positionNearHome(MathHelper.func_76128_c((double)checkTarget.field_70165_t), MathHelper.func_76128_c((double)checkTarget.field_70163_u), MathHelper.func_76128_c((double)checkTarget.field_70161_v))) {
            return false;
        }
        if (this.checkSight && !checkTarget.func_70644_a(MobEffects.field_188423_x) && !this.host.func_70635_at().func_75522_a((Entity)checkTarget)) {
            return false;
        }
        if (this.nearbyOnly) {
            if (--this.targetSearchDelay <= 0) {
                this.targetSearchStatus = 0;
            }
            if (this.targetSearchStatus == 0) {
                int n = this.targetSearchStatus = this.isNearby(checkTarget) ? 1 : 2;
            }
            if (this.targetSearchStatus == 2) {
                return false;
            }
        }
        return true;
    }

    protected boolean isValidTarget(EntityLivingBase target) {
        return true;
    }

    protected boolean isAllyTarget(EntityLivingBase checkTarget, boolean targetCreative) {
        if (checkTarget == null) {
            return false;
        }
        if (checkTarget == this.host) {
            return false;
        }
        if (!checkTarget.func_70089_S()) {
            return false;
        }
        if (!(checkTarget.getClass() == ((Object)((Object)this.host)).getClass() || this.host.func_184191_r((Entity)checkTarget) && checkTarget.func_184191_r((Entity)this.host))) {
            return false;
        }
        if (checkTarget instanceof EntityPlayer) {
            return false;
        }
        return !this.checkSight || this.host.func_70635_at().func_75522_a((Entity)checkTarget);
    }

    private boolean isNearby(EntityLivingBase target) {
        int j;
        this.targetSearchDelay = 10 + this.host.func_70681_au().nextInt(5);
        Path path = this.host.func_70661_as().func_75494_a((Entity)target);
        if (path == null) {
            return false;
        }
        PathPoint pathpoint = path.func_75870_c();
        if (pathpoint == null) {
            return false;
        }
        int i = pathpoint.field_75839_a - MathHelper.func_76128_c((double)target.field_70165_t);
        return (double)(i * i + (j = pathpoint.field_75838_c - MathHelper.func_76128_c((double)target.field_70161_v)) * j) <= 2.25;
    }
}

