/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.core.entity.EntityProjectileBase;
import java.lang.reflect.Constructor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityProjectileRapidFire
extends EntityProjectileBase {
    public EntityLivingBase shootingEntity;
    private float projectileWidth = 0.2f;
    private float projectileHeight = 0.2f;
    private Class projectileClass = null;
    private int rapidTime = 100;
    private int rapidDelay = 5;
    public double offsetX = 0.0;
    public double offsetY = 0.0;
    public double offsetZ = 0.0;

    public EntityProjectileRapidFire(Class entityClass, World world, int setTime, int setDelay) {
        super(world);
        this.func_70105_a(this.projectileWidth, this.projectileHeight);
        this.projectileClass = entityClass;
        this.rapidTime = setTime;
        this.rapidDelay = setDelay;
        this.field_70145_X = true;
    }

    public EntityProjectileRapidFire(Class entityClass, World world, double par2, double par4, double par6, int setTime, int setDelay) {
        super(world, par2, par4, par6);
        this.func_70105_a(this.projectileWidth, this.projectileHeight);
        this.projectileClass = entityClass;
        this.rapidTime = setTime;
        this.rapidDelay = setDelay;
        this.field_70145_X = true;
    }

    public EntityProjectileRapidFire(Class entityClass, World world, EntityLivingBase entityLivingBase, int setTime, int setDelay) {
        super(world, entityLivingBase);
        this.func_70105_a(this.projectileWidth, this.projectileHeight);
        this.projectileClass = entityClass;
        this.shootingEntity = entityLivingBase;
        this.offsetX = this.field_70165_t - entityLivingBase.field_70165_t;
        this.offsetY = this.field_70163_u - entityLivingBase.field_70163_u;
        this.offsetZ = this.field_70161_v - entityLivingBase.field_70161_v;
        this.rapidTime = setTime;
        this.rapidDelay = setDelay;
        this.field_70145_X = true;
    }

    @Override
    public void func_70071_h_() {
        if (this.shootingEntity != null) {
            this.field_70165_t = this.shootingEntity.field_70165_t + this.offsetX;
            this.field_70163_u = this.shootingEntity.field_70163_u + this.offsetY;
            this.field_70161_v = this.shootingEntity.field_70161_v + this.offsetZ;
        }
        if (this.rapidTime > 0) {
            if (this.projectileClass == null) {
                this.rapidTime = 0;
                return;
            }
            if (this.rapidTime % this.rapidDelay == 0) {
                this.fireProjectile();
            }
            --this.rapidTime;
        } else if (!this.field_70128_L) {
            this.func_70106_y();
        }
    }

    public void addTime(int addTime) {
        this.rapidTime += addTime;
    }

    public void fireProjectile() {
        World world = this.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        try {
            IProjectile projectile;
            if (this.shootingEntity == null) {
                Constructor constructor = this.projectileClass.getDeclaredConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE);
                constructor.setAccessible(true);
                projectile = (IProjectile)constructor.newInstance(world, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                projectile.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.0f, 1.0f);
            } else {
                Constructor constructor = this.projectileClass.getDeclaredConstructor(World.class, EntityLivingBase.class);
                constructor.setAccessible(true);
                projectile = (IProjectile)constructor.newInstance(world, this.shootingEntity);
                projectile.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.0f, 1.0f);
                if (projectile instanceof EntityThrowable) {
                    EntityThrowable entityThrowable = (EntityThrowable)projectile;
                    entityThrowable.func_70107_b(this.shootingEntity.field_70165_t + this.offsetX, this.shootingEntity.field_70163_u + this.offsetY, this.shootingEntity.field_70161_v + this.offsetZ);
                }
            }
            if (projectile instanceof EntityProjectileBase) {
                ((EntityProjectileBase)projectile).setProjectileScale(this.projectileScale);
            }
            world.func_72838_d((Entity)projectile);
        }
        catch (Exception e) {
            System.out.println("[WARNING] [LycanitesMobs] EntityRapidFire was unable to instantiate the given projectile class.");
            e.printStackTrace();
        }
    }

    @Override
    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        if (this.shootingEntity != null) {
            this.offsetX = x - this.shootingEntity.field_70165_t;
            this.offsetY = y - this.shootingEntity.field_70163_u;
            this.offsetZ = z - this.shootingEntity.field_70161_v;
        }
    }

    @Override
    protected void func_70184_a(RayTraceResult rayTraceResult) {
    }

    @Override
    public ResourceLocation getTexture() {
        return null;
    }
}

