/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.GroupInfo;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityProjectileBase
extends EntityThrowable {
    public String entityName = "projectile";
    public GroupInfo group;
    public boolean movement = true;
    public byte baseDamage = 1;
    public float projectileScale = 1.0f;
    public int projectileLife = 200;
    public double knockbackChance = 1.0;
    public boolean pierce = false;
    public boolean pierceBlocks = false;
    public boolean waterProof = false;
    public boolean lavaProof = false;
    public boolean cutsGrass = false;
    public int animationFrame = 0;
    public int animationFrameMax = 0;
    public int textureTiling = 1;
    public float textureScale = 1.0f;
    public float textureOffsetY = 0.0f;
    public boolean clientOnly = false;
    protected static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(EntityProjectileBase.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityProjectileBase(World world) {
        super(world);
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(this.projectileScale));
        this.setProjectileScale(this.projectileScale);
        this.setup();
    }

    public EntityProjectileBase(World world, EntityLivingBase entityLiving) {
        super(world, entityLiving);
        this.func_184538_a((Entity)entityLiving, entityLiving.field_70125_A, entityLiving.field_70177_z, 0.0f, 1.5f, 1.0f);
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(this.projectileScale));
        this.setProjectileScale(this.projectileScale);
        this.setup();
    }

    public EntityProjectileBase(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(this.projectileScale));
        this.setProjectileScale(this.projectileScale);
        this.setup();
    }

    public void setup() {
    }

    public void func_70071_h_() {
        if (!this.movement) {
            this.field_174854_a = false;
            this.field_71088_bW = this.func_82147_ab();
        }
        double initX = this.field_70165_t;
        double initY = this.field_70163_u;
        double initZ = this.field_70161_v;
        super.func_70071_h_();
        if (!this.movement) {
            this.field_70165_t = initX;
            this.field_70163_u = initY;
            this.field_70161_v = initZ;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        this.field_70134_J = false;
        if (!this.func_130014_f_().field_72995_K) {
            if (!this.waterProof && this.func_70090_H()) {
                this.func_70106_y();
            } else if (!this.lavaProof && this.func_180799_ab()) {
                this.func_70106_y();
            }
        }
        if ((!this.func_130014_f_().field_72995_K || this.clientOnly) && this.projectileLife-- <= 0) {
            this.func_70106_y();
        }
        if (this.func_130014_f_().field_72995_K) {
            this.projectileScale = ((Float)this.field_70180_af.func_187225_a(SCALE)).floatValue();
        }
        if (this.animationFrameMax > 0) {
            this.animationFrame = this.animationFrame == this.animationFrameMax || this.animationFrame < 0 ? 0 : ++this.animationFrame;
        }
    }

    protected float func_70185_h() {
        return 0.03f;
    }

    protected void func_70184_a(RayTraceResult rayTraceResult) {
        boolean collided = false;
        boolean entityCollision = false;
        boolean blockCollision = false;
        if (rayTraceResult.field_72308_g != null) {
            if (rayTraceResult.field_72308_g == this.func_85052_h()) {
                return;
            }
            boolean doDamage = true;
            if (rayTraceResult.field_72308_g instanceof EntityLivingBase) {
                doDamage = this.canDamage((EntityLivingBase)rayTraceResult.field_72308_g);
            }
            if (doDamage) {
                EntityLivingBase target;
                this.entityCollision(rayTraceResult.field_72308_g);
                if (rayTraceResult.field_72308_g instanceof EntityLivingBase && this.entityLivingCollision(target = (EntityLivingBase)rayTraceResult.field_72308_g)) {
                    boolean attackSuccess = false;
                    float damage = this.getDamage((Entity)target);
                    if (damage != 0.0f) {
                        float damageInit = damage;
                        double targetKnockbackResistance = 0.0;
                        boolean stopKnockback = false;
                        if (this.knockbackChance < 1.0 && (this.knockbackChance <= 0.0 || this.field_70146_Z.nextDouble() <= this.knockbackChance) && target instanceof EntityLivingBase) {
                            targetKnockbackResistance = target.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
                            target.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
                            stopKnockback = true;
                        }
                        if (this.func_85052_h() instanceof EntityCreatureBase) {
                            EntityCreatureBase creatureThrower = (EntityCreatureBase)this.func_85052_h();
                            attackSuccess = creatureThrower.doRangedDamage((Entity)target, this, damage);
                        } else {
                            double pierceDamage = 1.0;
                            if ((double)damage <= pierceDamage) {
                                attackSuccess = target.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()).func_76348_h().func_151518_m(), damage);
                            } else {
                                int hurtResistantTimeBefore = target.field_70172_ad;
                                target.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()).func_76348_h().func_151518_m(), (float)pierceDamage);
                                target.field_70172_ad = hurtResistantTimeBefore;
                                damage = (float)((double)damage - pierceDamage);
                                attackSuccess = target.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), damage);
                            }
                        }
                        this.onDamage(target, damageInit, attackSuccess);
                        if (stopKnockback) {
                            target.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(targetKnockbackResistance);
                        }
                    }
                }
            }
            collided = true;
            entityCollision = true;
            int i = (int)Math.floor(rayTraceResult.field_72308_g.field_70165_t);
            int j = (int)Math.floor(rayTraceResult.field_72308_g.field_70163_u);
            int k = (int)Math.floor(rayTraceResult.field_72308_g.field_70161_v);
            BlockPos pos = new BlockPos(i, j, k);
            if (!this.func_130014_f_().field_72995_K && this.canDestroyBlock(pos)) {
                try {
                    this.placeBlock(this.func_130014_f_(), pos);
                }
                catch (Exception targetKnockbackResistance) {}
            }
        } else {
            int i = rayTraceResult.func_178782_a().func_177958_n();
            int j = rayTraceResult.func_178782_a().func_177956_o();
            int k = rayTraceResult.func_178782_a().func_177952_p();
            BlockPos blockPos = new BlockPos(i, j, k);
            IBlockState blockState = this.func_130014_f_().func_180495_p(blockPos);
            if (blockState != null) {
                if (blockState.func_177230_c() instanceof BlockTallGrass || blockState.func_177230_c() == Blocks.field_150398_cm) {
                    if (this.cutsGrass) {
                        this.field_70170_p.func_175655_b(blockPos, false);
                    } else {
                        collided = false;
                    }
                } else {
                    boolean bl = collided = blockState.func_185900_c((IBlockAccess)this.func_130014_f_(), new BlockPos(i, j, k)) != null;
                }
            }
            if (collided) {
                blockCollision = true;
                switch (rayTraceResult.field_178784_b) {
                    case DOWN: {
                        --j;
                        break;
                    }
                    case UP: {
                        ++j;
                        break;
                    }
                    case SOUTH: {
                        --k;
                        break;
                    }
                    case NORTH: {
                        ++k;
                        break;
                    }
                    case WEST: {
                        --i;
                        break;
                    }
                    case EAST: {
                        ++i;
                    }
                }
                BlockPos pos = new BlockPos(i, j, k);
                if (!this.func_130014_f_().field_72995_K && this.canDestroyBlock(pos)) {
                    try {
                        this.placeBlock(this.func_130014_f_(), pos);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (collided) {
            boolean blockPierced;
            if (!this.func_130014_f_().field_72995_K) {
                this.onImpact();
            } else {
                this.onImpactVisuals();
            }
            boolean entityPierced = this.pierce && entityCollision;
            boolean bl = blockPierced = this.pierceBlocks && blockCollision;
            if (!(this.func_130014_f_().field_72995_K || entityPierced || blockPierced)) {
                this.func_70106_y();
            }
        }
    }

    public boolean canDamage(EntityLivingBase targetEntity) {
        if (this.func_130014_f_().field_72995_K) {
            return false;
        }
        EntityLivingBase owner = this.func_85052_h();
        if (owner != null) {
            EntityCreatureBase ownerCreature;
            if (owner instanceof EntityCreatureBase && !(ownerCreature = (EntityCreatureBase)owner).canAttackEntity(targetEntity)) {
                return false;
            }
            if (owner instanceof EntityPlayer && MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((EntityPlayer)owner, (Entity)targetEntity))) {
                return false;
            }
            if (!this.func_130014_f_().func_73046_m().func_71219_W() && owner instanceof EntityPlayer) {
                EntityCreatureTameable tamedTarget;
                if (targetEntity instanceof EntityPlayer) {
                    return false;
                }
                if (targetEntity instanceof EntityCreatureTameable && (tamedTarget = (EntityCreatureTameable)targetEntity).isTamed()) {
                    return false;
                }
            }
            if (owner.func_184191_r((Entity)targetEntity) && CreatureManager.getInstance().config.friendlyFire) {
                return false;
            }
        }
        return true;
    }

    public void onDamage(EntityLivingBase target, float damage, boolean attackSuccess) {
    }

    public void entityCollision(Entity entity) {
    }

    public boolean entityLivingCollision(EntityLivingBase entityLiving) {
        return true;
    }

    public boolean canDestroyBlock(BlockPos pos) {
        return this.func_130014_f_().func_175623_d(pos);
    }

    public void placeBlock(World world, BlockPos pos) {
    }

    public void onImpact() {
    }

    public void onImpactVisuals() {
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        return false;
    }

    public void setProjectileScale(float newScale) {
        this.projectileScale = newScale;
        this.func_70105_a(newScale, newScale);
        if (this.func_130014_f_().field_72995_K && !this.clientOnly) {
            return;
        }
        if (this.func_85052_h() != null && this.func_85052_h() instanceof EntityCreatureBase) {
            this.projectileScale = (float)((double)this.projectileScale * ((EntityCreatureBase)this.func_85052_h()).sizeScale);
        }
        this.field_70180_af.func_187227_b(SCALE, (Object)Float.valueOf(this.projectileScale));
    }

    public float getProjectileScale() {
        return this.projectileScale;
    }

    public float getTextureOffsetY() {
        return 0.0f;
    }

    public void setBaseDamage(int newDamage) {
        this.baseDamage = (byte)newDamage;
    }

    public float getDamage(Entity entity) {
        float damage = this.baseDamage;
        if (this.func_85052_h() != null && (this.func_85052_h() instanceof EntityPlayer && !(entity instanceof EntityPlayer) || this.func_85052_h().func_184179_bs() instanceof EntityPlayer)) {
            damage *= 1.2f;
        }
        return damage;
    }

    public int getEffectDuration(int seconds) {
        if (this.func_85052_h() != null && this.func_85052_h() instanceof EntityCreatureBase) {
            return Math.round((float)((EntityCreatureBase)this.func_85052_h()).getEffectDuration(seconds) / 5.0f);
        }
        return seconds * 20;
    }

    public float getEffectStrength(float value) {
        if (this.func_85052_h() != null && this.func_85052_h() instanceof EntityCreatureBase) {
            return ((EntityCreatureBase)this.func_85052_h()).getEffectStrength(value);
        }
        return value;
    }

    public double[] getFacingPosition(double distance) {
        return this.getFacingPosition((Entity)this, distance, 0.0);
    }

    public double[] getFacingPosition(Entity entity, double distance, double angleOffset) {
        double angle = Math.toRadians(entity.field_70177_z) + angleOffset;
        double xAmount = -Math.sin(angle);
        double zAmount = Math.cos(angle);
        double[] coords = new double[]{entity.field_70165_t + distance * xAmount, entity.field_70163_u, entity.field_70161_v + distance * zAmount};
        return coords;
    }

    public String getTextureName() {
        return this.entityName.toLowerCase();
    }

    public ResourceLocation getTexture() {
        if (AssetManager.getTexture(this.getTextureName()) == null) {
            AssetManager.addTexture(this.getTextureName(), this.group, "textures/items/" + this.getTextureName() + ".png");
        }
        return AssetManager.getTexture(this.getTextureName());
    }

    public SoundEvent getLaunchSound() {
        return AssetManager.getSound(this.entityName);
    }
}

