/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.info.CreatureManager;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntityCreatureRideable
extends EntityCreatureTameable {
    public Entity lastRiddenByEntity = null;
    public boolean mountJumping = false;
    public float jumpPower = 0.0f;
    public boolean abilityToggled = false;
    public boolean inventoryToggled = false;

    public EntityCreatureRideable(World world) {
        super(world);
        this.hasJumpSound = true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.lastRiddenByEntity != this.func_184179_bs()) {
            if (this.lastRiddenByEntity != null) {
                this.onDismounted(this.lastRiddenByEntity);
            }
            this.lastRiddenByEntity = this.func_184179_bs();
        }
        if (this.hasRiderTarget()) {
            if (this.func_184179_bs() instanceof EntityLivingBase) {
                EntityLivingBase riderLiving = (EntityLivingBase)this.func_184179_bs();
                this.riderEffects(riderLiving);
                for (Object possibleEffect : riderLiving.func_70651_bq().toArray(new Object[riderLiving.func_70651_bq().size()])) {
                    PotionEffect potionEffect;
                    if (!(possibleEffect instanceof PotionEffect) || this.func_70687_e(potionEffect = (PotionEffect)possibleEffect)) continue;
                    riderLiving.func_184589_d(potionEffect.func_188419_a());
                }
            }
            if (this.func_184179_bs() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)this.func_184179_bs();
                ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
                if (playerExt == null) {
                    return;
                }
                if (playerExt.isControlActive(ExtendedPlayer.CONTROL_ID.MOUNT_ABILITY)) {
                    this.mountAbility((Entity)player);
                    this.abilityToggled = true;
                } else {
                    this.abilityToggled = false;
                }
                if (playerExt.isControlActive(ExtendedPlayer.CONTROL_ID.MOUNT_INVENTORY)) {
                    if (!this.inventoryToggled) {
                        this.openGUI(player);
                    }
                    this.inventoryToggled = true;
                } else {
                    this.inventoryToggled = false;
                }
            }
        } else {
            this.abilityToggled = false;
            this.inventoryToggled = false;
        }
    }

    public void riderEffects(EntityLivingBase rider) {
        if (!rider.func_70648_aU() && this.func_70648_aU() && rider.func_70090_H()) {
            rider.func_70050_g(300);
        }
    }

    public void mountAbility(Entity rider) {
    }

    public void onDismounted(Entity entity) {
    }

    @Override
    public boolean func_70104_M() {
        if (this.func_184179_bs() != null) {
            return false;
        }
        return super.func_70104_M();
    }

    @Override
    public boolean func_82171_bF() {
        if (this.func_130014_f_().field_72995_K) {
            return true;
        }
        Entity entity = this.func_184179_bs();
        return entity == this.func_70902_q();
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX();
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            this.func_184179_bs().func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v);
        }
    }

    private void mount(Entity entity) {
        entity.field_70177_z = this.field_70177_z;
        entity.field_70125_A = this.field_70125_A;
        if (!this.func_130014_f_().field_72995_K) {
            entity.func_184220_m((Entity)this);
        }
    }

    @Override
    public void func_191986_a(float strafe, float up, float forward) {
        if (!(this.isTamed() && this.hasSaddle() && this.hasRiderTarget() && this.func_184179_bs() instanceof EntityLivingBase && this.riderControl())) {
            super.func_191986_a(strafe, up, forward);
            return;
        }
        this.moveMountedWithHeading(strafe, up, forward);
    }

    public void moveMountedWithHeading(float strafe, float up, float forward) {
        if (this.func_184179_bs() instanceof EntityLivingBase) {
            EntityLivingBase rider = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = rider.field_70177_z;
            this.field_70125_A = rider.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = rider.field_70702_br * 0.5f;
            forward = rider.field_191988_bg;
        }
        double verticalMotion = 0.0;
        if (this.func_70090_H() || this.func_180799_ab() || this.isFlying()) {
            if (this.func_184179_bs() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)this.func_184179_bs();
                ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
                verticalMotion = playerExt != null && playerExt.isControlActive(ExtendedPlayer.CONTROL_ID.JUMP) ? this.creatureStats.getSpeed() : (player.field_70125_A > 0.0f && forward != 0.0f ? this.creatureStats.getSpeed() * (double)(-(player.field_70125_A / 90.0f)) : 0.0);
            }
        } else {
            EntityPlayer player;
            ExtendedPlayer playerExt;
            if (!this.isMountJumping() && this.field_70122_E && this.func_184179_bs() instanceof EntityPlayer && (playerExt = ExtendedPlayer.getForPlayer(player = (EntityPlayer)this.func_184179_bs())) != null && playerExt.isControlActive(ExtendedPlayer.CONTROL_ID.JUMP)) {
                this.startJumping();
            }
            if (this.getJumpPower() > 0.0f && !this.isMountJumping() && this.field_70122_E && this.func_184186_bw()) {
                this.field_70181_x = this.getMountJumpHeight() * (double)this.getJumpPower();
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.setMountJumping(true);
                this.field_70160_al = true;
                if (forward > 0.0f) {
                    float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                    float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                    this.field_70159_w += (double)(-0.4f * f2 * this.jumpPower);
                    this.field_70179_y += (double)(0.4f * f3 * this.jumpPower);
                }
                if (!this.func_130014_f_().field_72995_K) {
                    this.playJumpSound();
                }
                this.setJumpPower(0);
                ForgeHooks.onLivingJump((EntityLivingBase)this);
            }
            this.field_70747_aH = (float)((double)this.func_70689_ay() * this.getGlideScale());
        }
        if (this.func_184186_bw()) {
            this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            if (!this.useDirectNavigator()) {
                if (this.isFlying() && !this.func_70090_H() && !this.func_180799_ab()) {
                    this.func_191958_b(strafe, 0.0f, forward, 0.1f);
                    this.func_70091_d(MoverType.SELF, this.field_70159_w, verticalMotion / 16.0, this.field_70179_y);
                    this.field_70159_w *= (double)0.9f;
                    this.field_70181_x *= (double)0.9f;
                    this.field_70179_y *= (double)0.9f;
                } else if (this.func_70090_H() || this.func_180799_ab()) {
                    if (!this.isStrongSwimmer()) {
                        verticalMotion *= 0.015625;
                        strafe *= 0.25f;
                        forward *= 0.25f;
                    }
                    this.func_191958_b(strafe, 0.0f, forward, 0.1f);
                    this.func_70091_d(MoverType.SELF, this.field_70159_w, verticalMotion / 16.0, this.field_70179_y);
                    this.field_70159_w *= (double)0.9f;
                    this.field_70181_x *= (double)0.9f;
                    this.field_70179_y *= (double)0.9f;
                } else {
                    super.func_191986_a(strafe, up, forward);
                }
            } else {
                this.directNavigator.flightMovement(strafe, forward);
            }
        }
        if (this.field_70122_E) {
            this.setJumpPower(0);
            this.setMountJumping(false);
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d0 = this.field_70165_t - this.field_70169_q;
        double d1 = this.field_70161_v - this.field_70166_s;
        float f4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public void startJumping() {
        this.setJumpPower();
    }

    public double getMountJumpHeight() {
        return 0.75;
    }

    public boolean isMountJumping() {
        return this.mountJumping;
    }

    public void setMountJumping(boolean set) {
        this.mountJumping = set;
    }

    public void setJumpPower(int power) {
        if (power < 0) {
            power = 0;
        }
        if (power > 99) {
            power = 99;
        }
        this.jumpPower = power < 90 ? 1.0f * ((float)power / 89.0f) : 1.0f + 1.0f * ((float)(power - 89) / 10.0f);
    }

    public void setJumpPower() {
        this.setJumpPower(89);
    }

    public float getJumpPower() {
        return this.jumpPower;
    }

    public double getGlideScale() {
        return 0.1f;
    }

    public boolean riderControl() {
        return true;
    }

    @Override
    public HashMap<Integer, String> getInteractCommands(EntityPlayer player, ItemStack itemStack) {
        HashMap<Integer, String> commands = new HashMap<Integer, String>();
        commands.putAll(super.getInteractCommands(player, itemStack));
        boolean mountingAllowed = CreatureManager.getInstance().config.mountingEnabled;
        if (mountingAllowed && this.isFlying()) {
            mountingAllowed = CreatureManager.getInstance().config.mountingFlightEnabled;
        }
        if (this.canBeMounted((Entity)player) && !player.func_70093_af() && !this.func_130014_f_().field_72995_K && mountingAllowed) {
            commands.put(EntityCreatureBase.CMD_PRIOR.MAIN.id, "Mount");
        }
        return commands;
    }

    @Override
    public void performCommand(String command, EntityPlayer player, ItemStack itemStack) {
        if (command.equals("Mount")) {
            this.playMountSound();
            this.clearMovement();
            this.func_70624_b(null);
            this.mount((Entity)player);
        }
        super.performCommand(command, player, itemStack);
    }

    @Override
    public Team func_96124_cp() {
        EntityLivingBase rider;
        if (this.hasRiderTarget() && (rider = this.getRider()) != null) {
            return rider.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    @Override
    public boolean func_184191_r(Entity target) {
        if (this.hasRiderTarget()) {
            EntityLivingBase rider = this.getRider();
            if (target == rider) {
                return true;
            }
            if (rider != null) {
                return rider.func_184191_r(target);
            }
        }
        return super.func_184191_r(target);
    }

    @Override
    public boolean canSit() {
        return false;
    }

    public boolean canBeMounted(Entity entity) {
        if (this.func_184179_bs() != null) {
            return false;
        }
        if (this.isTamed() && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player == this.func_70902_q()) {
                return this.hasSaddle() && !this.func_70631_g_();
            }
        } else if (!this.isTamed() && !(entity instanceof EntityPlayer)) {
            return !this.func_70631_g_();
        }
        return false;
    }

    public boolean hasSaddle() {
        ItemStack saddleStack = this.inventory.getEquipmentStack("saddle");
        return saddleStack != null && !saddleStack.func_190926_b();
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damage) {
        Entity entity = damageSource.func_76346_g();
        return this.func_184179_bs() != null && this.func_184215_y(entity) ? false : super.func_70097_a(damageSource, damage);
    }

    @Override
    public float getFallResistance() {
        return 2.0f;
    }

    public void playMountSound() {
        this.func_184185_a(AssetManager.getSound(this.creatureInfo.getName() + "_mount"), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }
}

