/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.info.Subspecies;
import com.lycanitesmobs.core.item.ItemCustomSpawnEgg;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public abstract class EntityCreatureAgeable
extends EntityCreatureBase {
    private float scaledWidth = -1.0f;
    private float scaledHeight;
    private EntityCreatureAgeable breedingTarget;
    public int growthTime = -24000;
    public boolean canGrow = true;
    public double babySpawnChance = 0.0;
    public int loveTime;
    private int loveTimeMax = 600;
    public int breedingCooldown = 6000;
    public boolean hasBeenFarmed = false;
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> LOVE = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityCreatureAgeable(World world) {
        super(world);
    }

    @Override
    public void setupMob() {
        if (this.babySpawnChance > 0.0 && this.field_70146_Z.nextDouble() < this.babySpawnChance) {
            this.setGrowingAge(this.growthTime);
        }
        super.setupMob();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AGE, (Object)0);
        this.field_70180_af.func_187214_a(LOVE, (Object)0);
    }

    @Override
    public String getAgeName() {
        if (this.func_70631_g_()) {
            return "Baby";
        }
        return "";
    }

    @Override
    public boolean isPersistant() {
        if (this.hasBeenFarmed) {
            return true;
        }
        return super.isPersistant();
    }

    public void setFarmed() {
        this.hasBeenFarmed = true;
        if (this.field_71088_bW > this.func_82147_ab()) {
            this.field_71088_bW = this.func_82147_ab();
        }
    }

    @Override
    public void getRandomSubspecies() {
        if (this.func_70631_g_()) {
            return;
        }
        super.getRandomSubspecies();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_130014_f_().field_72995_K) {
            this.setScaleForAge(this.func_70631_g_());
        } else if (this.canGrow) {
            int age = this.getGrowingAge();
            if (age < 0) {
                this.setGrowingAge(++age);
            } else if (age > 0) {
                this.setGrowingAge(--age);
            }
        }
        if (!this.canBreed()) {
            this.loveTime = 0;
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(LOVE, (Object)this.loveTime);
        }
        if (this.func_130014_f_().field_72995_K) {
            this.loveTime = this.getIntFromDataManager(LOVE);
        }
        if (this.isInLove()) {
            this.setFarmed();
            --this.loveTime;
            if (this.func_130014_f_().field_72995_K) {
                EnumParticleTypes particle = EnumParticleTypes.HEART;
                if (this.loveTime % 10 == 0) {
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.func_130014_f_().func_175688_a(particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                }
            }
        }
    }

    @Override
    protected void func_70619_bc() {
        if (!this.canBreed()) {
            this.loveTime = 0;
        }
        super.func_70619_bc();
    }

    @Override
    public HashMap<Integer, String> getInteractCommands(EntityPlayer player, ItemStack itemStack) {
        HashMap<Integer, String> commands = new HashMap<Integer, String>();
        commands.putAll(super.getInteractCommands(player, itemStack));
        if (itemStack != null) {
            if (itemStack.func_77973_b() == ObjectManager.getItem(this.creatureInfo.group.getEggName())) {
                commands.put(EntityCreatureBase.CMD_PRIOR.ITEM_USE.id, "Spawn Baby");
            }
            if (this.isBreedingItem(itemStack) && this.canBreed() && !this.isInLove()) {
                commands.put(EntityCreatureBase.CMD_PRIOR.ITEM_USE.id, "Breed");
            }
        }
        return commands;
    }

    @Override
    public void performCommand(String command, EntityPlayer player, ItemStack itemStack) {
        if (command.equals("Spawn Baby") && !this.func_130014_f_().field_72995_K && ObjectManager.entityLists.containsKey(this.creatureInfo.group.filename)) {
            EntityCreatureAgeable baby;
            ItemCustomSpawnEgg itemCustomSpawnEgg = (ItemCustomSpawnEgg)itemStack.func_77973_b();
            Class eggClass = ObjectManager.entityLists.get(this.creatureInfo.group.filename).getClassFromID(ItemCustomSpawnEgg.getEntityIdFromItem(itemStack));
            if (eggClass != null && eggClass.isAssignableFrom(((Object)((Object)this)).getClass()) && (baby = this.createChild(this)) != null) {
                baby.setGrowingAge(baby.growthTime);
                baby.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                baby.setFarmed();
                this.func_130014_f_().func_72838_d((Entity)baby);
                if (itemStack.func_82837_s()) {
                    baby.func_96094_a(itemStack.func_82833_r());
                }
                this.consumePlayersItem(player, itemStack);
            }
        }
        if (command.equals("Breed") && this.breed()) {
            this.consumePlayersItem(player, itemStack);
        }
        super.performCommand(command, player, itemStack);
    }

    public int getGrowingAge() {
        return this.getIntFromDataManager(AGE);
    }

    public void setGrowingAge(int age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
        this.setScaleForAge(this.func_70631_g_());
    }

    public void addGrowth(int growth) {
        int age = this.getGrowingAge();
        if ((age += growth * 20) > 0) {
            age = 0;
        }
        this.setGrowingAge(age);
    }

    public boolean func_70631_g_() {
        return this.getGrowingAge() < 0;
    }

    public void setScaleForAge(boolean age) {
        this.setAgeScale(age ? 0.5f : 1.0f);
    }

    protected final void setAgeScale(float age) {
        super.func_70105_a(this.scaledWidth * age, this.scaledHeight * age);
    }

    @Override
    protected void func_70105_a(float width, float height) {
        boolean validWidth = this.scaledWidth > 0.0f;
        this.scaledWidth = width;
        this.scaledHeight = height;
        if (!validWidth) {
            this.setAgeScale(1.0f);
        }
        super.func_70105_a(width, height);
    }

    @Override
    public void updateSize() {
        this.func_70105_a(this.setWidth, this.setHeight);
        this.setScaleForAge(this.func_70631_g_());
    }

    @Override
    public boolean canBeTempted() {
        return !this.isInLove();
    }

    public EntityCreatureAgeable getBreedingTarget() {
        return this.breedingTarget;
    }

    public void setBreedingTarget(EntityCreatureAgeable target) {
        this.breedingTarget = target;
    }

    public EntityCreatureAgeable createChild(EntityCreatureAgeable partener) {
        return null;
    }

    public boolean isBreedingItem(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() == null && itemStack.func_77952_i() == -1;
    }

    public boolean canBreedWith(EntityCreatureAgeable partner) {
        if (partner == this) {
            return false;
        }
        if (((Object)((Object)partner)).getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.isInLove() && partner.isInLove();
    }

    public boolean isInLove() {
        return this.loveTime > 0;
    }

    public boolean breed() {
        if (!this.canBreed()) {
            return false;
        }
        this.loveTime = this.loveTimeMax;
        this.func_70624_b(null);
        return true;
    }

    public boolean canBreed() {
        return this.getGrowingAge() == 0;
    }

    public void procreate(EntityCreatureAgeable partner) {
        EntityCreatureAgeable baby = this.createChild(partner);
        if (baby != null) {
            this.finishBreeding();
            partner.finishBreeding();
            baby.setGrowingAge(baby.growthTime);
            Subspecies babySubspecies = this.creatureInfo.getChildSubspecies((EntityLivingBase)this, this.getSubspeciesIndex(), partner.getSubspecies());
            baby.setSubspecies(babySubspecies != null ? babySubspecies.index : 0, true);
            baby.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.func_130014_f_().func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
            this.onCreateBaby(partner, baby);
            this.func_130014_f_().func_72838_d((Entity)baby);
        }
    }

    public void onCreateBaby(EntityCreatureAgeable partner, EntityCreatureAgeable baby) {
    }

    public void finishBreeding() {
        this.setGrowingAge(this.breedingCooldown);
        this.setBreedingTarget(null);
        this.loveTime = 0;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("Age")) {
            this.setGrowingAge(nbtTagCompound.func_74762_e("Age"));
        } else {
            this.setGrowingAge(0);
        }
        this.loveTime = nbtTagCompound.func_74764_b("InLove") ? nbtTagCompound.func_74762_e("InLove") : 0;
        if (nbtTagCompound.func_74764_b("HasBeenFarmed") && nbtTagCompound.func_74767_n("HasBeenFarmed")) {
            this.setFarmed();
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("Age", this.getGrowingAge());
        nbtTagCompound.func_74768_a("InLove", this.loveTime);
        nbtTagCompound.func_74757_a("HasBeenFarmed", this.hasBeenFarmed);
    }
}

