/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.dungeon.instance;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.dungeon.definition.DungeonSector;
import com.lycanitesmobs.core.dungeon.instance.DungeonInstance;
import com.lycanitesmobs.core.dungeon.instance.SectorConnector;
import com.lycanitesmobs.core.dungeon.instance.SectorInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.ChunkPos;

public class DungeonLayout {
    public DungeonInstance dungeonInstance;
    public List<SectorInstance> sectors = new ArrayList<SectorInstance>();
    public Map<ChunkPos, List<SectorInstance>> sectorChunkMap = new HashMap<ChunkPos, List<SectorInstance>>();
    public SectorConnector originConnector;
    List<SectorConnector> openConnectors = new ArrayList<SectorConnector>();

    public DungeonLayout(DungeonInstance dungeonInstance) {
        this.dungeonInstance = dungeonInstance;
    }

    public void generate(Random random) {
        this.sectors.clear();
        this.sectorChunkMap.clear();
        this.openConnectors.clear();
        SectorInstance entranceSector = this.start(random);
        LycanitesMobs.printDebug("Dungeon", "Created Entrance Sector: " + entranceSector);
        this.openConnectors.clear();
        SectorInstance exitSector = entranceSector;
        boolean onLastLevel = false;
        for (int level = 1; !onLastLevel && level <= 10; ++level) {
            int sectorCount = this.dungeonInstance.schematic.getRandomSectorCount(random);
            LycanitesMobs.printDebug("Dungeon", "Starting Level " + level + " - Sector Count: " + sectorCount);
            int snakeCount = Math.round((float)sectorCount * 0.4f);
            exitSector = this.snake(random, exitSector, Math.max(3, snakeCount));
            LycanitesMobs.printDebug("Dungeon", "Snake Sectors: " + snakeCount + " - From Sector: " + exitSector);
            if (exitSector.connectors.isEmpty()) {
                onLastLevel = true;
            }
            LycanitesMobs.printDebug("Dungeon", "Stem Sectors: " + (sectorCount -= snakeCount) + " Open Snake Sectors: " + this.openConnectors.size());
            while (sectorCount > 0) {
                int stemmedSectors = this.stem(random, sectorCount).size();
                if (stemmedSectors == 0) {
                    LycanitesMobs.printWarning("Dungeon", "Unable to stem any sectors.");
                    break;
                }
                sectorCount -= stemmedSectors;
            }
            this.openConnectors.clear();
            LycanitesMobs.printDebug("Dungeon", "Completed Level " + level + (onLastLevel ? " (Final)" : ""));
        }
        LycanitesMobs.printDebug("Dungeon", "Dungeon Instance Generation Complete!");
    }

    public SectorInstance start(Random random) {
        this.originConnector = new SectorConnector(this.dungeonInstance.originPos, null, -1, EnumFacing.field_176754_o[random.nextInt(EnumFacing.field_176754_o.length)]);
        DungeonSector entranceDungeonSector = this.dungeonInstance.schematic.getRandomSector("entrance", random);
        SectorInstance entranceSector = new SectorInstance(this, entranceDungeonSector, random);
        entranceSector.connect(this.originConnector);
        entranceSector.init(random);
        this.addSectorInstance(entranceSector);
        DungeonSector dungeonSector = this.dungeonInstance.schematic.getRandomSector("stairs", random);
        SectorInstance sectorInstance = new SectorInstance(this, dungeonSector, random);
        sectorInstance.connect(entranceSector.getRandomConnector(random, sectorInstance));
        sectorInstance.init(random);
        this.addSectorInstance(sectorInstance);
        return sectorInstance;
    }

    public SectorInstance snake(Random random, SectorInstance startSector, int length) {
        ArrayList<SectorInstance> generatedSectors = new ArrayList<SectorInstance>();
        SectorInstance lastSector = startSector;
        for (int i = 0; i < length; ++i) {
            String nextType = this.dungeonInstance.schematic.getNextConnectingSector(lastSector.dungeonSector.type, random);
            if (i == length - 2) {
                nextType = "bossRoom";
            } else if (i == length - 1) {
                nextType = "stairs";
            }
            DungeonSector dungeonSector = this.dungeonInstance.schematic.getRandomSector(nextType, random);
            SectorInstance sectorInstance = new SectorInstance(this, dungeonSector, random);
            sectorInstance.connect(lastSector.getRandomConnector(random, sectorInstance));
            if ("stairs".equals(nextType) && sectorInstance.getOccupiedBoundsMin().func_177956_o() <= 1) {
                nextType = "finish";
                dungeonSector = this.dungeonInstance.schematic.getRandomSector(nextType, random);
                sectorInstance = new SectorInstance(this, dungeonSector, random);
                sectorInstance.connect(lastSector.getRandomConnector(random, sectorInstance));
            }
            sectorInstance.init(random);
            this.addSectorInstance(sectorInstance);
            generatedSectors.add(sectorInstance);
            lastSector = sectorInstance;
        }
        if (generatedSectors.isEmpty()) {
            LycanitesMobs.printWarning("Dungeon", "Unable to generate any sectors for the dungeon: " + this.dungeonInstance.schematic.name);
        }
        return (SectorInstance)generatedSectors.get(generatedSectors.size() - 1);
    }

    public List<SectorInstance> stem(Random random, int maxSectors) {
        ArrayList<SectorInstance> generatedSectors = new ArrayList<SectorInstance>();
        int stemmedSectors = 0;
        for (SectorConnector connector : this.openConnectors.toArray(new SectorConnector[this.openConnectors.size()])) {
            String nextType = this.dungeonInstance.schematic.getNextConnectingSector(connector.parentSector.dungeonSector.type, random);
            DungeonSector dungeonSector = this.dungeonInstance.schematic.getRandomSector(nextType, random);
            SectorInstance sectorInstance = new SectorInstance(this, dungeonSector, random);
            if (!connector.canConnect(this, sectorInstance)) continue;
            sectorInstance.connect(connector);
            sectorInstance.init(random);
            this.addSectorInstance(sectorInstance);
            generatedSectors.add(sectorInstance);
            if (this.openConnectors.contains(connector)) {
                this.openConnectors.remove(connector);
            }
            connector.closed = true;
            if (++stemmedSectors >= maxSectors) break;
        }
        return generatedSectors;
    }

    public void addSectorInstance(SectorInstance sectorInstance) {
        this.sectors.add(sectorInstance);
        ChunkPos minChunkPos = new ChunkPos(sectorInstance.getOccupiedBoundsMin());
        if (this.dungeonInstance.chunkMin == null) {
            this.dungeonInstance.chunkMin = minChunkPos;
        } else {
            if (minChunkPos.field_77276_a < this.dungeonInstance.chunkMin.field_77276_a) {
                this.dungeonInstance.chunkMin = new ChunkPos(minChunkPos.field_77276_a, this.dungeonInstance.chunkMin.field_77275_b);
            }
            if (minChunkPos.field_77275_b < this.dungeonInstance.chunkMin.field_77275_b) {
                this.dungeonInstance.chunkMin = new ChunkPos(this.dungeonInstance.chunkMin.field_77276_a, minChunkPos.field_77275_b);
            }
        }
        ChunkPos maxChunkPos = new ChunkPos(sectorInstance.getOccupiedBoundsMax());
        if (this.dungeonInstance.chunkMax == null) {
            this.dungeonInstance.chunkMax = maxChunkPos;
        } else {
            if (maxChunkPos.field_77276_a > this.dungeonInstance.chunkMax.field_77276_a) {
                this.dungeonInstance.chunkMax = new ChunkPos(maxChunkPos.field_77276_a, this.dungeonInstance.chunkMax.field_77275_b);
            }
            if (maxChunkPos.field_77275_b > this.dungeonInstance.chunkMax.field_77275_b) {
                this.dungeonInstance.chunkMax = new ChunkPos(this.dungeonInstance.chunkMax.field_77276_a, maxChunkPos.field_77275_b);
            }
        }
        for (ChunkPos chunkPos : sectorInstance.getChunkPositions()) {
            if (!this.sectorChunkMap.containsKey(chunkPos)) {
                this.sectorChunkMap.put(chunkPos, new ArrayList());
            }
            this.sectorChunkMap.get(chunkPos).add(sectorInstance);
        }
        if (!"stairs".equalsIgnoreCase(sectorInstance.dungeonSector.type)) {
            this.openConnectors.addAll(sectorInstance.getOpenConnectors(null));
        }
    }
}

