/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.dungeon;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.Utilities;
import com.lycanitesmobs.core.JSONLoader;
import com.lycanitesmobs.core.dungeon.definition.DungeonSchematic;
import com.lycanitesmobs.core.dungeon.definition.DungeonSector;
import com.lycanitesmobs.core.dungeon.definition.DungeonStructure;
import com.lycanitesmobs.core.dungeon.definition.DungeonTheme;
import com.lycanitesmobs.core.info.GroupInfo;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class DungeonManager
extends JSONLoader {
    public static DungeonManager INSTANCE;
    public Map<String, DungeonTheme> themes = new HashMap<String, DungeonTheme>();
    public Map<String, DungeonStructure> structures = new HashMap<String, DungeonStructure>();
    public Map<String, DungeonSector> sectors = new HashMap<String, DungeonSector>();
    public Map<String, DungeonSchematic> schematics = new HashMap<String, DungeonSchematic>();

    public static DungeonManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DungeonManager();
        }
        return INSTANCE;
    }

    public void loadAllFromJSON() {
        Map<String, JsonObject> themeJSONs = this.loadDungeonsFromJSON("themes");
        LycanitesMobs.printDebug("", "Loading " + themeJSONs.size() + " JSON Dungeon Themes...");
        for (String string : themeJSONs.keySet()) {
            try {
                JsonObject jsonObject = themeJSONs.get(string);
                LycanitesMobs.printDebug("Dungeon", "Loading Dungeon Themes JSON: " + jsonObject);
                DungeonTheme theme = new DungeonTheme();
                theme.loadFromJSON(jsonObject);
                this.addTheme(theme);
            }
            catch (JsonParseException jsonParseException) {
                LycanitesMobs.printWarning("", "Parsing error loading JSON Dungeon Theme: " + string);
                jsonParseException.printStackTrace();
            }
            catch (Exception exception) {
                LycanitesMobs.printWarning("", "There was a problem loading JSON Dungeon Theme: " + string);
                exception.printStackTrace();
            }
        }
        LycanitesMobs.printDebug("", "Complete! " + this.themes.size() + " JSON Dungeon Themes Loaded In Total.");
        Map<String, JsonObject> structureJSONs = this.loadDungeonsFromJSON("structures");
        LycanitesMobs.printDebug("", "Loading " + structureJSONs.size() + " JSON Dungeon Structures...");
        for (String string : structureJSONs.keySet()) {
            try {
                JsonObject json = structureJSONs.get(string);
                LycanitesMobs.printDebug("Dungeon", "Loading Dungeon Structures JSON: " + json);
                DungeonStructure structure = new DungeonStructure();
                structure.loadFromJSON(json);
                this.addStructure(structure);
            }
            catch (JsonParseException e) {
                LycanitesMobs.printWarning("", "Parsing error loading JSON Dungeon Structure: " + string);
                e.printStackTrace();
            }
            catch (Exception e) {
                LycanitesMobs.printWarning("", "There was a problem loading JSON Dungeon Structure: " + string);
                e.printStackTrace();
            }
        }
        LycanitesMobs.printDebug("", "Complete! " + this.themes.size() + " JSON Dungeon Structures Loaded In Total.");
        Map<String, JsonObject> map = this.loadDungeonsFromJSON("sectors");
        LycanitesMobs.printDebug("", "Loading " + map.size() + " JSON Dungeon Sectors...");
        for (String jsonName : map.keySet()) {
            try {
                JsonObject json = map.get(jsonName);
                LycanitesMobs.printDebug("Dungeon", "Loading Dungeon Sectors JSON: " + json);
                DungeonSector sector = new DungeonSector();
                sector.loadFromJSON(json);
                this.addSector(sector);
            }
            catch (JsonParseException e) {
                LycanitesMobs.printWarning("", "Parsing error loading JSON Dungeon Sector: " + jsonName);
                e.printStackTrace();
            }
            catch (Exception e) {
                LycanitesMobs.printWarning("", "There was a problem loading JSON Dungeon Sector: " + jsonName);
                e.printStackTrace();
            }
        }
        LycanitesMobs.printDebug("", "Complete! " + this.themes.size() + " JSON Dungeon Sectors Loaded In Total.");
        Map<String, JsonObject> map2 = this.loadDungeonsFromJSON("schematics");
        LycanitesMobs.printDebug("", "Loading " + map2.size() + " JSON Dungeon Schematics...");
        for (String jsonName : map2.keySet()) {
            try {
                JsonObject json = map2.get(jsonName);
                LycanitesMobs.printDebug("Dungeon", "Loading Dungeon Schematics JSON: " + json);
                DungeonSchematic schematic = new DungeonSchematic();
                schematic.loadFromJSON(json);
                this.addSchematic(schematic);
            }
            catch (JsonParseException e) {
                LycanitesMobs.printWarning("", "Parsing error loading JSON Dungeon Schematics: " + jsonName);
                e.printStackTrace();
            }
            catch (Exception e) {
                LycanitesMobs.printWarning("", "There was a problem loading JSON Dungeon Schematics: " + jsonName);
                e.printStackTrace();
            }
        }
        LycanitesMobs.printDebug("", "Complete! " + this.themes.size() + " JSON Dungeon Schematics Loaded In Total.");
    }

    @Override
    public void parseJson(GroupInfo groupInfo, String name, JsonObject json) {
    }

    public Map<String, JsonObject> loadDungeonsFromJSON(String type) {
        LycanitesMobs.printDebug("Dungeon", "Loading JSON Dungeons!");
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        HashMap<String, JsonObject> spawnerJSONs = new HashMap<String, JsonObject>();
        Path path = Utilities.getAssetPath(this.getClass(), LycanitesMobs.group.filename, "dungeons/" + type);
        HashMap<String, JsonObject> defaultJSONs = new HashMap<String, JsonObject>();
        this.loadJsonObjects(gson, path, defaultJSONs, "name", null);
        String configPath = LycanitesMobs.proxy.getMinecraftDir() + "/config/" + "lycanitesmobs" + "/";
        File customDir = new File(configPath + "dungeons/" + type);
        customDir.mkdirs();
        path = customDir.toPath();
        HashMap<String, JsonObject> customJSONs = new HashMap<String, JsonObject>();
        this.loadJsonObjects(gson, path, customJSONs, "name", null);
        this.writeDefaultJSONObjects(gson, defaultJSONs, customJSONs, spawnerJSONs, true, "dungeons/" + type);
        return spawnerJSONs;
    }

    public void reload() {
        LycanitesMobs.printDebug("Dungeon", "Destroying JSON Dungeons!");
        this.themes.clear();
        this.structures.clear();
        this.sectors.clear();
        this.schematics.clear();
        this.loadAllFromJSON();
    }

    public void addTheme(DungeonTheme theme) {
        if (this.themes.containsKey(theme.name)) {
            LycanitesMobs.printWarning("", "[Dungeon Manager] Tried to add a Dungeon Theme with a name that is already in use: " + theme.name);
            return;
        }
        if (this.themes.values().contains(theme)) {
            LycanitesMobs.printWarning("", "[Dungeon Manager] Tried to add a Dungeon Theme that is already added: " + theme.name);
            return;
        }
        this.themes.put(theme.name, theme);
    }

    public void removeTheme(DungeonTheme theme) {
        if (!this.themes.containsKey(theme.name)) {
            LycanitesMobs.printWarning("", "[Dungeon Manager] Tried to remove a Dungeon Theme that hasn't been added: " + theme.name);
            return;
        }
        this.themes.remove(theme.name);
    }

    public DungeonTheme getTheme(String name) {
        if (!this.themes.containsKey(name)) {
            LycanitesMobs.printWarning("Dungeon", "Unable to find a theme called " + name);
            return null;
        }
        return this.themes.get(name);
    }

    public void addStructure(DungeonStructure structure) {
        if (this.structures.containsKey(structure.name)) {
            LycanitesMobs.printWarning("", "[Dungeon Manager] Tried to add a Dungeon Structure with a name that is already in use: " + structure.name);
            return;
        }
        if (this.structures.values().contains(structure)) {
            LycanitesMobs.printWarning("", "[Dungeon Manager] Tried to add a Dungeon Structure that is already added: " + structure.name);
            return;
        }
        this.structures.put(structure.name, structure);
    }

    public void removeStructure(DungeonStructure structure) {
        if (!this.structures.containsKey(structure.name)) {
            LycanitesMobs.printWarning("", "[Dungeon Manager] Tried to remove a Dungeon Structure that hasn't been added: " + structure.name);
            return;
        }
        this.structures.remove(structure.name);
    }

    public DungeonStructure getStructure(String name) {
        if (!this.structures.containsKey(name)) {
            return null;
        }
        return this.structures.get(name);
    }

    public void addSector(DungeonSector sector) {
        if (this.sectors.containsKey(sector.name)) {
            LycanitesMobs.printWarning("", "[Dungeon Manager] Tried to add a Dungeon Sector with a name that is already in use: " + sector.name);
            return;
        }
        if (this.sectors.values().contains(sector)) {
            LycanitesMobs.printWarning("", "[Dungeon Manager] Tried to add a Dungeon Sector that is already added: " + sector.name);
            return;
        }
        this.sectors.put(sector.name, sector);
    }

    public void removeSector(DungeonSector sector) {
        if (!this.sectors.containsKey(sector.name)) {
            LycanitesMobs.printWarning("", "[Dungeon Manager] Tried to remove a Dungeon Sector that hasn't been added: " + sector.name);
            return;
        }
        this.sectors.remove(sector.name);
    }

    public DungeonSector getSector(String name) {
        if (!this.sectors.containsKey(name)) {
            LycanitesMobs.printWarning("Dungeon", "Unable to find a Dungeon Sector by the name: " + name);
            return null;
        }
        return this.sectors.get(name);
    }

    public void addSchematic(DungeonSchematic schematic) {
        if (this.schematics.containsKey(schematic.name)) {
            LycanitesMobs.printWarning("", "[Dungeon Manager] Tried to add a Dungeon Schematic with a name that is already in use: " + schematic.name);
            return;
        }
        if (this.schematics.values().contains(schematic)) {
            LycanitesMobs.printWarning("", "[Dungeon Manager] Tried to add a Dungeon Schematic that is already added: " + schematic.name);
            return;
        }
        this.schematics.put(schematic.name, schematic);
    }

    public void removeSchematic(DungeonSchematic schematic) {
        if (!this.schematics.containsKey(schematic.name)) {
            LycanitesMobs.printWarning("", "[Dungeon Manager] Tried to remove a Dungeon Schematic that hasn't been added: " + schematic.name);
            return;
        }
        this.schematics.remove(schematic.name);
    }

    public DungeonSchematic getSchematic(String name) {
        if (!this.schematics.containsKey(name)) {
            return null;
        }
        return this.schematics.get(name);
    }
}

