/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.config;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.info.GroupInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ConfigSpawning
extends ConfigBase {
    public static ConfigSpawning getConfig(GroupInfo group, String configName) {
        ConfigBase config;
        String configFileName = group.filename + "-" + configName.toLowerCase();
        if (!configs.containsKey(configFileName)) {
            ConfigSpawning.registerConfig(new ConfigSpawning(group, configName));
        }
        if ((config = ConfigBase.configs.get(configFileName)) instanceof ConfigSpawning) {
            return (ConfigSpawning)config;
        }
        LycanitesMobs.printWarning("", "[Config] Tried to access the Base Config: " + configName + " as a Spawning Config from group: " + group.name + "!");
        return null;
    }

    public ConfigSpawning(GroupInfo group, String name) {
        super(group, name);
    }

    public BiomeDictionary.Type[] getAllBiomeTypes() {
        return new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.RARE, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.RIVER, BiomeDictionary.Type.WATER, BiomeDictionary.Type.MESA, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.VOID};
    }

    public SpawnTypeSet getTypes(String category, String key) {
        return this.getTypes(category, key, "");
    }

    public SpawnTypeSet getTypes(String category, String key, String defaultValue) {
        return this.getTypes(category, key, defaultValue, null);
    }

    public SpawnTypeSet getTypes(String category, String key, String defaultValue, String comment) {
        String spawnTypeEntries = this.getString(category, key, defaultValue);
        spawnTypeEntries = spawnTypeEntries.replace(" ", "");
        String[] spawners = spawnTypeEntries.split(",");
        ArrayList<EnumCreatureType> creatureTypeList = new ArrayList<EnumCreatureType>();
        for (String spawnTypeEntry : spawnTypeEntries.split(",")) {
            if ("MONSTER".equalsIgnoreCase(spawnTypeEntry)) {
                creatureTypeList.add(EnumCreatureType.MONSTER);
                continue;
            }
            if ("CREATURE".equalsIgnoreCase(spawnTypeEntry) || "ANIMAL".equalsIgnoreCase(spawnTypeEntry)) {
                creatureTypeList.add(EnumCreatureType.CREATURE);
                continue;
            }
            if ("WATERCREATURE".equalsIgnoreCase(spawnTypeEntry)) {
                creatureTypeList.add(EnumCreatureType.WATER_CREATURE);
                continue;
            }
            if (!"AMBIENT".equalsIgnoreCase(spawnTypeEntry)) continue;
            creatureTypeList.add(EnumCreatureType.AMBIENT);
        }
        EnumCreatureType[] creatureTypes = creatureTypeList.toArray(new EnumCreatureType[creatureTypeList.size()]);
        return new SpawnTypeSet(spawners, creatureTypes);
    }

    public SpawnDimensionSet getDimensions(String category, String key) {
        return this.getDimensions(category, key, "");
    }

    public SpawnDimensionSet getDimensions(String category, String key, String defaultValue) {
        return this.getDimensions(category, key, defaultValue, null);
    }

    public SpawnDimensionSet getDimensions(String category, String key, String defaultValue, String comment) {
        String dimensionEntries = this.getString(category, key, defaultValue);
        dimensionEntries = dimensionEntries.replace(" ", "");
        ArrayList<Integer> dimensionIDList = new ArrayList<Integer>();
        ArrayList<String> dimensionTypeList = new ArrayList<String>();
        for (String dimensionEntry : dimensionEntries.split(",")) {
            if (NumberUtils.isCreatable((String)dimensionEntry)) {
                dimensionIDList.add(Integer.parseInt(dimensionEntry.replace("+", "")));
                continue;
            }
            dimensionTypeList.add(dimensionEntry.replace("+", ""));
        }
        int[] dimensionIDs = ArrayUtils.toPrimitive((Integer[])dimensionIDList.toArray(new Integer[dimensionIDList.size()]));
        String[] dimensionTypes = dimensionTypeList.toArray(new String[dimensionTypeList.size()]);
        return new SpawnDimensionSet(dimensionIDs, dimensionTypes);
    }

    public Biome[] getBiomes(String category, String key) {
        return this.getBiomes(category, key, "");
    }

    public Biome[] getBiomes(String category, String key, String defaultValue) {
        return this.getBiomes(category, key, defaultValue, null);
    }

    public Biome[] getBiomes(String category, String key, String defaultValue, String comment) {
        String biomeEntries = this.getString(category, key, defaultValue, comment);
        biomeEntries = biomeEntries.replace(" ", "");
        ArrayList<BiomeDictionary.Type> biomeList = new ArrayList<BiomeDictionary.Type>();
        for (String biomeEntry : biomeEntries.split(",")) {
            if ("".equals(biomeEntry)) continue;
            boolean additive = true;
            if (biomeEntry.charAt(0) == '-' || biomeEntry.charAt(0) == '+') {
                if (biomeEntry.charAt(0) == '-') {
                    additive = false;
                }
                biomeEntry = biomeEntry.substring(1);
            }
            Object[] selectedBiomes = null;
            if ("ALL".equals(biomeEntry)) {
                for (BiomeDictionary.Type type : this.getAllBiomeTypes()) {
                    if (selectedBiomes == null) {
                        Set selectedBiomesSet = BiomeDictionary.getBiomes((BiomeDictionary.Type)type);
                        selectedBiomes = selectedBiomesSet.toArray(new Biome[selectedBiomesSet.size()]);
                        continue;
                    }
                    Set typeBiomesSet = BiomeDictionary.getBiomes((BiomeDictionary.Type)type);
                    Object[] typeBiomes = typeBiomesSet.toArray(new Biome[typeBiomesSet.size()]);
                    if (typeBiomes == null) continue;
                    selectedBiomes = (Biome[])ArrayUtils.addAll((Object[])selectedBiomes, (Object[])typeBiomes);
                }
            } else if ("GROUP".equals(biomeEntry)) {
                selectedBiomes = this.group.biomes;
            } else if (!"NONE".equals(biomeEntry)) {
                BiomeDictionary.Type biomeType;
                try {
                    biomeType = BiomeDictionary.Type.getType((String)biomeEntry, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                }
                catch (Exception e) {
                    biomeType = null;
                    LycanitesMobs.printWarning("", "[Config] Unknown biome type " + biomeEntry + " specified for " + defaultValue + "this will be ignored and treated as NONE.");
                }
                if (biomeType != null) {
                    Set selectedBiomesSet = BiomeDictionary.getBiomes((BiomeDictionary.Type)biomeType);
                    selectedBiomes = selectedBiomesSet.toArray(new Biome[selectedBiomesSet.size()]);
                }
            }
            if (selectedBiomes == null) continue;
            for (BiomeDictionary.Type type : selectedBiomes) {
                if (additive && !biomeList.contains(type)) {
                    biomeList.add(type);
                    continue;
                }
                if (additive || !biomeList.contains(type)) continue;
                biomeList.remove(type);
            }
        }
        return biomeList.toArray(new Biome[biomeList.size()]);
    }

    public BiomeDictionary.Type[] getBiomeTypes(boolean additive, String category, String key) {
        return this.getBiomeTypes(additive, category, key, "");
    }

    public BiomeDictionary.Type[] getBiomeTypes(boolean additive, String category, String key, String defaultValue) {
        return this.getBiomeTypes(additive, category, key, defaultValue, null);
    }

    public BiomeDictionary.Type[] getBiomeTypes(boolean additive, String category, String key, String defaultValue, String comment) {
        String biomeEntries = this.getString(category, key, defaultValue, comment);
        biomeEntries = biomeEntries.replace(" ", "");
        ArrayList<BiomeDictionary.Type> biomeTypeList = new ArrayList<BiomeDictionary.Type>();
        for (String biomeEntry : biomeEntries.split(",")) {
            BiomeDictionary.Type biomeType;
            if ("".equals(biomeEntry)) continue;
            if (biomeEntry.charAt(0) == '-' || biomeEntry.charAt(0) == '+') {
                if (biomeEntry.charAt(0) == '-' && additive || biomeEntry.charAt(0) == '+' && !additive) continue;
                biomeEntry = biomeEntry.substring(1);
            } else if (!additive) continue;
            if ("ALL".equals(biomeEntry)) {
                biomeTypeList.addAll(Arrays.asList(this.getAllBiomeTypes()));
                continue;
            }
            if ("GROUP".equals(biomeEntry)) {
                if (additive) {
                    biomeTypeList.addAll(Arrays.asList(this.group.biomeTypesAllowed));
                    continue;
                }
                biomeTypeList.addAll(Arrays.asList(this.group.biomeTypesDenied));
                continue;
            }
            if ("NONE".equals(biomeEntry)) continue;
            try {
                biomeType = BiomeDictionary.Type.getType((String)biomeEntry, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
            }
            catch (Exception e) {
                biomeType = null;
                LycanitesMobs.printWarning("", "[Config] Unknown biome type " + biomeEntry + " specified for " + defaultValue + "this will be ignored and treated as NONE.");
            }
            if (biomeType == null) continue;
            biomeTypeList.add(biomeType);
        }
        return biomeTypeList.toArray(new BiomeDictionary.Type[biomeTypeList.size()]);
    }

    public class SpawnDimensionSet {
        public int[] dimensionIDs;
        public String[] dimensionTypes;

        public SpawnDimensionSet(int[] dimensionIDs, String[] dimensionTypes) {
            this.dimensionIDs = dimensionIDs;
            this.dimensionTypes = dimensionTypes;
        }
    }

    public class SpawnTypeSet {
        public String[] spawners;
        public EnumCreatureType[] creatureTypes;

        public SpawnTypeSet(String[] spawners, EnumCreatureType[] creatureTypes) {
            this.spawners = spawners;
            this.creatureTypes = creatureTypes;
        }
    }
}

