/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.config;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.config.IConfigListener;
import com.lycanitesmobs.core.info.GroupInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ConfigBase {
    public static Map<String, ConfigBase> configs = new HashMap<String, ConfigBase>();
    public Configuration config;
    public GroupInfo group;
    public String configName;
    public String fileName;
    public String configFileName;
    public List<IConfigListener> updateListeners = new ArrayList<IConfigListener>();

    public static void versionCheck(String minVersion, String currentVersion) {
        ConfigBase versionConfig = ConfigBase.getConfig(LycanitesMobs.group, "version");
        String configVersion = versionConfig.getString("Version", "Config Version", "0.0.0.0", "The version that this config was last read from, manually update this if you do not want your config to be cleared, although it is recommended not to unless you are aware of the changes.");
        String[] minVersions = minVersion.split("\\.");
        String[] configVersions = configVersion.split("\\.");
        if (configVersions.length != 4) {
            configVersions = "0.0.0.0".split("\\.");
        }
        boolean oldVersion = false;
        for (int i = 0; i < 4; ++i) {
            int currentVerNum;
            int minVerNum = NumberUtils.isNumber((String)minVersions[i].replaceAll("[^\\d.]", "")) ? Integer.parseInt(minVersions[i].replaceAll("[^\\d.]", "")) : 0;
            int n = currentVerNum = NumberUtils.isNumber((String)configVersions[i].replaceAll("[^\\d.]", "")) ? Integer.parseInt(configVersions[i].replaceAll("[^\\d.]", "")) : 0;
            if (currentVerNum < minVerNum) {
                oldVersion = true;
                break;
            }
            if (currentVerNum > minVerNum) break;
        }
        if (oldVersion) {
            String configDirPath = LycanitesMobs.proxy.getMinecraftDir() + "/config/" + "lycanitesmobs";
            File configDir = new File(configDirPath);
            configDir.mkdir();
            LycanitesMobs.printWarning("", "[Config] The current config is too old, resetting config now...");
            try {
                FileUtils.cleanDirectory((File)configDir);
            }
            catch (IOException e) {
                LycanitesMobs.printWarning("", "[Config] Unable to clear the config directory! This could be a permissions/read-only issue!");
                e.printStackTrace();
            }
        }
        currentVersion = currentVersion.replace(" ", "");
        if (!configVersion.equals(currentVersion = currentVersion.split("-")[0])) {
            versionConfig.setString("Version", "Config Version", currentVersion);
        }
    }

    public static void registerConfig(ConfigBase config) {
        if (config == null) {
            return;
        }
        String configFileName = config.group.filename + "-" + config.fileName.toLowerCase();
        configs.put(configFileName, config);
    }

    public static ConfigBase getConfig(GroupInfo group, String configName) {
        String configFileName = group.filename + "-" + configName.toLowerCase();
        if (!configs.containsKey(configFileName)) {
            ConfigBase.registerConfig(new ConfigBase(group, configName));
        }
        return configs.get(configFileName);
    }

    public ConfigBase(GroupInfo group, String name) {
        this.group = group;
        this.configName = name;
        this.fileName = this.configName.toLowerCase();
        this.configFileName = group.filename + "-" + this.fileName;
        this.init();
    }

    public void init() {
        String configDirPath = LycanitesMobs.proxy.getMinecraftDir() + "/config/" + "lycanitesmobs";
        File configDir = new File(configDirPath);
        configDir.mkdir();
        File configFile = new File(configDirPath + "/" + this.configFileName + ".cfg");
        try {
            configFile.createNewFile();
            LycanitesMobs.printInfo("", "Config " + this.configFileName + " created successfully.");
        }
        catch (IOException e) {
            LycanitesMobs.printWarning("", "Config " + this.configFileName + " could not be created:");
            System.out.println(e);
            LycanitesMobs.printWarning("", "Make sure the config folder has write permissions or (if using Windows) isn't read only and that Minecraft is not in Program Files on a non-administrator account.");
        }
        this.config = new Configuration(configFile);
        this.config.load();
    }

    public void update() {
        this.config.save();
        for (IConfigListener updateListener : this.updateListeners) {
            if (updateListener == null) continue;
            updateListener.onConfigUpdate(this);
        }
    }

    public void addListener(IConfigListener listener) {
        if (!this.updateListeners.contains(listener)) {
            this.updateListeners.add(listener);
        }
    }

    public void setCategoryComment(String category, String comment) {
        category = category.toLowerCase();
        this.config.addCustomCategoryComment(category, comment);
    }

    public boolean getBool(String category, String key) {
        return this.getBool(category, key, false);
    }

    public boolean getBool(String category, String key, boolean defaultValue) {
        return this.getBool(category, key, defaultValue, null);
    }

    public boolean getBool(String category, String key, boolean defaultValue, String comment) {
        boolean newEntry = !this.config.getCategory(category = category.toLowerCase()).containsKey(key);
        Property property = this.config.get(category, key, defaultValue);
        if (comment != null) {
            property.setComment(comment);
        }
        if (newEntry) {
            this.config.save();
        }
        return property.getBoolean(defaultValue);
    }

    public int getInt(String category, String key) {
        return this.getInt(category, key, 0);
    }

    public int getInt(String category, String key, int defaultValue) {
        return this.getInt(category, key, defaultValue, null);
    }

    public int getInt(String category, String key, int defaultValue, String comment) {
        boolean newEntry = !this.config.getCategory(category = category.toLowerCase()).containsKey(key);
        Property property = this.config.get(category, key, defaultValue);
        if (comment != null) {
            property.setComment(comment);
        }
        if (newEntry) {
            this.config.save();
        }
        return property.getInt(defaultValue);
    }

    public double getDouble(String category, String key) {
        return this.getDouble(category, key, 0.0);
    }

    public double getDouble(String category, String key, double defaultValue) {
        return this.getDouble(category, key, defaultValue, null);
    }

    public double getDouble(String category, String key, double defaultValue, String comment) {
        boolean newEntry = !this.config.getCategory(category = category.toLowerCase()).containsKey(key);
        Property property = this.config.get(category, key, defaultValue);
        if (comment != null) {
            property.setComment(comment);
        }
        if (newEntry) {
            this.config.save();
        }
        return property.getDouble(defaultValue);
    }

    public String getString(String category, String key) {
        return this.getString(category, key, "");
    }

    public String getString(String category, String key, String defaultValue) {
        return this.getString(category, key, defaultValue, null);
    }

    public String getString(String category, String key, String defaultValue, String comment) {
        boolean newEntry = !this.config.getCategory(category = category.toLowerCase()).containsKey(key);
        Property property = this.config.get(category, key, defaultValue);
        if (comment != null) {
            property.setComment(comment);
        }
        if (newEntry) {
            this.config.save();
        }
        return property.getString();
    }

    public boolean[] getBoolList(String category, String key) {
        return this.getBoolList(category, key, new boolean[]{false});
    }

    public boolean[] getBoolList(String category, String key, boolean[] defaultValue) {
        return this.getBoolList(category, key, defaultValue, null);
    }

    public boolean[] getBoolList(String category, String key, boolean[] defaultValue, String comment) {
        boolean newEntry = !this.config.getCategory(category = category.toLowerCase()).containsKey(key);
        Property property = this.config.get(category, key, defaultValue);
        if (comment != null) {
            property.setComment(comment);
        }
        if (newEntry) {
            this.config.save();
        }
        return property.getBooleanList();
    }

    public int[] getIntList(String category, String key) {
        return this.getIntList(category, key, new int[]{0});
    }

    public int[] getIntList(String category, String key, int[] defaultValue) {
        return this.getIntList(category, key, defaultValue, null);
    }

    public int[] getIntList(String category, String key, int[] defaultValue, String comment) {
        boolean newEntry = !this.config.getCategory(category = category.toLowerCase()).containsKey(key);
        Property property = this.config.get(category, key, defaultValue);
        if (comment != null) {
            property.setComment(comment);
        }
        if (newEntry) {
            this.config.save();
        }
        return property.getIntList();
    }

    public double[] getDoubleList(String category, String key) {
        return this.getDoubleList(category, key, new double[]{0.0});
    }

    public double[] getDoubleList(String category, String key, double[] defaultValue) {
        return this.getDoubleList(category, key, defaultValue, null);
    }

    public double[] getDoubleList(String category, String key, double[] defaultValue, String comment) {
        boolean newEntry = !this.config.getCategory(category = category.toLowerCase()).containsKey(key);
        Property property = this.config.get(category, key, defaultValue);
        if (comment != null) {
            property.setComment(comment);
        }
        if (newEntry) {
            this.config.save();
        }
        return property.getDoubleList();
    }

    public String[] getStringList(String category, String key) {
        return this.getStringList(category, key, new String[]{""});
    }

    public String[] getStringList(String category, String key, String[] defaultValue) {
        return this.getStringList(category, key, defaultValue, null);
    }

    public String[] getStringList(String category, String key, String[] defaultValue, String comment) {
        boolean newEntry = !this.config.getCategory(category = category.toLowerCase()).containsKey(key);
        Property property = this.config.get(category, key, defaultValue);
        if (comment != null) {
            property.setComment(comment);
        }
        if (newEntry) {
            this.config.save();
        }
        return property.getStringList();
    }

    public void setBool(String category, String key, boolean value) {
        this.setBool(category, key, value, null);
    }

    public void setBool(String category, String key, boolean value, String comment) {
        category = category.toLowerCase();
        Property property = this.config.get(category, key, value);
        if (comment != null) {
            property.setComment(comment);
        }
        property.set(value);
        this.update();
    }

    public void setInt(String category, String key, int value) {
        this.setInt(category, key, value, null);
    }

    public void setInt(String category, String key, int value, String comment) {
        category = category.toLowerCase();
        Property property = this.config.get(category, key, value);
        if (comment != null) {
            property.setComment(comment);
        }
        property.set(value);
        this.update();
    }

    public void setDouble(String category, String key, double value) {
        this.setDouble(category, key, value, null);
    }

    public void setDouble(String category, String key, double value, String comment) {
        category = category.toLowerCase();
        Property property = this.config.get(category, key, value);
        if (comment != null) {
            property.setComment(comment);
        }
        property.set(value);
        this.update();
    }

    public void setString(String category, String key, String value) {
        this.setString(category, key, value, null);
    }

    public void setString(String category, String key, String value, String comment) {
        category = category.toLowerCase();
        Property property = this.config.get(category, key, value);
        if (comment != null) {
            property.setComment(comment);
        }
        property.set(value);
        this.update();
    }

    public void setList(String category, String key, Object[] objValues) {
        this.setList(category, key, objValues, null);
    }

    public void setList(String category, String key, Object[] objValues, String comment) {
        category = category.toLowerCase();
        ArrayList<String> valuesList = new ArrayList<String>();
        for (Object objValue : objValues) {
            valuesList.add(objValue.toString());
        }
        String[] values = valuesList.toArray(new String[valuesList.size()]);
        Property property = this.config.get(category, key, values);
        if (comment != null) {
            property.setComment(comment);
        }
        property.set(values);
        this.update();
    }
}

