/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.command;

import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.dungeon.DungeonManager;
import com.lycanitesmobs.core.info.Beastiary;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureKnowledge;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.mobevent.MobEvent;
import com.lycanitesmobs.core.mobevent.MobEventListener;
import com.lycanitesmobs.core.mobevent.MobEventManager;
import com.lycanitesmobs.core.mobevent.MobEventPlayerServer;
import com.lycanitesmobs.core.spawner.SpawnerEventListener;
import com.lycanitesmobs.core.spawner.SpawnerManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.math.NumberUtils;

public class CommandMain
implements ICommand {
    private List aliases = new ArrayList();

    public CommandMain() {
        this.aliases.add("lm");
        this.aliases.add("lycan");
        this.aliases.add("lycmobs");
        this.aliases.add("lycanmobs");
        this.aliases.add("lycanitesmobs");
    }

    public String func_71517_b() {
        return "lycanitesmobs";
    }

    public String func_71518_a(ICommandSender commandSender) {
        if (commandSender instanceof EntityPlayer) {
            return "/lycanitesmobs <sub-commands: mobevent [start <event name>, stop, list, enable, disable]>";
        }
        return "/lycanitesmobs <sub-commands: mobevent [start <event name> dimensionID, stop, list, enable, disable]>";
    }

    public List func_71514_a() {
        return this.aliases;
    }

    public List func_184883_a(MinecraftServer server, ICommandSender commandSender, String[] args, BlockPos pos) {
        return null;
    }

    public boolean func_82358_a(String[] p_82358_1_, int p_82358_2_) {
        return false;
    }

    public int compareTo(ICommand p_compareTo_1_) {
        return this.func_71517_b().compareTo(p_compareTo_1_.func_71517_b());
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) {
        String reply = I18n.func_74838_a((String)"lyc.command.invalid");
        if (args.length < 1) {
            commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
            commandSender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
            return;
        }
        if ("debug".equalsIgnoreCase(args[0])) {
            reply = I18n.func_74838_a((String)"lyc.command.debug.invalid");
            if (args.length < 3) {
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
            String debugValue = args[1];
            reply = I18n.func_74838_a((String)"lyc.command.debug.set");
            reply = reply.replace("%debug%", debugValue);
            LycanitesMobs.config.setBool("Debug", debugValue, "true".equalsIgnoreCase(args[2]));
            commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
            return;
        }
        if ("spawners".equalsIgnoreCase(args[0])) {
            reply = I18n.func_74838_a((String)"lyc.command.spawners.invalid");
            if (args.length < 2) {
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
            if ("reload".equalsIgnoreCase(args[1])) {
                reply = I18n.func_74838_a((String)"lyc.command.spawners.reload");
                SpawnerManager.getInstance().reload();
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
            if ("creative".equalsIgnoreCase(args[1])) {
                reply = I18n.func_74838_a((String)"lyc.command.spawners.creative");
                SpawnerEventListener.testOnCreative = !SpawnerEventListener.testOnCreative;
                reply = reply.replace("%value%", "" + SpawnerEventListener.testOnCreative);
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
        }
        if ("spawner".equalsIgnoreCase(args[0])) {
            reply = I18n.func_74838_a((String)"lyc.command.spawners.invalid");
            if (args.length < 2) {
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
            if ("reload".equalsIgnoreCase(args[1])) {
                reply = I18n.func_74838_a((String)"lyc.command.spawners.reload");
                SpawnerManager.getInstance().reload();
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
        }
        if ("dungeon".equalsIgnoreCase(args[0]) || "dungeons".equalsIgnoreCase(args[0])) {
            reply = I18n.func_74838_a((String)"lyc.command.dungeon.invalid");
            if (args.length < 2) {
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
            if ("reload".equalsIgnoreCase(args[1])) {
                reply = I18n.func_74838_a((String)"lyc.command.dungeon.reload");
                DungeonManager.getInstance().reload();
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
            if ("enable".equalsIgnoreCase(args[1])) {
                reply = I18n.func_74838_a((String)"lyc.command.dungeon.enable");
                ConfigBase config = ConfigBase.getConfig(LycanitesMobs.group, "general");
                config.setBool("Dungeons", "Dungeons Enabled", true);
                LycanitesMobs.dungeonGenerator.enabled = true;
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
            if ("disable".equalsIgnoreCase(args[1])) {
                reply = I18n.func_74838_a((String)"lyc.command.dungeon.disable");
                ConfigBase config = ConfigBase.getConfig(LycanitesMobs.group, "general");
                config.setBool("Dungeons", "Dungeons Enabled", false);
                LycanitesMobs.dungeonGenerator.enabled = false;
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
        }
        if ("creature".equalsIgnoreCase(args[0]) || "creatures".equalsIgnoreCase(args[0])) {
            reply = I18n.func_74838_a((String)"lyc.command.creatures.invalid");
            if (args.length < 2) {
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
            if ("reload".equalsIgnoreCase(args[1])) {
                reply = I18n.func_74838_a((String)"lyc.command.creatures.reload");
                CreatureManager.getInstance().reload();
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
        }
        if ("beastiary".equalsIgnoreCase(args[0])) {
            reply = I18n.func_74838_a((String)"lyc.command.beastiary.invalid");
            if (args.length < 2) {
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
            if (!(commandSender instanceof EntityPlayer)) {
                reply = I18n.func_74838_a((String)"lyc.command.playeronly");
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
            EntityPlayer player = (EntityPlayer)commandSender;
            ExtendedPlayer playerExt = ExtendedPlayer.getForPlayer(player);
            Beastiary beastiary = playerExt.getBeastiary();
            if (playerExt == null || beastiary == null) {
                return;
            }
            if ("add".equalsIgnoreCase(args[1])) {
                reply = I18n.func_74838_a((String)"lyc.command.beastiary.add.invalid");
                if (args.length < 3) {
                    commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                    return;
                }
                String creatureName = args[2].toLowerCase();
                CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(creatureName);
                if (creatureInfo == null) {
                    reply = I18n.func_74838_a((String)"lyc.command.beastiary.add.unknown");
                    commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                    return;
                }
                beastiary.addToKnowledgeList(new CreatureKnowledge(beastiary, creatureInfo.getName(), 1.0));
                beastiary.sendAddedMessage(creatureInfo);
                return;
            }
            if ("complete".equalsIgnoreCase(args[1])) {
                for (CreatureInfo creatureInfo : CreatureManager.getInstance().creatures.values()) {
                    beastiary.addToKnowledgeList(new CreatureKnowledge(beastiary, creatureInfo.getName(), 1.0));
                }
                beastiary.sendAllToClient();
                reply = I18n.func_74838_a((String)"lyc.command.beastiary.complete");
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
        }
        if ("mobevent".equalsIgnoreCase(args[0])) {
            ConfigBase config;
            reply = I18n.func_74838_a((String)"lyc.command.mobevent.invalid");
            if (args.length < 2) {
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
            if ("reload".equalsIgnoreCase(args[1])) {
                reply = I18n.func_74838_a((String)"lyc.command.mobevent.reload");
                MobEventManager.getInstance().reload();
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
            if ("creative".equalsIgnoreCase(args[1])) {
                reply = I18n.func_74838_a((String)"lyc.command.mobevent.creative");
                MobEventPlayerServer.testOnCreative = !MobEventPlayerServer.testOnCreative;
                reply = reply.replace("%value%", "" + MobEventPlayerServer.testOnCreative);
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
            if ("start".equalsIgnoreCase(args[1])) {
                reply = I18n.func_74838_a((String)"lyc.command.mobevent.start.invalid");
                if (args.length < 3) {
                    commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                    return;
                }
                String mobEventName = args[2].toLowerCase();
                if (MobEventManager.getInstance().mobEvents.containsKey(mobEventName)) {
                    Object world = null;
                    world = args.length >= 4 && NumberUtils.isNumber((String)args[3]) ? DimensionManager.getWorld((int)Integer.parseInt(args[3])) : commandSender.func_130014_f_();
                    if (world == null) {
                        reply = I18n.func_74838_a((String)"lyc.command.mobevent.start.noworld");
                        commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                        return;
                    }
                    ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
                    if (!MobEventManager.getInstance().mobEventsEnabled) {
                        reply = I18n.func_74838_a((String)"lyc.command.mobevent.enable");
                        commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                        MobEventManager.getInstance().mobEventsEnabled = true;
                        ConfigBase config2 = ConfigBase.getConfig(LycanitesMobs.group, "mobevents");
                        config2.setBool("Global", "Mob Events Enabled", true);
                    }
                    reply = I18n.func_74838_a((String)"lyc.command.mobevent.start");
                    commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                    EntityPlayer player = null;
                    BlockPos pos = new BlockPos(0, 0, 0);
                    if (commandSender instanceof EntityPlayer) {
                        player = (EntityPlayer)commandSender;
                        pos = player.func_180425_c();
                    }
                    int level = 1;
                    if (args.length >= 5 && NumberUtils.isNumber((String)args[4])) {
                        level = Integer.parseInt(args[4]);
                    }
                    worldExt.startMobEvent(mobEventName, player, pos, level);
                    return;
                }
                reply = I18n.func_74838_a((String)"lyc.command.mobevent.start.unknown");
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
            Object world = args.length >= 3 && NumberUtils.isNumber((String)args[2]) ? DimensionManager.getWorld((int)Integer.parseInt(args[2])) : commandSender.func_130014_f_();
            if (world == null) {
                reply = I18n.func_74838_a((String)"lyc.command.mobevent.start.noworld");
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                return;
            }
            LycanitesMobs.printDebug("", "Getting Extended World for Dimension: " + world.field_73011_w.getDimension() + " World: " + world);
            ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
            LycanitesMobs.printDebug("", "Got Extended World for Dimension: " + worldExt.world.field_73011_w.getDimension() + " World: " + worldExt.world);
            if (worldExt == null) {
                return;
            }
            if ("random".equalsIgnoreCase(args[1])) {
                reply = I18n.func_74838_a((String)"lyc.command.mobevent.random");
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                worldExt.stopWorldEvent();
                MobEventListener.getInstance().triggerRandomMobEvent((World)world, worldExt);
                return;
            }
            if ("stop".equalsIgnoreCase(args[1])) {
                reply = I18n.func_74838_a((String)"lyc.command.mobevent.stop");
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                worldExt.stopWorldEvent();
                return;
            }
            if ("list".equalsIgnoreCase(args[1])) {
                reply = I18n.func_74838_a((String)"lyc.command.mobevent.list");
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                for (MobEvent mobEvent : MobEventManager.getInstance().mobEvents.values()) {
                    String eventName = mobEvent.name + " (" + mobEvent.getTitle() + ")";
                    commandSender.func_145747_a((ITextComponent)new TextComponentString(eventName));
                }
                return;
            }
            if ("enable".equalsIgnoreCase(args[1])) {
                if (args.length >= 3 && "random".equalsIgnoreCase(args[2])) {
                    reply = I18n.func_74838_a((String)"lyc.command.mobevent.enable.random");
                    commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                    MobEventManager.getInstance().mobEventsRandom = true;
                    config = ConfigBase.getConfig(LycanitesMobs.group, "mobevents");
                    config.setBool("Global", "Random Mob Events", true);
                    return;
                }
                reply = I18n.func_74838_a((String)"lyc.command.mobevent.enable");
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                MobEventManager.getInstance().mobEventsEnabled = true;
                config = ConfigBase.getConfig(LycanitesMobs.group, "mobevents");
                config.setBool("Global", "Mob Events Enabled", true);
                return;
            }
            if ("disable".equalsIgnoreCase(args[1])) {
                if (args.length >= 3 && "random".equalsIgnoreCase(args[2])) {
                    reply = I18n.func_74838_a((String)"lyc.command.mobevent.disable.random");
                    commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                    MobEventManager.getInstance().mobEventsRandom = false;
                    config = ConfigBase.getConfig(LycanitesMobs.group, "mobevents");
                    config.setBool("Global", "Random Mob Events", false);
                    return;
                }
                reply = I18n.func_74838_a((String)"lyc.command.mobevent.disable");
                commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
                MobEventManager.getInstance().mobEventsEnabled = false;
                config = ConfigBase.getConfig(LycanitesMobs.group, "mobevents");
                config.setBool("Global", "Mob Events Enabled", false);
                return;
            }
        }
        commandSender.func_145747_a((ITextComponent)new TextComponentString(reply));
        commandSender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
    }

    public int getRequiredPermissionLevel() {
        return 4;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender commandSender) {
        return !(commandSender instanceof EntityPlayer) || commandSender.func_70003_b(this.getRequiredPermissionLevel(), this.func_71517_b());
    }
}

