/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class VersionChecker {
    public static boolean enabled = true;

    public static VersionInfo getLatestVersion() {
        VersionInfo currentVersion = new VersionInfo("1.19.1.2", "1.12.2");
        VersionInfo latestVersion = null;
        try {
            URL url = new URL("http://api.lycanitesmobs.com/latest");
            URLConnection urlConnection = url.openConnection();
            urlConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.89 Safari/537.36");
            String jsonString = null;
            try (InputStream inputStream = urlConnection.getInputStream();){
                jsonString = IOUtils.toString((InputStream)inputStream, (Charset)null);
            }
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonElement = jsonParser.parse(jsonString);
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            String latestVersionNumber = jsonObject.get("version").getAsString();
            String latestVersionMC = jsonObject.get("mcversion").getAsString();
            latestVersion = new VersionInfo(latestVersionNumber, latestVersionMC);
            latestVersion.checkIfNewer(currentVersion);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (latestVersion == null) {
            return currentVersion;
        }
        return latestVersion;
    }

    public static class VersionInfo {
        public String versionNumber;
        public String versionMC;
        public boolean isNewer = false;

        public VersionInfo(String number, String mc) {
            this.versionNumber = number;
            this.versionMC = mc;
        }

        public void checkIfNewer(VersionInfo compareVersion) {
            this.isNewer = false;
            String[] versions = this.versionNumber.split("\\.");
            String[] compareVersions = compareVersion.versionNumber.split("\\.");
            for (int i = 0; i < 4; ++i) {
                int compareVersionNumber;
                int versionNumber = NumberUtils.isCreatable((String)versions[i].replaceAll("[^\\d.]", "")) ? Integer.parseInt(versions[i].replaceAll("[^\\d.]", "")) : 0;
                int n = compareVersionNumber = NumberUtils.isCreatable((String)compareVersions[i].replaceAll("[^\\d.]", "")) ? Integer.parseInt(compareVersions[i].replaceAll("[^\\d.]", "")) : 0;
                if (versionNumber > compareVersionNumber) {
                    this.isNewer = true;
                    return;
                }
                if (versionNumber == compareVersionNumber) continue;
                return;
            }
        }
    }
}

