/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.Utilities;
import com.lycanitesmobs.core.info.GroupInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.JsonUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public abstract class JSONLoader {
    public void loadAllJson(GroupInfo groupInfo, String name, String assetPath, String mapKey, boolean loadCustom) {
        LycanitesMobs.printDebug(name, "Loading JSON " + name + "...");
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        HashMap<String, JsonObject> jsons = new HashMap<String, JsonObject>();
        Path path = Utilities.getAssetPath(groupInfo.getClass(), groupInfo.filename, assetPath);
        HashMap<String, JsonObject> defaultJsons = new HashMap<String, JsonObject>();
        this.loadJsonObjects(gson, path, defaultJsons, mapKey, null);
        String configPath = LycanitesMobs.proxy.getMinecraftDir() + "/config/" + "lycanitesmobs" + "/";
        File customDir = new File(configPath + assetPath);
        customDir.mkdirs();
        path = customDir.toPath();
        HashMap<String, JsonObject> customJsons = new HashMap<String, JsonObject>();
        this.loadJsonObjects(gson, path, customJsons, mapKey, null);
        this.writeDefaultJSONObjects(gson, defaultJsons, customJsons, jsons, loadCustom, assetPath);
        LycanitesMobs.printDebug(name, "Loading " + jsons.size() + " " + name + "...");
        for (String jsonName : jsons.keySet()) {
            try {
                JsonObject json = (JsonObject)jsons.get(jsonName);
                LycanitesMobs.printDebug(name, "Loading " + name + " JSON: " + json);
                this.parseJson(groupInfo, name, json);
            }
            catch (JsonParseException e) {
                LycanitesMobs.printWarning("", "Parsing error loading JSON " + name + ": " + jsonName);
                e.printStackTrace();
            }
            catch (Exception e) {
                LycanitesMobs.printWarning("", "There was a problem loading JSON " + name + ": " + jsonName);
                e.printStackTrace();
            }
        }
    }

    public abstract void parseJson(GroupInfo var1, String var2, JsonObject var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadJsonObjects(Gson gson, Path path, Map<String, JsonObject> jsonObjectMap, String mapKey, String jsonType) {
        if (path == null) {
            return;
        }
        try {
            Iterator iterator = Files.walk(path, new FileVisitOption[0]).iterator();
            while (iterator.hasNext()) {
                Path filePath = (Path)iterator.next();
                Path relativePath = path.relativize(filePath);
                if (!"json".equals(FilenameUtils.getExtension((String)filePath.toString()))) continue;
                BufferedReader reader = null;
                try {
                    try {
                        reader = Files.newBufferedReader(filePath);
                        JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)gson, (Reader)reader, JsonObject.class);
                        boolean validJSON = true;
                        if (jsonType != null) {
                            validJSON = !json.has("type") ? false : jsonType.equalsIgnoreCase(json.get("type").getAsString());
                        }
                        if (!validJSON) continue;
                        jsonObjectMap.put(json.get(mapKey).getAsString(), json);
                    }
                    catch (JsonParseException e) {
                        LycanitesMobs.printWarning("", "Parsing error loading JSON " + relativePath + "\n" + e.toString());
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        LycanitesMobs.printWarning("", "There was a problem loading JSON " + relativePath + "\n" + e.toString());
                        e.printStackTrace();
                    }
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
        }
        catch (Exception e) {
            LycanitesMobs.printWarning("", "Unable to read files from directory.\n" + e.toString());
        }
    }

    public void writeDefaultJSONObjects(Gson gson, Map<String, JsonObject> defaultJSONs, Map<String, JsonObject> customJSONs, Map<String, JsonObject> mixedJSONs, boolean custom, String assetPath) {
        for (String jsonName : defaultJSONs.keySet()) {
            try {
                JsonObject defaultJSON = defaultJSONs.get(jsonName);
                boolean loadDefault = true;
                JsonObject customJSON = null;
                if (customJSONs.containsKey(jsonName)) {
                    loadDefault = false;
                    customJSON = customJSONs.get(jsonName);
                    if (customJSON.has("loadDefault")) {
                        loadDefault = customJSON.get("loadDefault").getAsBoolean();
                    }
                }
                if (loadDefault) {
                    this.saveJsonObject(gson, defaultJSON, jsonName, assetPath);
                    mixedJSONs.put(jsonName, defaultJSON);
                    continue;
                }
                if (customJSON == null) continue;
                mixedJSONs.put(jsonName, customJSON);
            }
            catch (JsonParseException e) {
                LycanitesMobs.printWarning("", "Parsing error loading JSON: " + jsonName);
                e.printStackTrace();
            }
            catch (Exception e) {
                LycanitesMobs.printWarning("", "There was a problem loading JSON: " + jsonName);
                e.printStackTrace();
            }
        }
        if (custom) {
            for (String jsonName : customJSONs.keySet()) {
                if (defaultJSONs.containsKey(jsonName)) continue;
                mixedJSONs.put(jsonName, customJSONs.get(jsonName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonObject loadJsonObject(Gson gson, Path path) {
        if (path == null) {
            return null;
        }
        try {
            Path relativePath = path.relativize(path);
            BufferedReader reader = null;
            try {
                JsonObject json;
                reader = Files.newBufferedReader(path);
                JsonObject jsonObject = json = (JsonObject)JsonUtils.func_193839_a((Gson)gson, (Reader)reader, JsonObject.class);
                return jsonObject;
            }
            catch (JsonParseException e) {
                LycanitesMobs.printWarning("", "Parsing error loading JSON " + relativePath + "\n" + e.toString());
                e.printStackTrace();
                return null;
            }
            catch (Exception e) {
                LycanitesMobs.printWarning("", "There was a problem loading JSON " + relativePath + "\n" + e.toString());
                e.printStackTrace();
                return null;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        catch (Exception e) {
            LycanitesMobs.printWarning("", "Unable to read file from path.\n" + e.toString());
        }
        return null;
    }

    public JsonObject writeDefaultJSONObject(Gson gson, String jsonName, JsonObject defaultJSON, JsonObject customJSON) {
        try {
            boolean loadDefault = true;
            if (customJSON != null) {
                loadDefault = false;
                if (customJSON.has("loadDefault")) {
                    loadDefault = customJSON.get("loadDefault").getAsBoolean();
                }
            }
            if (loadDefault) {
                this.saveJsonObject(gson, defaultJSON, jsonName, "");
                return defaultJSON;
            }
            if (customJSON != null) {
                return customJSON;
            }
        }
        catch (JsonParseException e) {
            LycanitesMobs.printWarning("", "Parsing error loading JSON: " + jsonName);
            e.printStackTrace();
        }
        catch (Exception e) {
            LycanitesMobs.printWarning("", "There was a problem loading JSON: " + jsonName);
            e.printStackTrace();
        }
        return null;
    }

    public void saveJsonObject(Gson gson, JsonObject jsonObject, String name, String assetPath) {
        String configPath = LycanitesMobs.proxy.getMinecraftDir() + "/config/" + "lycanitesmobs" + "/";
        try {
            File jsonFile = new File(configPath + (!"".equals(assetPath) ? assetPath + "/" : "") + name + ".json");
            jsonFile.getParentFile().mkdirs();
            jsonFile.createNewFile();
            FileOutputStream outputStream = new FileOutputStream(jsonFile);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            outputStreamWriter.append(gson.toJson((JsonElement)jsonObject));
            outputStreamWriter.close();
            outputStream.close();
        }
        catch (Exception e) {
            LycanitesMobs.printWarning("", "Unable to save JSON into the config folder.");
            e.printStackTrace();
        }
    }
}

