/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.arcticmobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupAlpha;
import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupFire;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.api.IGroupIce;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.arcticmobs.entity.EntityBlizzard;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.EntityProjectileRapidFire;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackRanged;
import com.lycanitesmobs.core.entity.ai.EntityAIBeg;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAIStealth;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITempt;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntitySerpix
extends EntityCreatureTameable
implements IGroupPredator,
IGroupIce,
IGroupHeavy {
    public EntitySerpix(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.ARTHROPOD;
        this.spawnsOnLand = true;
        this.spawnsInWater = true;
        this.hasAttackSound = false;
        this.babySpawnChance = 0.25;
        this.growthTime = -120000;
        this.setupMob();
        this.hitAreaWidthScale = 1.5f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this).setSink(true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIStealth(this).setStealthTime(60));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(8.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt(this).setItem(new ItemStack(ObjectManager.getItem("serpixtreat"))).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackRanged(this).setSpeed(0.5).setStaminaTime(100).setRange(12.0f).setMinChaseDistance(8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIBeg(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupAlpha.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupFire.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityBlaze.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityMagmaCube.class));
        if (CreatureManager.getInstance().config.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupAnimal.class));
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityAnimal.class));
        }
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    public float getAISpeedModifier() {
        if (this.func_70090_H()) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public void attackRanged(Entity target, float range) {
        ArrayList<EntityProjectileRapidFire> projectiles = new ArrayList<EntityProjectileRapidFire>();
        EntityProjectileRapidFire projectileEntry = new EntityProjectileRapidFire(EntityBlizzard.class, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectiles.add(projectileEntry);
        EntityProjectileRapidFire projectileEntry2 = new EntityProjectileRapidFire(EntityBlizzard.class, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectileEntry2.offsetX += 1.0;
        projectiles.add(projectileEntry2);
        EntityProjectileRapidFire projectileEntry3 = new EntityProjectileRapidFire(EntityBlizzard.class, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectileEntry3.offsetX -= 1.0;
        projectiles.add(projectileEntry3);
        EntityProjectileRapidFire projectileEntry4 = new EntityProjectileRapidFire(EntityBlizzard.class, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectileEntry4.offsetZ += 1.0;
        projectiles.add(projectileEntry4);
        EntityProjectileRapidFire projectileEntry5 = new EntityProjectileRapidFire(EntityBlizzard.class, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectileEntry5.offsetZ -= 1.0;
        projectiles.add(projectileEntry5);
        EntityProjectileRapidFire projectileEntry6 = new EntityProjectileRapidFire(EntityBlizzard.class, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectileEntry6.offsetY += 1.0;
        projectiles.add(projectileEntry6);
        EntityProjectileRapidFire projectileEntry7 = new EntityProjectileRapidFire(EntityBlizzard.class, this.func_130014_f_(), (EntityLivingBase)this, 15, 3);
        projectileEntry7.offsetY -= 10.0;
        projectiles.add(projectileEntry7);
        BlockPos launchPos = this.getFacingPosition(4.0);
        for (EntityProjectileRapidFire projectile : projectiles) {
            projectile.setProjectileScale(1.0f);
            projectile.field_70163_u -= (double)(this.field_70131_O / 4.0f);
            float accuracy = 1.0f * (this.func_70681_au().nextFloat() - 0.5f);
            double d0 = target.field_70165_t - (double)launchPos.func_177958_n() + (double)accuracy;
            double d1 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - projectile.field_70163_u + (double)accuracy;
            double d2 = target.field_70161_v - (double)launchPos.func_177952_p() + (double)accuracy;
            float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
            float velocity = 1.2f;
            projectile.func_70186_c(d0, d1 + (double)f1, d2, velocity, 6.0f);
            this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            projectile.func_70107_b(launchPos.func_177958_n(), launchPos.func_177956_o(), launchPos.func_177952_p());
            this.func_130014_f_().func_72838_d((Entity)projectile);
        }
        super.attackRanged(target, range);
    }

    @Override
    public boolean canStealth() {
        if (this.isTamed() && this.isSitting()) {
            return false;
        }
        IBlockState blockState = this.func_130014_f_().func_180495_p(this.func_180425_c().func_177982_a(0, -1, 0));
        if (blockState.func_177230_c() != Blocks.field_150350_a) {
            if (blockState.func_185904_a() == Material.field_151578_c) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151577_b) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151584_j) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151595_p) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151571_B) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151597_y) {
                return true;
            }
            if (blockState.func_185904_a() == Material.field_151596_z) {
                return true;
            }
        }
        return blockState.func_177230_c() == Blocks.field_150424_aL;
    }

    @Override
    public boolean canBeTempted() {
        return this.func_70631_g_();
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("ooze")) {
            return false;
        }
        if (type.equals("cactus")) {
            return false;
        }
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable baby) {
        return new EntitySerpix(this.func_130014_f_());
    }

    @Override
    public boolean isBreedingItem(ItemStack par1ItemStack) {
        return false;
    }

    @Override
    public boolean isTamingItem(ItemStack itemstack) {
        if (!this.func_70631_g_()) {
            return false;
        }
        return itemstack.func_77973_b() == ObjectManager.getItem("serpixtreat");
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("CookedMeat", testStack);
    }
}

