/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.arcticmobs;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.arcticmobs.CommonSubProxy;
import com.lycanitesmobs.arcticmobs.block.BlockFluidOoze;
import com.lycanitesmobs.arcticmobs.block.BlockFrostCloud;
import com.lycanitesmobs.arcticmobs.block.BlockFrostfire;
import com.lycanitesmobs.arcticmobs.block.BlockFrostweb;
import com.lycanitesmobs.arcticmobs.block.BlockIcefire;
import com.lycanitesmobs.arcticmobs.dispenser.DispenserBehaviorBlizzard;
import com.lycanitesmobs.arcticmobs.dispenser.DispenserBehaviorFrostweb;
import com.lycanitesmobs.arcticmobs.dispenser.DispenserBehaviorIcefire;
import com.lycanitesmobs.arcticmobs.dispenser.DispenserBehaviorTundra;
import com.lycanitesmobs.arcticmobs.entity.EntityBlizzard;
import com.lycanitesmobs.arcticmobs.entity.EntityFrostweb;
import com.lycanitesmobs.arcticmobs.entity.EntityIcefireball;
import com.lycanitesmobs.arcticmobs.entity.EntityTundra;
import com.lycanitesmobs.arcticmobs.item.ItemArcticEgg;
import com.lycanitesmobs.arcticmobs.item.ItemBlizzardCharge;
import com.lycanitesmobs.arcticmobs.item.ItemBucketOoze;
import com.lycanitesmobs.arcticmobs.item.ItemFrostwebCharge;
import com.lycanitesmobs.arcticmobs.item.ItemFrostyFur;
import com.lycanitesmobs.arcticmobs.item.ItemIcefireCharge;
import com.lycanitesmobs.arcticmobs.item.ItemScepterBlizzard;
import com.lycanitesmobs.arcticmobs.item.ItemScepterFrostweb;
import com.lycanitesmobs.arcticmobs.item.ItemScepterIcefire;
import com.lycanitesmobs.arcticmobs.item.ItemScepterTundra;
import com.lycanitesmobs.arcticmobs.item.ItemTundraCharge;
import com.lycanitesmobs.arcticmobs.worldgen.WorldGeneratorArctic;
import com.lycanitesmobs.core.Submod;
import com.lycanitesmobs.core.dispenser.DispenserBehaviorMobEggCustom;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.item.ItemCustomFood;
import com.lycanitesmobs.core.item.ItemTreat;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="arcticmobs", name="Lycanites Arctic Mobs", version="1.19.1.2 - MC 1.12.2", dependencies="required-after:lycanitesmobs", acceptedMinecraftVersions="[1.12,1.13)")
public class ArcticMobs
extends Submod {
    public static final String modid = "arcticmobs";
    public static final String name = "Lycanites Arctic Mobs";
    @Mod.Instance(value="arcticmobs")
    public static ArcticMobs instance;
    @SidedProxy(clientSide="com.lycanitesmobs.arcticmobs.ClientSubProxy", serverSide="com.lycanitesmobs.arcticmobs.CommonSubProxy")
    public static CommonSubProxy proxy;

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorArctic(), (int)0);
    }

    @Override
    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        super.registerEntities(event);
    }

    @Override
    public void initialSetup() {
        this.group = new GroupInfo(this, "Arctic Mobs", 6).setDimensionBlacklist("-1,1").setBiomes("COLD, SNOWY, CONIFEROUS, -END").setDungeonThemes("FROZEN, DUNGEON").setEggName("arcticspawn");
        this.group.loadFromConfig();
    }

    @Override
    public void createItems() {
        AssetManager.addSound("ooze", this.group, "block.ooze");
        ObjectManager.addDamageSource("ooze", new DamageSource("ooze"));
        Fluid fluid = ObjectManager.addFluid("ooze");
        fluid.setLuminosity(10).setDensity(3000).setViscosity(5000).setTemperature(0);
        ObjectManager.addBlock("ooze", (Block)new BlockFluidOoze(fluid));
        ObjectManager.addItem("arcticspawn", new ItemArcticEgg());
        ObjectManager.addItem("yetimeatraw", (Item)new ItemCustomFood("yetimeatraw", this.group, 2, 0.5f, ItemCustomFood.FOOD_CLASS.RAW).setPotionEffect(MobEffects.field_76421_d, 45, 2, 0.8f));
        ObjectLists.addItem("rawmeat", ObjectManager.getItem("yetimeatraw"));
        ObjectManager.addItem("yetimeatcooked", (Item)new ItemCustomFood("yetimeatcooked", this.group, 6, 0.7f, ItemCustomFood.FOOD_CLASS.COOKED).setPotionEffect(MobEffects.field_76429_m, 60, 2, 1.0f).setAlwaysEdible());
        ObjectLists.addItem("cookedmeat", ObjectManager.getItem("yetimeatcooked"));
        ObjectManager.addItem("palesoup", new ItemCustomFood("palesoup", this.group, 6, 0.7f, ItemCustomFood.FOOD_CLASS.MEAL).setPotionEffect(MobEffects.field_76429_m, 600, 2, 1.0f).setAlwaysEdible().func_77625_d(16), 3, 1, 6);
        ObjectLists.addItem("cookedmeat", ObjectManager.getItem("palesoup"));
        ObjectManager.addItem("frostyfur", new ItemFrostyFur());
        ObjectManager.addItem("frostwebcharge", new ItemFrostwebCharge());
        ObjectManager.addItem("frostwebscepter", new ItemScepterFrostweb(), 2, 1, 1);
        ObjectManager.addItem("tundracharge", new ItemTundraCharge());
        ObjectManager.addItem("tundrascepter", new ItemScepterTundra(), 2, 1, 1);
        ObjectManager.addItem("icefirecharge", new ItemIcefireCharge());
        ObjectManager.addItem("icefirescepter", new ItemScepterIcefire(), 2, 1, 1);
        ObjectManager.addItem("blizzardcharge", new ItemBlizzardCharge());
        ObjectManager.addItem("blizzardscepter", new ItemScepterBlizzard(), 2, 1, 1);
        ObjectManager.addItem("arixtreat", new ItemTreat("arixtreat", this.group));
        ObjectManager.addItem("serpixtreat", new ItemTreat("serpixtreat", this.group));
        ObjectManager.addItem("maugtreat", new ItemTreat("maugtreat", this.group));
        ObjectManager.addItem("bucketooze", new ItemBucketOoze(fluid).func_77642_a(Items.field_151133_ar));
    }

    @Override
    public void createBlocks() {
        ObjectManager.addBlock("frostweb", new BlockFrostweb());
        AssetManager.addSound("frostcloud", this.group, "block.frostcloud");
        ObjectManager.addBlock("frostcloud", new BlockFrostCloud());
        AssetManager.addSound("frostfire", this.group, "block.frostfire");
        ObjectManager.addBlock("frostfire", new BlockFrostfire());
        AssetManager.addSound("icefire", this.group, "block.icefire");
        ObjectManager.addBlock("icefire", new BlockIcefire());
    }

    @Override
    public void createEntities() {
        BlockDispenser.field_149943_a.func_82595_a((Object)ObjectManager.getItem("arcticspawn"), (Object)new DispenserBehaviorMobEggCustom());
        ObjectManager.addProjectile("frostweb", EntityFrostweb.class, ObjectManager.getItem("frostwebcharge"), new DispenserBehaviorFrostweb());
        ObjectManager.addProjectile("tundra", EntityTundra.class, ObjectManager.getItem("tundracharge"), new DispenserBehaviorTundra());
        ObjectManager.addProjectile("icefireball", EntityIcefireball.class, ObjectManager.getItem("icefirecharge"), new DispenserBehaviorIcefire());
        ObjectManager.addProjectile("blizzard", EntityBlizzard.class, ObjectManager.getItem("blizzardcharge"), new DispenserBehaviorBlizzard());
    }

    @Override
    public void registerModels() {
        proxy.registerModels(this.group);
    }

    @Override
    public void registerOres() {
        OreDictionary.registerOre((String)"listAllporkraw", (Item)ObjectManager.getItem("yetimeatraw"));
        OreDictionary.registerOre((String)"listAllporkcooked", (Item)ObjectManager.getItem("yetimeatcooked"));
    }

    @Override
    public void addRecipes() {
        GameRegistry.addSmelting((Item)ObjectManager.getItem("yetimeatraw"), (ItemStack)new ItemStack(ObjectManager.getItem("yetimeatcooked"), 1), (float)0.5f);
    }

    @Override
    public void editVanillaSpawns() {
        EntityRegistry.removeSpawn(EntityZombie.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])this.group.biomes);
        EntityRegistry.removeSpawn(EntityCreeper.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])this.group.biomes);
        EntityRegistry.removeSpawn(EntitySpider.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])this.group.biomes);
        EntityRegistry.removeSpawn(EntityWitch.class, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])this.group.biomes);
    }
}

