/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.config.ConfigBase;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.io.FilenameUtils;

public class Utilities {
    protected static Calendar easterCalendar;

    public static void addDungeonLoot(ItemStack itemStack, int minAmount, int maxAmount, int weight) {
        ConfigBase config = LycanitesMobs.config;
        config.setCategoryComment("Dungeon Loot Enabled", "Here you can enable/disable dungeon loot for various types of dungeons.");
        if (config.getBool("Dungeon Loot Enabled", "Dungeons", true, "These are most dungeons from underground mob spawner dungeons to pyramids, mineshafts and jungle temples.")) {
            // empty if block
        }
    }

    public static void addStrongholdLoot(ItemStack itemStack, int minAmount, int maxAmount, int weight) {
        ConfigBase config = LycanitesMobs.config;
        if (config.getBool("Dungeon Loot Enabled", "Strongholds", true, "Stronghold dungeons including corridors, libraries and other parts.")) {
            // empty if block
        }
    }

    public static void addVillageLoot(ItemStack itemStack, int minAmount, int maxAmount, int weight) {
        ConfigBase config = LycanitesMobs.config;
        if (config.getBool("Dungeon Loot Enabled", "Blacksmiths", true, "These are the chests found in village blacksmiths homes.")) {
            // empty if block
        }
    }

    public static RayTraceResult raytrace(World world, double x, double y, double z, double tx, double ty, double tz, float borderSize, HashSet<Entity> excluded) {
        Vec3d startVec = new Vec3d(x, y, z);
        Vec3d lookVec = new Vec3d(tx - x, ty - y, tz - z);
        Vec3d endVec = new Vec3d(tx, ty, tz);
        float minX = (float)(x < tx ? x : tx);
        float minY = (float)(y < ty ? y : ty);
        float minZ = (float)(z < tz ? z : tz);
        float maxX = (float)(x > tx ? x : tx);
        float maxY = (float)(y > ty ? y : ty);
        float maxZ = (float)(z > tz ? z : tz);
        RayTraceResult collision = world.func_72901_a(startVec, endVec, false);
        startVec = new Vec3d(x, y, z);
        endVec = new Vec3d(tx, ty, tz);
        float maxDistance = (float)endVec.func_72438_d(startVec);
        if (collision != null) {
            maxDistance = (float)collision.field_72307_f.func_72438_d(startVec);
        }
        if (excluded != null) {
            AxisAlignedBB bb = new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72321_a((double)borderSize, (double)borderSize, (double)borderSize);
            List allEntities = world.func_72839_b(null, bb);
            Entity closestHitEntity = null;
            float closestHit = Float.POSITIVE_INFINITY;
            for (Entity ent : allEntities) {
                float currentHit;
                RayTraceResult intercept;
                if (!ent.func_70067_L() || excluded.contains(ent)) continue;
                float entBorder = ent.func_70111_Y();
                AxisAlignedBB entityBb = ent.func_174813_aQ();
                if (entityBb == null || (intercept = (entityBb = entityBb.func_72321_a((double)entBorder, (double)entBorder, (double)entBorder)).func_72327_a(startVec, endVec)) == null || !((currentHit = (float)intercept.field_72307_f.func_72438_d(startVec)) < closestHit) && currentHit != 0.0f) continue;
                closestHit = currentHit;
                closestHitEntity = ent;
            }
            if (closestHitEntity != null) {
                collision = new RayTraceResult(closestHitEntity);
            }
        }
        return collision;
    }

    public static RayTraceResult raytraceEntities(World world, double x, double y, double z, double tx, double ty, double tz, float borderSize, HashSet<Entity> excluded) {
        Vec3d startVec = new Vec3d(x, y, z);
        Vec3d lookVec = new Vec3d(tx - x, ty - y, tz - z);
        Vec3d endVec = new Vec3d(tx, ty, tz);
        float minX = (float)(x < tx ? x : tx);
        float minY = (float)(y < ty ? y : ty);
        float minZ = (float)(z < tz ? z : tz);
        float maxX = (float)(x > tx ? x : tx);
        float maxY = (float)(y > ty ? y : ty);
        float maxZ = (float)(z > tz ? z : tz);
        AxisAlignedBB bb = new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72321_a((double)borderSize, (double)borderSize, (double)borderSize);
        List allEntities = world.func_72839_b(null, bb);
        RayTraceResult collision = world.func_72901_a(startVec, endVec, false);
        Entity closestHitEntity = null;
        float closestHit = Float.POSITIVE_INFINITY;
        float currentHit = 0.0f;
        for (Entity ent : allEntities) {
            RayTraceResult intercept;
            if (!ent.func_70067_L() || excluded.contains(ent)) continue;
            float entBorder = ent.func_70111_Y();
            AxisAlignedBB entityBb = ent.func_174813_aQ();
            if (entityBb == null || (intercept = (entityBb = entityBb.func_72321_a((double)entBorder, (double)entBorder, (double)entBorder)).func_72327_a(startVec, endVec)) == null || !((currentHit = (float)intercept.field_72307_f.func_72438_d(startVec)) < closestHit) && currentHit != 0.0f) continue;
            closestHit = currentHit;
            closestHitEntity = ent;
        }
        if (closestHitEntity != null) {
            collision = new RayTraceResult(closestHitEntity);
        }
        return collision;
    }

    public static boolean isValentines() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 1 && calendar.get(5) >= 7 && calendar.get(5) <= 14;
    }

    public static boolean isEaster() {
        long daysUntilEaster;
        Calendar calendar = Calendar.getInstance();
        if (easterCalendar == null) {
            int Y = calendar.get(1);
            int a = Y % 19;
            int b = Y / 100;
            int c = Y % 100;
            int d = b / 4;
            int e = b % 4;
            int f = (b + 8) / 25;
            int g = (b - f + 1) / 3;
            int h = (19 * a + b - d - g + 15) % 30;
            int i = c / 4;
            int k = c % 4;
            int L = (32 + 2 * e + 2 * i - h - k) % 7;
            int m = (a + 11 * h + 22 * L) / 451;
            int easterMonth = (h + L - 7 * m + 114) / 31;
            int easterDay = (h + L - 7 * m + 114) % 31 + 1;
            easterCalendar = new GregorianCalendar(Y, easterMonth, easterDay);
        }
        return (daysUntilEaster = ChronoUnit.DAYS.between(calendar.toInstant(), easterCalendar.toInstant())) <= 7L && daysUntilEaster >= 0L;
    }

    public static boolean isMidsummer() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 6 && calendar.get(5) >= 10 && calendar.get(5) <= 20;
    }

    public static boolean isHalloween() {
        block4: {
            block3: {
                Calendar calendar;
                block2: {
                    calendar = Calendar.getInstance();
                    if (calendar.get(5) < 25) break block2;
                    if (calendar.get(2) == 9) break block3;
                }
                if (calendar.get(5) != 1) break block4;
                if (calendar.get(2) != 10) break block4;
            }
            return true;
        }
        return false;
    }

    public static boolean isYuletide() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 11 && calendar.get(5) >= 10 && calendar.get(5) <= 25;
    }

    public static boolean isYuletidePeak() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 11 && calendar.get(5) == 25;
    }

    public static boolean isNewYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 0 && calendar.get(5) == 1;
    }

    public static int daysBetween(Date d1, Date d2) {
        return (int)((d2.getTime() - d1.getTime()) / 86400000L);
    }

    public static Path getAssetPath(Class clazz, String assetDomain, String assetPath) {
        Path path;
        block6: {
            path = null;
            String assetDir = "/assets/" + assetDomain + (!"".equals(assetPath) ? "/" + assetPath : "");
            try {
                FileSystem filesystem;
                URL url = clazz.getResource("/assets/" + assetDomain + "/.root");
                URI uri = url.toURI();
                if ("file".equals(uri.getScheme())) {
                    path = Paths.get(clazz.getResource(assetDir).toURI());
                    break block6;
                }
                if (!"jar".equals(uri.getScheme())) {
                    LycanitesMobs.printWarning("", "Unsupported file scheme: " + uri.getScheme());
                    return null;
                }
                try {
                    filesystem = FileSystems.getFileSystem(uri);
                }
                catch (Exception e) {
                    filesystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                }
                path = filesystem.getPath(assetDir, new String[0]);
            }
            catch (Exception e) {
                LycanitesMobs.printWarning("", "No data found in: " + assetDir);
            }
        }
        return path;
    }

    public static List<ResourceLocation> getPathResourceLocations(Path path, String assetDomain, String fileType) {
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>();
        try {
            Iterator iterator = Files.walk(path, new FileVisitOption[0]).iterator();
            while (iterator.hasNext()) {
                Path filePath = (Path)iterator.next();
                if (fileType != null && !fileType.equals(FilenameUtils.getExtension((String)filePath.toString()))) continue;
                Path relativePath = path.relativize(filePath);
                String resourceLocationPath = FilenameUtils.removeExtension((String)relativePath.toString()).replaceAll("\\\\", "/");
                ResourceLocation resourceLocation = new ResourceLocation(assetDomain, resourceLocationPath);
                resourceLocations.add(resourceLocation);
            }
        }
        catch (Exception e) {
            LycanitesMobs.printWarning("", "There was a problem getting ResourceLocations for: " + path + ", " + fileType + ",  \n" + e.toString());
        }
        return resourceLocations;
    }
}

