/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.ExtendedEntity;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.PotionBase;
import com.lycanitesmobs.core.entity.EntityFear;
import com.lycanitesmobs.core.network.MessageEntityVelocity;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PotionEffects {
    private static final UUID swiftswimmingMoveBoostUUID = UUID.fromString("6d4fe17f-06eb-4ebc-a573-364b79faed5e");
    private static final AttributeModifier swiftswimmingMoveBoost = new AttributeModifier(swiftswimmingMoveBoostUUID, "Swiftswimming Speed Boost", 0.6, 2).func_111168_a(false);

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        PotionBase immunization;
        PotionBase swiftswimming;
        PotionBase smouldering;
        float brightness;
        PotionBase smited;
        PotionBase plague;
        PotionBase instability;
        ExtendedEntity extendedEntity;
        PotionBase fear;
        PotionBase weight;
        PotionBase paralysis;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        for (Object potionEffectObj : entity.func_70651_bq()) {
            if (potionEffectObj != null) continue;
            entity.func_70674_bp();
            LycanitesMobs.printWarning("EffectsSetup", "Found a null potion effect on entity: " + entity + " all effects have been removed from this entity.");
        }
        if (entity.func_70644_a(MobEffects.field_76440_q) && entity.func_70644_a(MobEffects.field_76439_r)) {
            entity.func_184589_d(MobEffects.field_76440_q);
        }
        if (LycanitesMobs.disableNausea && event.getEntityLiving() instanceof EntityPlayer && entity.func_70644_a(MobEffects.field_76431_k)) {
            entity.func_184589_d(MobEffects.field_76431_k);
        }
        boolean invulnerable = false;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            invulnerable = player.field_71075_bZ.field_75098_d;
        }
        if ((paralysis = ObjectManager.getPotionEffect("paralysis")) != null && !invulnerable && entity.func_70644_a((Potion)paralysis)) {
            entity.field_70159_w = 0.0;
            if (entity.field_70181_x > 0.0) {
                entity.field_70181_x = 0.0;
            }
            entity.field_70179_y = 0.0;
            entity.field_70122_E = false;
        }
        if ((weight = ObjectManager.getPotionEffect("weight")) != null && !invulnerable && entity.func_70644_a((Potion)weight) && !entity.func_70644_a(MobEffects.field_76420_g) && entity.field_70181_x > -0.2) {
            entity.field_70181_x = -0.2;
        }
        if ((fear = ObjectManager.getPotionEffect("fear")) != null && !entity.func_130014_f_().field_72995_K && !invulnerable && entity.func_70644_a((Potion)fear) && (extendedEntity = ExtendedEntity.getForEntity(entity)) != null && extendedEntity.fearEntity == null) {
            EntityFear fearEntity = new EntityFear(entity.func_130014_f_(), (Entity)entity);
            entity.func_130014_f_().func_72838_d((Entity)fearEntity);
            extendedEntity.fearEntity = fearEntity;
        }
        if ((instability = ObjectManager.getPotionEffect("instability")) != null && !entity.func_130014_f_().field_72995_K && !invulnerable && entity.func_70644_a((Potion)instability) && entity.func_130014_f_().field_73012_v.nextDouble() <= 0.1) {
            double strength = 1 + entity.func_70660_b((Potion)instability).func_76458_c();
            entity.field_70159_w += strength * (entity.func_130014_f_().field_73012_v.nextDouble() - 0.5);
            entity.field_70181_x += strength * (entity.func_130014_f_().field_73012_v.nextDouble() - 0.5);
            entity.field_70179_y += strength * (entity.func_130014_f_().field_73012_v.nextDouble() - 0.5);
            try {
                if (entity instanceof EntityPlayerMP) {
                    EntityPlayerMP player = (EntityPlayerMP)entity;
                    player.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)entity));
                    MessageEntityVelocity messageEntityVelocity = new MessageEntityVelocity((Entity)player, strength * (entity.func_130014_f_().field_73012_v.nextDouble() - 0.5), strength * (entity.func_130014_f_().field_73012_v.nextDouble() - 0.5), strength * (entity.func_130014_f_().field_73012_v.nextDouble() - 0.5));
                    LycanitesMobs.packetHandler.sendToPlayer(messageEntityVelocity, player);
                }
            }
            catch (Exception e) {
                LycanitesMobs.printWarning("", "Failed to create and send a network packet for instability velocity!");
                e.printStackTrace();
            }
        }
        if ((plague = ObjectManager.getPotionEffect("plague")) != null && !entity.func_130014_f_().field_72995_K && !invulnerable && entity.func_70644_a((Potion)plague)) {
            int poisonAmplifier = entity.func_70660_b((Potion)plague).func_76458_c();
            int poisonDuration = entity.func_70660_b((Potion)plague).func_76459_b();
            if (entity.func_70644_a(MobEffects.field_76436_u)) {
                poisonAmplifier = Math.max(poisonAmplifier, entity.func_70660_b(MobEffects.field_76436_u).func_76458_c());
                poisonDuration = Math.max(poisonDuration, entity.func_70660_b(MobEffects.field_76436_u).func_76459_b());
            }
            entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, poisonDuration, poisonAmplifier));
            if (entity.func_130014_f_().func_82737_E() % 20L == 0L) {
                List<EntityLivingBase> aoeTargets = this.getNearbyEntities((Entity)entity, EntityLivingBase.class, null, 10.0);
                for (EntityLivingBase entityObj : aoeTargets) {
                    EntityLivingBase target = entityObj;
                    if (target == entity || entity.func_184191_r((Entity)target)) continue;
                    int amplifier = entity.func_70660_b((Potion)plague).func_76458_c();
                    int duration = entity.func_70660_b((Potion)plague).func_76459_b();
                    if (amplifier > 0) {
                        target.func_70690_d(new PotionEffect((Potion)plague, duration, amplifier - 1));
                        continue;
                    }
                    target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, duration, amplifier));
                }
            }
        }
        if ((smited = ObjectManager.getPotionEffect("smited")) != null && !entity.func_130014_f_().field_72995_K && !invulnerable && entity.func_70644_a((Potion)smited) && entity.func_130014_f_().func_82737_E() % 20L == 0L && (brightness = entity.func_70013_c()) > 0.5f && entity.func_130014_f_().func_175710_j(entity.func_180425_c())) {
            entity.func_70015_d(4);
        }
        if ((smouldering = ObjectManager.getPotionEffect("smouldering")) != null && !entity.func_130014_f_().field_72995_K && !invulnerable && entity.func_70644_a((Potion)smouldering) && entity.func_130014_f_().func_82737_E() % 20L == 0L) {
            entity.func_70015_d(4 + 4 * entity.func_70660_b((Potion)smouldering).func_76458_c());
        }
        if ((swiftswimming = ObjectManager.getPotionEffect("swiftswimming")) != null && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (entity.func_70644_a((Potion)swiftswimming) && entity.func_70090_H()) {
                int amplifier = entity.func_70660_b((Potion)swiftswimming).func_76458_c();
                IAttributeInstance movement = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
                if (movement.func_111127_a(swiftswimmingMoveBoostUUID) == null) {
                    movement.func_111121_a(swiftswimmingMoveBoost);
                }
            } else {
                IAttributeInstance movement = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
                if (movement.func_111127_a(swiftswimmingMoveBoostUUID) != null) {
                    movement.func_111124_b(swiftswimmingMoveBoost);
                }
            }
        }
        if ((immunization = ObjectManager.getPotionEffect("immunization")) != null && !entity.func_130014_f_().field_72995_K && entity.func_70644_a((Potion)ObjectManager.getPotionEffect("immunization"))) {
            if (entity.func_70644_a(MobEffects.field_76436_u)) {
                entity.func_184589_d(MobEffects.field_76436_u);
            }
            if (entity.func_70644_a(MobEffects.field_76438_s)) {
                entity.func_184589_d(MobEffects.field_76438_s);
            }
            if (entity.func_70644_a(MobEffects.field_76437_t)) {
                entity.func_184589_d(MobEffects.field_76437_t);
            }
            if (entity.func_70644_a(MobEffects.field_76431_k)) {
                entity.func_184589_d(MobEffects.field_76431_k);
            }
            if (ObjectManager.getPotionEffect("paralysis") != null && entity.func_70644_a((Potion)ObjectManager.getPotionEffect("paralysis"))) {
                entity.func_184589_d((Potion)ObjectManager.getPotionEffect("paralysis"));
            }
        }
        PotionBase cleansed = ObjectManager.getPotionEffect("cleansed");
        if (ObjectManager.getPotionEffect("cleansed") != null && !entity.func_130014_f_().field_72995_K && entity.func_70644_a((Potion)ObjectManager.getPotionEffect("cleansed"))) {
            if (entity.func_70644_a(MobEffects.field_82731_v)) {
                entity.func_184589_d(MobEffects.field_82731_v);
            }
            if (entity.func_70644_a(MobEffects.field_189112_A)) {
                entity.func_184589_d(MobEffects.field_189112_A);
            }
            if (ObjectManager.getPotionEffect("fear") != null && entity.func_70644_a((Potion)ObjectManager.getPotionEffect("fear"))) {
                entity.func_184589_d((Potion)ObjectManager.getPotionEffect("fear"));
            }
            if (ObjectManager.getPotionEffect("insomnia") != null && entity.func_70644_a((Potion)ObjectManager.getPotionEffect("insomnia"))) {
                entity.func_184589_d((Potion)ObjectManager.getPotionEffect("insomnia"));
            }
        }
    }

    @SubscribeEvent
    public void onEntityJump(LivingEvent.LivingJumpEvent event) {
        PotionBase weight;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        boolean invulnerable = false;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            invulnerable = player.field_71075_bZ.field_75098_d;
        }
        if (invulnerable) {
            return;
        }
        PotionBase paralysis = ObjectManager.getPotionEffect("paralysis");
        if (paralysis != null && entity.func_70644_a((Potion)paralysis) && event.isCancelable()) {
            event.setCanceled(true);
        }
        if ((weight = ObjectManager.getPotionEffect("weight")) != null && entity.func_70644_a((Potion)weight) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.isCancelable() && event.isCanceled()) {
            return;
        }
        if (event.getEntityLiving() == null) {
            return;
        }
        EntityLivingBase target = event.getEntityLiving();
        EntityLivingBase attacker = null;
        if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            attacker = (EntityLivingBase)event.getSource().func_76346_g();
        }
        if (attacker == null) {
            return;
        }
        PotionBase lifeleak = ObjectManager.getPotionEffect("lifeleak");
        if (lifeleak != null && !event.getEntityLiving().func_130014_f_().field_72995_K && attacker.func_70644_a((Potion)lifeleak)) {
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            target.func_70691_i(event.getAmount());
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        EntityLivingBase attackingEntity;
        PotionBase leech;
        PotionBase fear;
        PotionBase penetration;
        if (event.isCancelable() && event.isCanceled()) {
            return;
        }
        if (event.getEntityLiving() == null) {
            return;
        }
        PotionBase fallresist = ObjectManager.getPotionEffect("fallresist");
        if (fallresist != null && event.getEntityLiving().func_70644_a((Potion)fallresist) && "fall".equals(event.getSource().field_76373_n)) {
            event.setAmount(0.0f);
            event.setCanceled(true);
        }
        if ((penetration = ObjectManager.getPotionEffect("penetration")) != null && event.getEntityLiving().func_70644_a((Potion)penetration)) {
            float damage = event.getAmount();
            float multiplier = event.getEntityLiving().func_70660_b((Potion)penetration).func_76458_c();
            event.setAmount(damage + damage * multiplier / 2.0f);
        }
        if ((fear = ObjectManager.getPotionEffect("fear")) != null && event.getEntityLiving().func_70644_a((Potion)fear) && "inWall".equals(event.getSource().field_76373_n)) {
            event.setAmount(0.0f);
            event.setCanceled(true);
        }
        if ((leech = ObjectManager.getPotionEffect("leech")) != null && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityLivingBase && (attackingEntity = (EntityLivingBase)event.getSource().func_76346_g()).func_70644_a((Potion)leech)) {
            float damage = event.getAmount();
            float multiplier = attackingEntity.func_70660_b((Potion)leech).func_76458_c();
            attackingEntity.func_70691_i(damage * multiplier);
        }
    }

    @SubscribeEvent
    public void onEntityHeal(LivingHealEvent event) {
        PotionBase decay;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        PotionBase rejuvenation = ObjectManager.getPotionEffect("rejuvenation");
        if (rejuvenation != null && entity.func_70644_a((Potion)rejuvenation)) {
            event.setAmount((float)Math.ceil(event.getAmount() * (float)(2 * (1 + entity.func_70660_b((Potion)rejuvenation).func_76458_c()))));
        }
        if ((decay = ObjectManager.getPotionEffect("decay")) != null && entity.func_70644_a((Potion)decay)) {
            event.setAmount((float)Math.floor(event.getAmount() / (float)(2 * (1 + entity.func_70660_b((Potion)decay).func_76458_c()))));
        }
    }

    @SubscribeEvent
    public void onSleep(PlayerSleepInBedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null || player.func_130014_f_().field_72995_K || event.isCanceled()) {
            return;
        }
        PotionBase insomnia = ObjectManager.getPotionEffect("insomnia");
        if (insomnia != null && player.func_70644_a((Potion)insomnia)) {
            event.setResult(EntityPlayer.SleepResult.NOT_SAFE);
        }
    }

    @SubscribeEvent
    public void onLivingUseItem(LivingEntityUseItemEvent event) {
        if (event.isCancelable() && event.isCanceled()) {
            return;
        }
        if (event.getEntityLiving() == null) {
            return;
        }
        PotionBase aphagia = ObjectManager.getPotionEffect("aphagia");
        if (aphagia != null && !event.getEntityLiving().func_130014_f_().field_72995_K && event.getEntityLiving().func_70644_a((Potion)aphagia) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    public <T extends Entity> List<T> getNearbyEntities(Entity searchEntity, Class<? extends T> clazz, Class filterClass, double range) {
        return searchEntity.func_130014_f_().func_175647_a(clazz, searchEntity.func_174813_aQ().func_72314_b(range, range, range), entity -> {
            if (filterClass == null) {
                return true;
            }
            return filterClass.isAssignableFrom(entity.getClass());
        });
    }
}

