/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ClientProxy;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.PotionBase;
import com.lycanitesmobs.Utilities;
import com.lycanitesmobs.core.block.BlockSlabCustom;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.EntityListCustom;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.item.ItemBase;
import com.lycanitesmobs.core.item.ItemSlabCustom;
import com.lycanitesmobs.core.item.equipment.ItemEquipmentPart;
import com.lycanitesmobs.core.model.ModelEquipmentPart;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ObjectManager {
    public static Map<String, Block> blocks = new HashMap<String, Block>();
    public static Map<String, Item> items = new HashMap<String, Item>();
    public static Map<Item, GroupInfo> itemGroups = new HashMap<Item, GroupInfo>();
    public static Map<String, Fluid> fluids = new HashMap<String, Fluid>();
    public static Map<Block, Item> buckets = new HashMap<Block, Item>();
    public static Map<String, Class> tileEntities = new HashMap<String, Class>();
    public static Map<String, PotionBase> potionEffects = new HashMap<String, PotionBase>();
    public static Map<String, EntityListCustom> entityLists = new HashMap<String, EntityListCustom>();
    public static Map<String, Class> projectiles = new HashMap<String, Class>();
    public static Map<String, DamageSource> damageSources = new HashMap<String, DamageSource>();
    public static Map<String, StatBase> stats = new HashMap<String, StatBase>();
    public static GroupInfo currentGroup;

    public static void setCurrentGroup(GroupInfo group) {
        currentGroup = group;
    }

    public static Block addBlock(String name, Block block) {
        name = name.toLowerCase();
        blocks.put(name, block);
        if (block instanceof BlockSlabCustom) {
            BlockSlabCustom blockSlab = (BlockSlabCustom)block;
            ItemSlabCustom itemSlabCustom = new ItemSlabCustom((Block)blockSlab, blockSlab, blockSlab.getDoubleBlock());
            items.put(name, (Item)itemSlabCustom);
            itemGroups.put((Item)itemSlabCustom, currentGroup);
        } else {
            ItemBlock itemBlock = new ItemBlock(block);
            itemBlock.setRegistryName(block.getRegistryName());
            items.put(name, (Item)itemBlock);
            itemGroups.put((Item)itemBlock, currentGroup);
        }
        return block;
    }

    public static Fluid addFluid(String fluidName) {
        GroupInfo group = currentGroup;
        Fluid fluid = new Fluid(fluidName, new ResourceLocation(group.filename + ":blocks/" + fluidName + "_still"), new ResourceLocation(group.filename + ":blocks/" + fluidName + "_flow"));
        fluids.put(fluidName, fluid);
        if (!FluidRegistry.registerFluid((Fluid)fluid)) {
            LycanitesMobs.printWarning("", "Another fluid was registered as " + fluidName);
        }
        return fluid;
    }

    public static Item addBucket(Item bucket, Block block, Fluid fluid) {
        buckets.put(block, bucket);
        return bucket;
    }

    public static Item addItem(String name, Item item) {
        name = name.toLowerCase();
        items.put(name, item);
        itemGroups.put(item, currentGroup);
        if (item instanceof ItemBucket) {
            BehaviorDefaultDispenseItem ibehaviordispenseitem = new BehaviorDefaultDispenseItem(){
                private final BehaviorDefaultDispenseItem dispenseBehavior = new BehaviorDefaultDispenseItem();

                public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                    ItemBucket itembucket = (ItemBucket)stack.func_77973_b();
                    BlockPos blockpos = source.func_180699_d().func_177972_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
                    return itembucket.func_180616_a(null, source.func_82618_k(), blockpos) ? new ItemStack(Items.field_151133_ar) : this.dispenseBehavior.func_82482_a(source, stack);
                }
            };
            BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)ibehaviordispenseitem);
        }
        return item;
    }

    public static Item addItem(String name, Item item, int weight, int minAmount, int maxAmount) {
        Utilities.addDungeonLoot(new ItemStack(item), minAmount, maxAmount, weight);
        Utilities.addStrongholdLoot(new ItemStack(item), minAmount, maxAmount, weight * 2);
        Utilities.addVillageLoot(new ItemStack(item), minAmount, maxAmount, weight);
        return ObjectManager.addItem(name, item);
    }

    public static Class addTileEntity(String name, Class tileEntityClass) {
        name = name.toLowerCase();
        tileEntities.put(name, tileEntityClass);
        GameRegistry.registerTileEntity((Class)tileEntityClass, (String)("lycanitesmobs." + name));
        return tileEntityClass;
    }

    public static PotionBase addPotionEffect(String name, ConfigBase config, boolean isBad, int color, boolean goodEffect) {
        if (!config.getBool("Effects", name + " enabled", true, "Set to false to disable this potion effect.")) {
            return null;
        }
        PotionBase potion = new PotionBase(name, isBad, color);
        potionEffects.put(name, potion);
        ObjectLists.addEffect(goodEffect ? "buffs" : "debuffs", potion);
        return potion;
    }

    public static void addProjectile(String name, Class entityClass, int updateFrequency) {
        name = name.toLowerCase();
        GroupInfo group = currentGroup;
        AssetManager.addSound(name, group, "projectile." + name);
        int projectileID = group.getNextProjectileID();
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(group.filename, name), (Class)entityClass, (String)name, (int)projectileID, (Object)group.mod, (int)64, (int)updateFrequency, (boolean)true);
        projectiles.put(name, entityClass);
        group.projectileClasses.add(entityClass);
    }

    public static void addProjectile(String name, Class entityClass) {
        ObjectManager.addProjectile(name, entityClass, 1);
    }

    public static void addProjectile(String name, Class entityClass, Item item, BehaviorProjectileDispense dispenseBehaviour) {
        name = name.toLowerCase();
        ObjectManager.addProjectile(name, entityClass);
        BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)dispenseBehaviour);
    }

    public static void addDamageSource(String name, DamageSource damageSource) {
        name = name.toLowerCase();
        damageSources.put(name, damageSource);
    }

    public static void addStat(String name, StatBase stat) {
        if (stats.containsKey(name = name.toLowerCase())) {
            return;
        }
        stat.func_75971_g();
        stats.put(name, stat);
    }

    public static Block getBlock(String name) {
        if (!blocks.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return blocks.get(name);
    }

    public static Item getItem(String name) {
        if (!items.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return items.get(name);
    }

    public static Class getTileEntity(String name) {
        if (!tileEntities.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return tileEntities.get(name);
    }

    public static PotionBase getPotionEffect(String name) {
        if (!potionEffects.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return potionEffects.get(name);
    }

    public static DamageSource getDamageSource(String name) {
        if (!damageSources.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return damageSources.get(name);
    }

    public static StatBase getStat(String name) {
        if (!stats.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return stats.get(name);
    }

    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])blocks.values().toArray(new Block[blocks.size()]));
        for (Block block : blocks.values()) {
            if (block.getRegistryName() == null) {
                LycanitesMobs.printWarning("", "Block: " + block + " has no Registry Name!");
            }
            LycanitesMobs.proxy.addBlockRender(currentGroup, block);
        }
    }

    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : items.values()) {
            if (item.getRegistryName() == null) {
                LycanitesMobs.printWarning("", "Item: " + item + " has no Registry Name!");
            }
            event.getRegistry().register((IForgeRegistryEntry)item);
            LycanitesMobs.proxy.addItemRender(itemGroups.get(item), item);
        }
    }

    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        for (PotionBase potion : potionEffects.values()) {
            event.getRegistry().register((IForgeRegistryEntry)potion);
        }
    }

    public static void registerEntities(RegistryEvent.Register<EntityEntry> event, GroupInfo group) {
        LycanitesMobs.printDebug("Creature", "Forge registering all " + CreatureManager.getInstance().creatures.size() + " creatures from the group: " + group.name + "...");
        for (CreatureInfo creatureInfo : CreatureManager.getInstance().creatures.values()) {
            if (creatureInfo.group != group) continue;
            EntityEntry entityEntry = new EntityEntry(creatureInfo.entityClass, creatureInfo.getEntityId());
            entityEntry.setRegistryName(creatureInfo.getEntityId());
            event.getRegistry().register((IForgeRegistryEntry)entityEntry);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void RegisterModels() {
        for (Item item : items.values()) {
            ItemBase itemBase;
            if (item instanceof ItemBase && (itemBase = (ItemBase)item).useItemColors()) {
                Minecraft.func_71410_x().getItemColors().func_186730_a(ClientProxy.itemColor, new Item[]{item});
            }
            if (!(item instanceof ItemEquipmentPart)) continue;
            ItemEquipmentPart itemEquipmentPart = (ItemEquipmentPart)item;
            AssetManager.addItemModel(itemEquipmentPart.itemName, new ModelEquipmentPart(itemEquipmentPart.itemName, itemEquipmentPart.group));
        }
    }
}

