/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.model.ModelItemBase;
import com.lycanitesmobs.core.model.ModelObjOld;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.ModelBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AssetManager {
    public static Map<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();
    public static Map<String, ResourceLocation[]> textureGroups = new HashMap<String, ResourceLocation[]>();
    public static Map<String, SoundEvent> sounds = new HashMap<String, SoundEvent>();
    public static Map<String, ModelBase> models = new HashMap<String, ModelBase>();
    public static Map<String, IModel> objModels = new HashMap<String, IModel>();
    public static Map<String, ModelItemBase> itemModels = new HashMap<String, ModelItemBase>();

    public static void addTexture(String name, GroupInfo group, String path) {
        name = name.toLowerCase();
        textures.put(name, new ResourceLocation(group.filename, path));
    }

    public static void addTextureGroup(String name, GroupInfo group, String[] paths) {
        name = name.toLowerCase();
        ResourceLocation[] textureGroup = new ResourceLocation[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            textureGroup[i] = new ResourceLocation(group.filename, paths[i]);
        }
        textureGroups.put(name, textureGroup);
    }

    public static void addSound(String name, GroupInfo group, String path) {
        name = name.toLowerCase();
        ResourceLocation resourceLocation = new ResourceLocation(group.filename, path);
        SoundEvent soundEvent = new SoundEvent(resourceLocation);
        soundEvent.setRegistryName(resourceLocation);
        sounds.put(name, soundEvent);
        GameRegistry.findRegistry(SoundEvent.class).register((IForgeRegistryEntry)soundEvent);
    }

    public static void addModel(String name, ModelBase model) {
        name = name.toLowerCase();
        models.put(name, model);
    }

    public static void addObjModel(String name, GroupInfo group, String path) {
        name = name.toLowerCase();
        objModels.put(name, ModelObjOld.loadModel(new ResourceLocation(group.filename, "models/" + path + ".obj")));
    }

    public static void addItemModel(String name, ModelItemBase model) {
        name = name.toLowerCase();
        itemModels.put(name, model);
    }

    public static ResourceLocation getTexture(String name) {
        if (!textures.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return textures.get(name);
    }

    public static ResourceLocation[] getTextureGroup(String name) {
        if (!textureGroups.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return textureGroups.get(name);
    }

    public static SoundEvent getSound(String name) {
        if (!sounds.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return sounds.get(name);
    }

    public static ModelBase getModel(String name) {
        if (!models.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return models.get(name);
    }

    public static IModel getObjModel(String name) {
        if (!objModels.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return objModels.get(name);
    }

    public static IModel getObjModel(String name, GroupInfo group, String path) {
        if (!objModels.containsKey(name = name.toLowerCase())) {
            AssetManager.addObjModel(name, group, path);
        }
        return objModels.get(name);
    }

    public static ModelItemBase getItemModel(String name) {
        if (!itemModels.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return itemModels.get(name);
    }
}

