/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.world.dungeon;

import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.blocks.dungeon.BlockDungeonBase;
import com.legacy.aether.blocks.util.EnumCloudType;
import com.legacy.aether.blocks.util.EnumStoneType;
import com.legacy.aether.entities.AetherEntities;
import com.legacy.aether.entities.bosses.valkyrie_queen.EntityValkyrieQueen;
import com.legacy.aether.items.ItemMoaEgg;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.world.biome.decoration.AetherGenClouds;
import com.legacy.aether.world.dungeon.util.AetherDungeon;
import com.legacy.aether.world.dungeon.util.PositionData;
import java.util.Random;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SilverDungeon
extends AetherDungeon {
    private int[][][] rooms = new int[3][3][3];
    private AetherGenClouds clouds = new AetherGenClouds();

    public SilverDungeon() {
        this.clouds.setCloudType(EnumCloudType.Cold);
        this.clouds.setCloudAmmount(10);
        this.clouds.setFlat(false);
    }

    public void generateDoorX(World world, int x, int y, int z, int yF, int zF) {
        for (int yFinal = y; yFinal < y + yF; ++yFinal) {
            for (int zFinal = z; zFinal < z + zF; ++zFinal) {
                this.func_175903_a(world, new BlockPos(x, yFinal, zFinal), Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    public void generateDoorZ(World world, int z, int x, int y, int xF, int yF) {
        for (int xFinal = x; xFinal < x + xF; ++xFinal) {
            for (int yFinal = y; yFinal < y + yF; ++yFinal) {
                this.func_175903_a(world, new BlockPos(xFinal, yFinal, z), Blocks.field_150350_a.func_176223_P());
            }
        }
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        int z;
        int z2;
        int z3;
        int y;
        this.replaceAir = true;
        if (!this.isBoxEmpty(world, new PositionData(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), new PositionData(55, 20, 30))) {
            return false;
        }
        if (world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(0, -5, 0)).func_177230_c() == Blocks.field_150350_a || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(55, -5, 0)).func_177230_c() == Blocks.field_150350_a || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(0, -5, 30)).func_177230_c() == Blocks.field_150350_a || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(55, -5, 30)).func_177230_c() == Blocks.field_150350_a) {
            for (int n = 0; n < 100; ++n) {
                int x = pos.func_177958_n() - 11 + random.nextInt(77);
                y = pos.func_177956_o() - 7;
                z3 = pos.func_177952_p() - 10 + random.nextInt(50);
                this.clouds.func_180709_b(world, random, new BlockPos(x, y, z3));
            }
        }
        this.replaceSolid = true;
        this.setBlocks(BlocksAether.holystone.func_176223_P(), BlocksAether.mossy_holystone.func_176223_P(), 30);
        this.addSolidBox(world, random, new PositionData(pos.func_177958_n(), pos.func_177956_o() - 5, pos.func_177952_p()), new PositionData(55, 5, 30));
        for (int x = pos.func_177958_n(); x < pos.func_177958_n() + 55; x += 4) {
            this.addColumn(world, random, new PositionData(x, pos.func_177956_o(), pos.func_177952_p()), 14);
            this.addColumn(world, random, new PositionData(x, pos.func_177956_o(), pos.func_177952_p() + 27), 14);
        }
        for (z2 = pos.func_177952_p(); z2 < pos.func_177952_p() + 12; z2 += 4) {
            this.addColumn(world, random, new PositionData(pos.func_177958_n(), pos.func_177956_o(), z2), 14);
            this.addColumn(world, random, new PositionData(pos.func_177958_n() + 52, pos.func_177956_o(), z2), 14);
        }
        for (z2 = pos.func_177952_p() + 19; z2 < pos.func_177952_p() + 30; z2 += 4) {
            this.addColumn(world, random, new PositionData(pos.func_177958_n(), pos.func_177956_o(), z2), 14);
            this.addColumn(world, random, new PositionData(pos.func_177958_n() + 52, pos.func_177956_o(), z2), 14);
        }
        IBlockState block2 = BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic));
        this.setBlocks(block2, BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic)), 20);
        this.addHollowBox(world, random, new PositionData(pos.func_177958_n() + 4, pos.func_177956_o() - 1, pos.func_177952_p() + 4), new PositionData(47, 16, 22));
        this.addPlaneX(world, random, new PositionData(pos.func_177958_n() + 11, pos.func_177956_o(), pos.func_177952_p() + 5), new PositionData(0, 15, 20));
        this.addPlaneX(world, random, new PositionData(pos.func_177958_n() + 18, pos.func_177956_o(), pos.func_177952_p() + 5), new PositionData(0, 15, 20));
        this.addPlaneX(world, random, new PositionData(pos.func_177958_n() + 25, pos.func_177956_o(), pos.func_177952_p() + 5), new PositionData(0, 15, 20));
        this.addPlaneZ(world, random, new PositionData(pos.func_177958_n() + 5, pos.func_177956_o(), pos.func_177952_p() + 11), new PositionData(20, 15, 0));
        this.addPlaneZ(world, random, new PositionData(pos.func_177958_n() + 5, pos.func_177956_o(), pos.func_177952_p() + 18), new PositionData(20, 15, 0));
        IBlockState block1 = BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic));
        this.setBlocks(block1, BlocksAether.dungeon_trap.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic)), 30);
        this.addPlaneY(world, random, new PositionData(pos.func_177958_n() + 5, pos.func_177956_o() + 4, pos.func_177952_p() + 5), new PositionData(20, 0, 20));
        this.addPlaneY(world, random, new PositionData(pos.func_177958_n() + 5, pos.func_177956_o() + 9, pos.func_177952_p() + 5), new PositionData(20, 0, 20));
        for (y = pos.func_177956_o(); y < pos.func_177956_o() + 2; ++y) {
            for (z3 = pos.func_177952_p() + 14; z3 < pos.func_177952_p() + 16; ++z3) {
                this.func_175903_a(world, new BlockPos(pos.func_177958_n() + 4, y, z3), Blocks.field_150350_a.func_176223_P());
            }
        }
        this.setBlocks(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 1);
        this.addSolidBox(world, random, new PositionData(pos.func_177958_n(), pos.func_177956_o() - 4, pos.func_177952_p() + 14), new PositionData(1, 4, 2));
        this.addSolidBox(world, random, new PositionData(pos.func_177958_n() + 1, pos.func_177956_o() - 3, pos.func_177952_p() + 14), new PositionData(1, 3, 2));
        this.addSolidBox(world, random, new PositionData(pos.func_177958_n() + 2, pos.func_177956_o() - 2, pos.func_177952_p() + 14), new PositionData(1, 2, 2));
        this.addSolidBox(world, random, new PositionData(pos.func_177958_n() + 3, pos.func_177956_o() - 1, pos.func_177952_p() + 14), new PositionData(1, 1, 2));
        IBlockState block = BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic));
        this.setBlocks(block, BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic)), 15);
        for (int y2 = 0; y2 < 7; ++y2) {
            this.addPlaneY(world, random, new PositionData(pos.func_177958_n() - 1, pos.func_177956_o() + 15 + y2, pos.func_177952_p() - 1 + 2 * y2), new PositionData(57, 0, 32 - 4 * y2));
        }
        int firstStaircaseZ = 0;
        int secondStaircaseZ = 0;
        int finalStaircaseZ = 0;
        int row = random.nextInt(3);
        this.addStaircase(world, random, new PositionData(pos.func_177958_n() + 19, pos.func_177956_o(), pos.func_177952_p() + 5 + row * 7), 10);
        this.rooms[2][0][row] = 2;
        this.rooms[2][1][row] = 2;
        this.rooms[2][2][row] = 1;
        finalStaircaseZ = row;
        int x = pos.func_177958_n() + 25;
        for (int y3 = pos.func_177956_o(); y3 < pos.func_177956_o() + 2; ++y3) {
            for (z = pos.func_177952_p() + 7 + 7 * row; z < pos.func_177952_p() + 9 + 7 * row; ++z) {
                this.func_175903_a(world, new BlockPos(x, y3, z), Blocks.field_150350_a.func_176223_P());
            }
        }
        row = random.nextInt(3);
        this.addStaircase(world, random, new PositionData(pos.func_177958_n() + 12, pos.func_177956_o(), pos.func_177952_p() + 5 + row * 7), 5);
        this.rooms[1][0][row] = 1;
        this.rooms[1][1][row] = 1;
        firstStaircaseZ = row;
        row = random.nextInt(3);
        this.addStaircase(world, random, new PositionData(pos.func_177958_n() + 5, pos.func_177956_o() + 5, pos.func_177952_p() + 5 + row * 7), 5);
        this.rooms[0][1][row] = 1;
        this.rooms[0][2][row] = 1;
        secondStaircaseZ = row;
        for (int p = 0; p < 3; ++p) {
            for (int q = 0; q < 3; ++q) {
                block15: for (int r = 0; r < 3; ++r) {
                    int newType;
                    if (p == 0 && q != 0 && secondStaircaseZ == r) {
                        if (r == 0) {
                            this.generateDoorX(world, pos.func_177958_n() + 11 + 7 * p, pos.func_177956_o() + 5 * q, pos.func_177952_p() + 7 + 7 * r, 2, 2);
                            this.generateDoorZ(world, pos.func_177952_p() - 3 + 7 * r, pos.func_177958_n() + 7 + 7 * p, pos.func_177956_o() + 5 * q, 2, 2);
                            continue;
                        }
                        if (r == 1) {
                            this.generateDoorX(world, pos.func_177958_n() + 11 + 7 * p, pos.func_177956_o() + 5 * q, pos.func_177952_p() + 7 + 7 * r, 2, 2);
                            this.generateDoorZ(world, pos.func_177952_p() + 4 + 7 * r, pos.func_177958_n() + 7 + 7 * p, pos.func_177956_o() + 5 * q, 2, 2);
                            this.generateDoorZ(world, pos.func_177952_p() + 11 + 7 * r, pos.func_177958_n() + 7 + 7 * p, pos.func_177956_o() + 5 * q, 2, 2);
                            continue;
                        }
                        if (r != 2) continue;
                        this.generateDoorX(world, pos.func_177958_n() + 11 + 7 * p, pos.func_177956_o() + 5 * q, pos.func_177952_p() + 7 + 7 * r, 2, 2);
                        this.generateDoorZ(world, pos.func_177952_p() + 4 + 7 * r, pos.func_177958_n() + 7 + 7 * p, pos.func_177956_o() + 5 * q, 2, 2);
                        continue;
                    }
                    if (p == 1 && q != 2 && firstStaircaseZ == r) {
                        if (firstStaircaseZ != finalStaircaseZ) {
                            this.generateDoorX(world, pos.func_177958_n() + 11 + 7 * p, pos.func_177956_o() + 5 * q, pos.func_177952_p() + 7 + 7 * r, 2, 2);
                        }
                        if (r == 0) {
                            this.generateDoorZ(world, pos.func_177952_p() + 11 + 7 * r, pos.func_177958_n() + 7 + 7 * p, pos.func_177956_o() + 5 * q, 2, 2);
                            this.generateDoorX(world, pos.func_177958_n() + 4 + 7 * p, pos.func_177956_o() + 5 * q, pos.func_177952_p() + 7 + 7 * r, 2, 2);
                            continue;
                        }
                        if (r == 1) {
                            this.generateDoorZ(world, pos.func_177952_p() + 4 + 7 * r, pos.func_177958_n() + 7 + 7 * p, pos.func_177956_o() + 5 * q, 2, 2);
                            this.generateDoorZ(world, pos.func_177952_p() + 11 + 7 * r, pos.func_177958_n() + 7 + 7 * p, pos.func_177956_o() + 5 * q, 2, 2);
                            this.generateDoorX(world, pos.func_177958_n() + 4 + 7 * p, pos.func_177956_o() + 5 * q, pos.func_177952_p() + 7 + 7 * r, 2, 2);
                            continue;
                        }
                        if (r != 2) continue;
                        this.generateDoorZ(world, pos.func_177952_p() + 4 + 7 * r, pos.func_177958_n() + 7 + 7 * p, pos.func_177956_o() + 5 * q, 2, 2);
                        this.generateDoorX(world, pos.func_177958_n() + 4 + 7 * p, pos.func_177956_o() + 5 * q, pos.func_177952_p() + 7 + 7 * r, 2, 2);
                        continue;
                    }
                    if (p == 2 && finalStaircaseZ == r) {
                        if (q == 0) {
                            this.generateDoorX(world, pos.func_177958_n() + 11 + 7 * p, pos.func_177956_o() + 5 * q, pos.func_177952_p() + 7 + 7 * r, 2, 2);
                            continue;
                        }
                        if (q != 2) continue;
                        if (r == 0) {
                            this.generateDoorX(world, pos.func_177958_n() + 4 + 7 * p, pos.func_177956_o() + 5 * q, pos.func_177952_p() + 7 + 7 * r, 2, 2);
                            this.generateDoorZ(world, pos.func_177952_p() + 11 + 7 * r, pos.func_177958_n() + 7 + 7 * p, pos.func_177956_o() + 5 * q, 2, 2);
                            continue;
                        }
                        if (r == 1) {
                            this.generateDoorX(world, pos.func_177958_n() + 4 + 7 * p, pos.func_177956_o() + 5 * q, pos.func_177952_p() + 7 + 7 * r, 2, 2);
                            this.generateDoorZ(world, pos.func_177952_p() + 4 + 7 * r, pos.func_177958_n() + 7 + 7 * p, pos.func_177956_o() + 5 * q, 2, 2);
                            this.generateDoorZ(world, pos.func_177952_p() + 11 + 7 * r, pos.func_177958_n() + 7 + 7 * p, pos.func_177956_o() + 5 * q, 2, 2);
                            continue;
                        }
                        if (r != 2) continue;
                        this.generateDoorX(world, pos.func_177958_n() + 4 + 7 * p, pos.func_177956_o() + 5 * q, pos.func_177952_p() + 7 + 7 * r, 2, 2);
                        this.generateDoorZ(world, pos.func_177952_p() + 4 + 7 * r, pos.func_177958_n() + 7 + 7 * p, pos.func_177956_o() + 5 * q, 2, 2);
                        continue;
                    }
                    int type = this.rooms[p][q][r];
                    if (p + 1 < 3 && (newType = this.rooms[p + 1][q][r]) != 2 && (newType != 1 || type != 1)) {
                        this.rooms[p][q][r] = 3;
                        type = 3;
                        this.generateDoorX(world, pos.func_177958_n() + 11 + 7 * p, pos.func_177956_o() + 5 * q, pos.func_177952_p() + 7 + 7 * r, 2, 2);
                    }
                    if (p - 1 > 0 && (newType = this.rooms[p - 1][q][r]) != 2 && (newType != 1 || type != 1)) {
                        this.rooms[p][q][r] = 4;
                        type = 4;
                        this.generateDoorX(world, pos.func_177958_n() + 4 + 7 * p, pos.func_177956_o() + 5 * q, pos.func_177952_p() + 7 + 7 * r, 2, 2);
                    }
                    if (r + 1 < 3 && (newType = this.rooms[p][q][r + 1]) != 2 && (newType != 1 || type != 1)) {
                        this.rooms[p][q][r] = 5;
                        type = 5;
                        this.generateDoorZ(world, pos.func_177952_p() + 11 + 7 * r, pos.func_177958_n() + 7 + 7 * p, pos.func_177956_o() + 5 * q, 2, 2);
                    }
                    if (r - 1 > 0 && (newType = this.rooms[p][q][r - 1]) != 2 && (newType != 1 || type != 1)) {
                        this.rooms[p][q][r] = 6;
                        type = 6;
                        this.generateDoorZ(world, pos.func_177952_p() + 4 + 7 * r, pos.func_177958_n() + 7 + 7 * p, pos.func_177956_o() + 5 * q, 2, 2);
                    }
                    int roomType = random.nextInt(3);
                    if (type < 3) continue;
                    this.func_175903_a(world, new BlockPos(pos.func_177958_n() + 7 + p * 7, pos.func_177956_o() - 1 + q * 5, pos.func_177952_p() + 7 + r * 7), BlocksAether.dungeon_trap.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)));
                    switch (roomType) {
                        case 1: {
                            this.addPlaneY(world, random, new PositionData(pos.func_177958_n() + 7 + 7 * p, pos.func_177956_o() + 5 * q, pos.func_177952_p() + 7 + 7 * r), new PositionData(2, 0, 2));
                            int u = pos.func_177958_n() + 7 + 7 * p + random.nextInt(2);
                            int v = pos.func_177952_p() + 7 + 7 * r + random.nextInt(2);
                            if (world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(u, pos.func_177956_o() + 5 * q + 1, v)).func_177230_c() != Blocks.field_150350_a) continue block15;
                            this.func_175903_a(world, new BlockPos(u, pos.func_177956_o() + 5 * q + 1, v), Blocks.field_150486_ae.func_176223_P());
                            TileEntityChest chest = (TileEntityChest)world.func_175625_s(new BlockPos(u, pos.func_177956_o() + 5 * q + 1, v));
                            for (u = 0; u < 3 + random.nextInt(3); ++u) {
                                chest.func_70299_a(random.nextInt(chest.func_70302_i_()), this.getNormalLoot(random));
                            }
                            continue block15;
                        }
                        case 2: {
                            this.addPlaneY(world, random, new PositionData(pos.func_177958_n() + 7 + 7 * p, pos.func_177956_o() + 5 * q, pos.func_177952_p() + 7 + 7 * r), new PositionData(2, 0, 2));
                            this.func_175903_a(world, new BlockPos(pos.func_177958_n() + 7 + 7 * p + random.nextInt(2), pos.func_177956_o() + 5 * q + 1, pos.func_177952_p() + 7 + 7 * r + random.nextInt(2)), BlocksAether.chest_mimic.func_176223_P());
                            this.func_175903_a(world, new BlockPos(pos.func_177958_n() + 7 + 7 * p + random.nextInt(2), pos.func_177956_o() + 5 * q + 1, pos.func_177952_p() + 7 + 7 * r + random.nextInt(2)), BlocksAether.chest_mimic.func_176223_P());
                        }
                    }
                }
            }
        }
        for (x = 0; x < 24; ++x) {
            for (z = 0; z < 20; ++z) {
                int distance = (int)(Math.sqrt(x * x + (z - 7) * (z - 7)) + Math.sqrt(x * x + (z - 12) * (z - 12)));
                if (distance == 21) {
                    this.func_175903_a(world, new BlockPos(pos.func_177958_n() + 26 + x, pos.func_177956_o(), pos.func_177952_p() + 5 + z), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic)));
                    continue;
                }
                if (distance <= 21) continue;
                this.func_175903_a(world, new BlockPos(pos.func_177958_n() + 26 + x, pos.func_177956_o(), pos.func_177952_p() + 5 + z), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)));
            }
        }
        this.setBlocks(BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic)), 20);
        this.addPlaneY(world, random, new PositionData(pos.func_177958_n() + 44, pos.func_177956_o() + 1, pos.func_177952_p() + 11), new PositionData(6, 0, 8));
        this.addSolidBox(world, random, new PositionData(pos.func_177958_n() + 46, pos.func_177956_o() + 2, pos.func_177952_p() + 13), new PositionData(4, 2, 4));
        this.addLineX(world, random, new PositionData(pos.func_177958_n() + 46, pos.func_177956_o() + 4, pos.func_177952_p() + 13), 4);
        this.addLineX(world, random, new PositionData(pos.func_177958_n() + 46, pos.func_177956_o() + 4, pos.func_177952_p() + 16), 4);
        this.addPlaneX(world, random, new PositionData(pos.func_177958_n() + 49, pos.func_177956_o() + 4, pos.func_177952_p() + 13), new PositionData(0, 4, 4));
        this.setBlocks(Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BLUE), Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BLUE), 20);
        this.addPlaneY(world, random, new PositionData(pos.func_177958_n() + 47, pos.func_177956_o() + 3, pos.func_177952_p() + 14), new PositionData(2, 0, 2));
        for (x = 0; x < 2; ++x) {
            for (z = 0; z < 2; ++z) {
                this.func_175903_a(world, new BlockPos(pos.func_177958_n() + 44 + x * 5, pos.func_177956_o() + 2, pos.func_177952_p() + 11 + z * 7), BlocksAether.ambrosium_torch.func_176223_P());
            }
        }
        this.setBlocks(BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic)), 20);
        this.addPlaneY(world, random, new PositionData(pos.func_177958_n() + 35, pos.func_177956_o() + 1, pos.func_177952_p() + 5), new PositionData(6, 0, 3));
        this.addPlaneY(world, random, new PositionData(pos.func_177958_n() + 35, pos.func_177956_o() + 1, pos.func_177952_p() + 22), new PositionData(6, 0, 3));
        this.setBlocks(BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic)), 20);
        this.addLineZ(world, random, new PositionData(pos.func_177958_n() + 34, pos.func_177956_o() + 1, pos.func_177952_p() + 5), 2);
        this.addLineZ(world, random, new PositionData(pos.func_177958_n() + 41, pos.func_177956_o() + 1, pos.func_177952_p() + 5), 2);
        this.addLineX(world, random, new PositionData(pos.func_177958_n() + 36, pos.func_177956_o() + 1, pos.func_177952_p() + 8), 4);
        this.addLineZ(world, random, new PositionData(pos.func_177958_n() + 34, pos.func_177956_o() + 1, pos.func_177952_p() + 23), 2);
        this.addLineZ(world, random, new PositionData(pos.func_177958_n() + 41, pos.func_177956_o() + 1, pos.func_177952_p() + 23), 2);
        this.addLineX(world, random, new PositionData(pos.func_177958_n() + 36, pos.func_177956_o() + 1, pos.func_177952_p() + 21), 4);
        this.setBlocks(Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), 1);
        this.addPlaneY(world, random, new PositionData(pos.func_177958_n() + 35, pos.func_177956_o() + 1, pos.func_177952_p() + 5), new PositionData(6, 0, 3));
        this.addPlaneY(world, random, new PositionData(pos.func_177958_n() + 35, pos.func_177956_o() + 1, pos.func_177952_p() + 22), new PositionData(6, 0, 3));
        this.func_175903_a(world, new BlockPos(pos.func_177958_n() + 35, pos.func_177956_o() + 1, pos.func_177952_p() + 7), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)));
        this.func_175903_a(world, new BlockPos(pos.func_177958_n() + 40, pos.func_177956_o() + 1, pos.func_177952_p() + 7), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)));
        this.func_175903_a(world, new BlockPos(pos.func_177958_n() + 35, pos.func_177956_o() + 1, pos.func_177952_p() + 22), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)));
        this.func_175903_a(world, new BlockPos(pos.func_177958_n() + 40, pos.func_177956_o() + 1, pos.func_177952_p() + 22), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)));
        for (x = pos.func_177958_n() + 36; x < pos.func_177958_n() + 40; x += 3) {
            for (z = pos.func_177952_p() + 8; z < pos.func_177952_p() + 22; z += 13) {
                this.func_175903_a(world, new BlockPos(x, pos.func_177956_o() + 2, z), BlocksAether.ambrosium_torch.func_176223_P());
            }
        }
        this.addChandelier(world, pos.func_177958_n() + 28, pos.func_177956_o(), pos.func_177952_p() + 10, 8);
        this.addChandelier(world, pos.func_177958_n() + 43, pos.func_177956_o(), pos.func_177952_p() + 10, 8);
        this.addChandelier(world, pos.func_177958_n() + 43, pos.func_177956_o(), pos.func_177952_p() + 19, 8);
        this.addChandelier(world, pos.func_177958_n() + 28, pos.func_177956_o(), pos.func_177952_p() + 19, 8);
        this.addSapling(world, random, new PositionData(pos.func_177958_n() + 45, pos.func_177956_o() + 1, pos.func_177952_p() + 6));
        this.addSapling(world, random, new PositionData(pos.func_177958_n() + 45, pos.func_177956_o() + 1, pos.func_177952_p() + 21));
        EntityValkyrieQueen valk = new EntityValkyrieQueen(world, (double)pos.func_177958_n() + 40.0, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 15.0);
        valk.func_70107_b(pos.func_177958_n() + 40, pos.func_177956_o() + 2, pos.func_177952_p() + 15);
        valk.setDungeon(pos.func_177958_n() + 26, pos.func_177956_o(), pos.func_177952_p() + 5);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)valk);
        }
        this.setBlocks(BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic)), 20);
        this.addHollowBox(world, random, new PositionData(pos.func_177958_n() + 41, pos.func_177956_o() - 2, pos.func_177952_p() + 13), new PositionData(4, 4, 4));
        x = pos.func_177958_n() + 42 + random.nextInt(2);
        z = pos.func_177952_p() + 14 + random.nextInt(2);
        this.func_175903_a(world, new BlockPos(x, pos.func_177956_o() - 1, z), BlocksAether.treasure_chest.func_176223_P());
        return true;
    }

    private void addSapling(World world, Random random, PositionData pos) {
        this.setBlocks(BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic)), 2);
        this.addPlaneY(world, random, pos, new PositionData(3, 0, 3));
        BlockPos blockPos = new BlockPos(pos.getX(), pos.getY(), pos.getZ());
        this.func_175903_a(world, blockPos.func_177982_a(1, 0, 1), BlocksAether.aether_dirt.func_176223_P());
        this.func_175903_a(world, blockPos.func_177982_a(1, 1, 1), BlocksAether.golden_oak_sapling.func_176223_P());
        for (int x = pos.getX(); x < pos.getX() + 3; x += 2) {
            for (int z = pos.getZ(); z < pos.getZ() + 3; z += 2) {
                this.func_175903_a(world, new BlockPos(x, pos.getY() + 1, z), BlocksAether.ambrosium_torch.func_176223_P());
            }
        }
    }

    private void addChandelier(World world, int i, int j, int k, int height) {
        int y;
        for (y = j + height + 3; y < j + height + 6; ++y) {
            this.func_175903_a(world, new BlockPos(i, y, k), Blocks.field_180407_aO.func_176223_P());
        }
        for (int x = i - 1; x < i + 2; ++x) {
            this.func_175903_a(world, new BlockPos(x, j + height + 1, k), Blocks.field_150426_aN.func_176223_P());
        }
        for (y = j + height; y < j + height + 3; ++y) {
            this.func_175903_a(world, new BlockPos(i, y, k), Blocks.field_150426_aN.func_176223_P());
        }
        for (int z = k - 1; z < k + 2; ++z) {
            this.func_175903_a(world, new BlockPos(i, j + height + 1, z), Blocks.field_150426_aN.func_176223_P());
        }
    }

    private void addColumn(World world, Random random, PositionData pos, int h) {
        this.setBlocks(BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic)), 20);
        this.addPlaneY(world, random, pos, new PositionData(3, 0, 3));
        this.addPlaneY(world, random, new PositionData(pos.getX(), pos.getY() + h, pos.getZ()), new PositionData(3, 0, 3));
        this.setBlocks(BlocksAether.pillar.func_176223_P(), BlocksAether.pillar.func_176223_P(), 1);
        this.addLineY(world, random, new PositionData(pos.getX() + 1, pos.getY(), pos.getZ() + 1), h - 1);
        this.func_175903_a(world, new BlockPos(pos.getX() + 1, pos.getY() + h - 1, pos.getZ() + 1), BlocksAether.pillar_top.func_176223_P());
    }

    private void addStaircase(World world, Random random, PositionData pos, int height) {
        this.setBlocks(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 1);
        this.addSolidBox(world, random, new PositionData(pos.getX() + 1, pos.getY(), pos.getZ() + 1), new PositionData(4, height, 4));
        this.setBlocks(BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic)), BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic)), 5);
        this.addSolidBox(world, random, new PositionData(pos.getX() + 2, pos.getY(), pos.getZ() + 2), new PositionData(2, height + 4, 2));
        BlockPos blockPos = new BlockPos(pos.getX(), pos.getY(), pos.getZ());
        IBlockState slab = Blocks.field_150333_U.func_176223_P();
        IBlockState double_slab = Blocks.field_150334_T.func_176223_P();
        this.func_175903_a(world, blockPos.func_177982_a(1, 0, 1), slab);
        this.func_175903_a(world, blockPos.func_177982_a(2, 0, 1), double_slab);
        this.func_175903_a(world, blockPos.func_177982_a(3, 1, 1), slab);
        this.func_175903_a(world, blockPos.func_177982_a(4, 1, 1), double_slab);
        this.func_175903_a(world, blockPos.func_177982_a(4, 2, 2), slab);
        this.func_175903_a(world, blockPos.func_177982_a(4, 2, 3), double_slab);
        this.func_175903_a(world, blockPos.func_177982_a(4, 3, 4), slab);
        this.func_175903_a(world, blockPos.func_177982_a(3, 3, 4), double_slab);
        this.func_175903_a(world, blockPos.func_177982_a(2, 4, 4), slab);
        this.func_175903_a(world, blockPos.func_177982_a(1, 4, 4), double_slab);
        if (height == 5) {
            return;
        }
        this.func_175903_a(world, blockPos.func_177982_a(1, 5, 3), slab);
        this.func_175903_a(world, blockPos.func_177982_a(1, 5, 2), double_slab);
        this.func_175903_a(world, blockPos.func_177982_a(1, 6, 1), slab);
        this.func_175903_a(world, blockPos.func_177982_a(2, 6, 1), double_slab);
        this.func_175903_a(world, blockPos.func_177982_a(3, 7, 1), slab);
        this.func_175903_a(world, blockPos.func_177982_a(4, 7, 1), double_slab);
        this.func_175903_a(world, blockPos.func_177982_a(4, 8, 2), slab);
        this.func_175903_a(world, blockPos.func_177982_a(4, 8, 3), double_slab);
        this.func_175903_a(world, blockPos.func_177982_a(4, 9, 4), slab);
        this.func_175903_a(world, blockPos.func_177982_a(3, 9, 4), double_slab);
    }

    private ItemStack getNormalLoot(Random random) {
        int item = random.nextInt(16);
        switch (item) {
            case 0: {
                return new ItemStack(ItemsAether.zanite_pickaxe);
            }
            case 1: {
                return new ItemStack(ItemsAether.skyroot_bucket);
            }
            case 2: {
                return new ItemStack(ItemsAether.dart_shooter);
            }
            case 3: {
                return ItemMoaEgg.getStackFromType(AetherEntities.WHITE_MOA);
            }
            case 4: {
                return new ItemStack(ItemsAether.ambrosium_shard, random.nextInt(10) + 1);
            }
            case 5: {
                return new ItemStack(ItemsAether.dart, random.nextInt(5) + 1, 0);
            }
            case 6: {
                return new ItemStack(ItemsAether.dart, random.nextInt(3) + 1, 1);
            }
            case 7: {
                return new ItemStack(ItemsAether.dart, random.nextInt(3) + 1, 2);
            }
            case 8: {
                if (random.nextInt(20) != 0) break;
                return new ItemStack(ItemsAether.aether_tune);
            }
            case 9: {
                return new ItemStack(ItemsAether.skyroot_bucket, 1, 2);
            }
            case 10: {
                if (random.nextInt(10) != 0) break;
                return new ItemStack(ItemsAether.ascending_dawn);
            }
            case 11: {
                if (random.nextInt(2) == 0) {
                    return new ItemStack(ItemsAether.zanite_boots);
                }
                if (random.nextInt(2) == 0) {
                    return new ItemStack(ItemsAether.zanite_helmet);
                }
                if (random.nextInt(2) == 0) {
                    return new ItemStack(ItemsAether.zanite_leggings);
                }
                if (random.nextInt(2) != 0) break;
                return new ItemStack(ItemsAether.zanite_chestplate);
            }
            case 12: {
                if (random.nextInt(4) == 0) {
                    return new ItemStack(ItemsAether.iron_pendant);
                }
            }
            case 13: {
                if (random.nextInt(10) == 0) {
                    return new ItemStack(ItemsAether.golden_pendant);
                }
            }
            case 14: {
                if (random.nextInt(15) != 0) break;
                return new ItemStack(ItemsAether.zanite_ring);
            }
        }
        return new ItemStack(BlocksAether.ambrosium_torch, random.nextInt(4) + 1);
    }

    public static ItemStack getSilverLoot(Random random) {
        int item = random.nextInt(13);
        switch (item) {
            case 0: {
                return new ItemStack(ItemsAether.gummy_swet, random.nextInt(15) + 1);
            }
            case 1: {
                return new ItemStack(ItemsAether.lightning_sword);
            }
            case 2: {
                if (random.nextBoolean()) {
                    return new ItemStack(ItemsAether.valkyrie_axe);
                }
                if (random.nextBoolean()) {
                    return new ItemStack(ItemsAether.valkyrie_shovel);
                }
                if (!random.nextBoolean()) break;
                return new ItemStack(ItemsAether.valkyrie_pickaxe);
            }
            case 3: {
                return new ItemStack(ItemsAether.holy_sword);
            }
            case 4: {
                return new ItemStack(ItemsAether.valkyrie_helmet);
            }
            case 5: {
                return new ItemStack(ItemsAether.regeneration_stone);
            }
            case 6: {
                if (random.nextBoolean()) {
                    return new ItemStack(ItemsAether.neptune_helmet);
                }
                if (random.nextBoolean()) {
                    return new ItemStack(ItemsAether.neptune_leggings);
                }
                if (!random.nextBoolean()) break;
                return new ItemStack(ItemsAether.neptune_chestplate);
            }
            case 7: {
                if (random.nextBoolean()) {
                    return new ItemStack(ItemsAether.neptune_boots);
                }
                return new ItemStack(ItemsAether.neptune_gloves);
            }
            case 8: {
                return new ItemStack(ItemsAether.invisibility_cape);
            }
            case 9: {
                if (random.nextBoolean()) {
                    return new ItemStack(ItemsAether.valkyrie_boots);
                }
                return new ItemStack(ItemsAether.valkyrie_gloves);
            }
            case 10: {
                return new ItemStack(ItemsAether.valkyrie_leggings);
            }
            case 11: {
                if (!random.nextBoolean()) break;
                return new ItemStack(ItemsAether.valkyrie_chestplate);
            }
        }
        return new ItemStack(ItemsAether.golden_feather);
    }
}

