/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.tile_entities;

import com.legacy.aether.api.events.AetherHooks;
import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.blocks.container.BlockAetherContainer;
import com.legacy.aether.entities.passive.mountable.EntityMoa;
import com.legacy.aether.items.ItemMoaEgg;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.registry.achievements.AchievementsAether;
import com.legacy.aether.tile_entities.util.AetherTileEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;

public class TileEntityIncubator
extends AetherTileEntity {
    public EntityPlayer owner;
    public int progress;
    public int powerRemaining;
    public int ticksRequired = 5700;
    private NonNullList<ItemStack> incubatorItemStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);

    public TileEntityIncubator() {
        super("incubator");
    }

    @Override
    public NonNullList<ItemStack> getTileInventory() {
        return this.incubatorItemStacks;
    }

    @Override
    public void onSlotChanged(int index) {
        if (index == 1) {
            this.progress = 0;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74762_e("IncubationProgress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74777_a("IncubationProgress", (short)this.progress);
        return super.func_189515_b(nbttagcompound);
    }

    public int getProgressScaled(int i) {
        return this.progress * i / this.ticksRequired;
    }

    public int getPowerTimeRemainingScaled(int i) {
        return this.powerRemaining * i / 500;
    }

    public boolean isIncubating() {
        return this.func_174887_a_(1) > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isIncubating();
        if (this.powerRemaining > 0) {
            --this.powerRemaining;
            if (!this.func_70301_a(1).func_190926_b()) {
                this.progress = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()).func_177230_c() == Blocks.field_189877_df ? (int)((float)this.progress + 2.0f) : ++this.progress;
            }
        }
        if (this.progress >= this.ticksRequired) {
            if (this.func_70301_a(1).func_77973_b() instanceof ItemMoaEgg) {
                ItemMoaEgg moaEgg = (ItemMoaEgg)this.func_70301_a(1).func_77973_b();
                if (!this.field_145850_b.field_72995_K) {
                    EntityMoa moa = new EntityMoa(this.field_145850_b);
                    moa.setPlayerGrown(true);
                    moa.func_70873_a(-24000);
                    moa.setMoaType(moaEgg.getMoaTypeFromItemStack(this.func_70301_a(1)));
                    int safeY = 0;
                    while (!this.field_145850_b.func_175623_d(this.field_174879_c.func_177981_b(safeY))) {
                        moa.func_70634_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + safeY) + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5);
                        ++safeY;
                    }
                    this.field_145850_b.func_72838_d((Entity)moa);
                    if (this.owner != null) {
                        this.owner.func_71029_a((StatBase)AchievementsAether.incubator);
                    }
                }
                AetherHooks.onMoaHatched(moaEgg.getMoaTypeFromItemStack(this.func_70301_a(1)), this);
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_70298_a(1, 1);
            }
            this.progress = 0;
        }
        if (this.powerRemaining <= 0) {
            if (this.func_70301_a(1).func_77973_b() == ItemsAether.moa_egg && this.func_70301_a(0).func_77973_b() == Item.func_150898_a((Block)BlocksAether.ambrosium_torch)) {
                this.powerRemaining += 1000;
                if (!this.field_145850_b.field_72995_K) {
                    this.func_70298_a(0, 1);
                }
            } else {
                this.powerRemaining = 0;
                this.progress = 0;
            }
        }
        if (flag != this.isIncubating()) {
            this.func_70296_d();
            BlockAetherContainer.setState(this.field_145850_b, this.field_174879_c, this.isIncubating());
        }
    }

    @Override
    public boolean isValidSlotItem(int index, ItemStack itemstack) {
        return index == 0 && itemstack.func_77973_b() == Item.func_150898_a((Block)BlocksAether.ambrosium_torch) ? true : index == 1 && itemstack.func_77973_b() == ItemsAether.moa_egg;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            nArray = new int[]{};
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 1;
        }
        return nArray;
    }

    @Override
    public int func_174887_a_(int id) {
        if (id == 0) {
            return this.progress;
        }
        if (id == 1) {
            return this.powerRemaining;
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id == 0) {
            this.progress = value;
        } else if (id == 1) {
            this.powerRemaining = value;
        }
    }

    @Override
    public int func_174890_g() {
        return 2;
    }
}

