/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.player;

import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.networking.AetherNetworkingManager;
import com.legacy.aether.networking.packets.PacketAchievement;
import com.legacy.aether.player.PlayerAether;
import com.legacy.aether.player.capability.PlayerAetherProvider;
import com.legacy.aether.registry.achievements.AchievementsAether;
import com.legacy.aether.registry.objects.AetherAchievement;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandClearInventory;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AchievementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class PlayerAetherEvents {
    private static final ResourceLocation PLAYER_LOCATION = new ResourceLocation("aether_legacy", "aether_players");

    @SubscribeEvent
    public void PlayerConstructingEvent(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            PlayerAetherProvider provider = new PlayerAetherProvider(new PlayerAether(player));
            if (PlayerAether.get(player) == null) {
                event.addCapability(PLAYER_LOCATION, (ICapabilityProvider)provider);
            }
        }
    }

    @SubscribeEvent
    public void checkPlayerVisibility(PlayerEvent.Visibility event) {
        PlayerAether capability = PlayerAether.get(event.getEntityPlayer());
        if (capability != null && capability.wearingAccessory(ItemsAether.invisibility_cape)) {
            event.modifyVisibility(0.0);
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        PlayerAether original = PlayerAether.get(event.getOriginal());
        PlayerAether newPlayer = PlayerAether.get(event.getEntityPlayer());
        NBTTagCompound data = new NBTTagCompound();
        if (original != null) {
            original.saveNBTData(data);
            if (newPlayer != null) {
                newPlayer.portalCooldown = original.portalCooldown;
                newPlayer.loadNBTData(data);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        PlayerAether playerAether;
        if (event.getEntity() instanceof EntityPlayer && (playerAether = PlayerAether.get((EntityPlayer)event.getEntity())) != null) {
            playerAether.onPlayerDeath();
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        PlayerAether playerAether = PlayerAether.get(event.player);
        if (playerAether != null) {
            playerAether.onPlayerRespawn();
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        PlayerAether playerAether;
        if (event.getEntityLiving() instanceof EntityPlayer && (playerAether = PlayerAether.get((EntityPlayer)event.getEntityLiving())) != null) {
            playerAether.onUpdate();
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        PlayerAether playerAether;
        if (event.getEntityLiving() instanceof EntityPlayer && (playerAether = PlayerAether.get((EntityPlayer)event.getEntityLiving())) != null) {
            event.setCanceled(playerAether.onPlayerAttacked(event.getSource()));
        }
    }

    @SubscribeEvent
    public void onChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerAether playerAether = PlayerAether.get(event.player);
        if (playerAether != null) {
            playerAether.onChangedDimension(event.toDim, event.fromDim);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        PlayerAether playerAether = PlayerAether.get(player);
        if (playerAether != null) {
            playerAether.accessories.func_70296_d();
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        PlayerAether playerAether;
        if (event.getEntityLiving() instanceof EntityPlayer && (playerAether = PlayerAether.get((EntityPlayer)event.getEntityLiving())) != null && playerAether.isWearingObsidianSet()) {
            float original = event.getAmount();
            event.setAmount(original / 2.0f);
        }
    }

    @SubscribeEvent
    public void onPlayerStrVsBlock(PlayerEvent.BreakSpeed event) {
        PlayerAether playerAether = PlayerAether.get(event.getEntityPlayer());
        if (playerAether != null) {
            event.setNewSpeed(playerAether.getCurrentPlayerStrVsBlock(event.getOriginalSpeed()));
        }
    }

    @SubscribeEvent
    public void onCommandSentEvent(CommandEvent event) {
        if (event.getCommand() instanceof CommandClearInventory && event.getParameters().length <= 1) {
            EntityPlayerMP entityplayermp = null;
            try {
                entityplayermp = event.getParameters().length == 0 ? CommandBase.func_71521_c((ICommandSender)event.getSender()) : CommandBase.func_184888_a((MinecraftServer)FMLCommonHandler.instance().getMinecraftServerInstance(), (ICommandSender)event.getSender(), (String)event.getParameters()[0]);
            }
            catch (Throwable var9) {
                return;
            }
            PlayerAether playerAether = PlayerAether.get((EntityPlayer)entityplayermp);
            if (playerAether != null && playerAether.accessories.func_174890_g() != 0) {
                playerAether.accessories.func_174888_l();
                CommandBase.func_152373_a((ICommandSender)entityplayermp, (ICommand)event.getCommand(), (String)("Cleared the accessories of " + entityplayermp.func_70005_c_()), (Object[])new Object[0]);
            }
        }
    }

    @SubscribeEvent
    public void onAchievementGet(AchievementEvent event) {
        int achievementType;
        Achievement achievement = event.getAchievement();
        EntityPlayer player = event.getEntityPlayer();
        if (!(achievement instanceof AetherAchievement)) {
            return;
        }
        int n = achievement == AchievementsAether.defeat_bronze ? 1 : (achievementType = achievement == AchievementsAether.defeat_silver ? 2 : 0);
        if (!player.field_70170_p.field_72995_K && ((EntityPlayerMP)player).func_147099_x().func_77442_b(achievement) && !player.func_189102_a(achievement)) {
            if (event.getAchievement() == AchievementsAether.enter_aether) {
                if (!player.field_71071_by.func_70441_a(new ItemStack(ItemsAether.lore_book))) {
                    player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(ItemsAether.lore_book)));
                }
                if (!player.field_71071_by.func_70441_a(new ItemStack(ItemsAether.golden_parachute))) {
                    player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(ItemsAether.golden_parachute)));
                }
            }
            AetherNetworkingManager.sendTo(new PacketAchievement(achievementType), (EntityPlayerMP)player);
        }
    }
}

