/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.containers.inventory;

import com.legacy.aether.api.AetherAPI;
import com.legacy.aether.api.accessories.AccessoryType;
import com.legacy.aether.api.accessories.AetherAccessory;
import com.legacy.aether.items.accessories.ItemAccessory;
import com.legacy.aether.player.PlayerAether;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;

public class InventoryAccessories
implements IInventory {
    public EntityPlayer player;
    public NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    public static final String[] EMPTY_SLOT_NAMES = new String[]{"pendant", "cape", "shield", "misc", "ring", "ring", "gloves", "misc"};
    public AccessoryType[] slotTypes = new AccessoryType[]{AccessoryType.PENDANT, AccessoryType.CAPE, AccessoryType.SHIELD, AccessoryType.MISC, AccessoryType.RING, AccessoryType.RING, AccessoryType.GLOVE, AccessoryType.MISC};

    public InventoryAccessories(PlayerAether playerAether) {
        this.player = playerAether.thePlayer;
    }

    public void dropAllItems() {
        for (int slot = 0; slot < this.stacks.size(); ++slot) {
            if (this.stacks.get(slot) == ItemStack.field_190927_a) continue;
            this.player.func_146097_a((ItemStack)this.stacks.get(slot), true, true);
            this.stacks.set(slot, (Object)ItemStack.field_190927_a);
        }
    }

    public void damageItemStackIfWearing(ItemStack itemStack) {
        ItemStack currentAccessory = this.getStackFromItem(itemStack.func_77973_b());
        if (currentAccessory != ItemStack.field_190927_a && !this.player.field_71075_bZ.field_75098_d) {
            currentAccessory.func_77972_a(1, (EntityLivingBase)this.player);
            if (currentAccessory.func_77952_i() >= currentAccessory.func_77958_k()) {
                this.breakItem(currentAccessory.func_77973_b());
            }
        }
    }

    public int breakItem(Item item) {
        int count = 0;
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.stacks.get(i);
            if (itemstack.func_190926_b() || itemstack != this.getStackFromItem(item) || item == null && itemstack.func_77973_b() != item) continue;
            if (itemstack.func_77978_p() != null && itemstack.func_77978_p().func_74767_n("Unbreakable")) {
                return count;
            }
            count += itemstack.func_190916_E();
            this.stacks.set(i, (Object)ItemStack.field_190927_a);
        }
        return count;
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public boolean setInventoryAccessory(ItemStack stack) {
        if (!stack.func_190926_b() && AetherAPI.getInstance().isAccessory(stack)) {
            AetherAccessory accessory = AetherAPI.getInstance().getAccessory(stack);
            int stackIndex = 0;
            for (AccessoryType type : this.slotTypes) {
                if (accessory.getAccessoryType() == type && ((ItemStack)this.stacks.get(stackIndex)).func_190926_b()) {
                    this.stacks.set(stackIndex, (Object)stack);
                    this.func_70296_d();
                    return true;
                }
                ++stackIndex;
            }
        }
        return false;
    }

    public void func_70299_a(int slotID, ItemStack stack) {
        if (slotID < this.stacks.size()) {
            this.stacks.set(slotID, (Object)stack);
            this.func_70296_d();
        }
    }

    public ItemStack func_70301_a(int slotID) {
        return (ItemStack)this.stacks.get(slotID);
    }

    public ItemStack getStackFromItem(Item item) {
        for (ItemStack stack : this.stacks) {
            if (!(stack.func_77973_b() instanceof ItemAccessory) || stack.func_77973_b() != item) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int slotID, int decreaseSize) {
        if (!((ItemStack)this.stacks.get(slotID)).func_190926_b()) {
            ItemStack itemstack = ItemStack.field_190927_a;
            if (((ItemStack)this.stacks.get(slotID)).func_190916_E() <= decreaseSize) {
                itemstack = (ItemStack)this.stacks.get(slotID);
                this.stacks.set(slotID, (Object)ItemStack.field_190927_a);
                this.func_70296_d();
                return itemstack;
            }
            itemstack = ((ItemStack)this.stacks.get(slotID)).func_77979_a(decreaseSize);
            if (((ItemStack)this.stacks.get(slotID)).func_190916_E() == 0) {
                this.stacks.set(slotID, (Object)ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int slotID) {
        if (!((ItemStack)this.stacks.get(slotID)).func_190926_b()) {
            ItemStack itemstack = (ItemStack)this.stacks.get(slotID);
            this.stacks.set(slotID, (Object)ItemStack.field_190927_a);
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public String func_70005_c_() {
        return "accessories";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return !player.field_70128_L && player.func_70068_e((Entity)this.player) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slotID, ItemStack stack) {
        return true;
    }

    public void func_70296_d() {
        PlayerAether.get(this.player).updateAccessories();
    }

    public void copyAccessories(InventoryAccessories accessories) {
        for (int size = 0; size < this.stacks.size(); ++size) {
            this.stacks.set(size, (Object)((ItemStack)accessories.stacks.get(size)).func_77946_l());
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.stacks);
    }

    public void readFromNBT(NBTTagCompound compound) {
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.stacks);
    }

    public void writeData(ByteBuf dataOutput) {
        dataOutput.writeInt(this.stacks.size());
        for (ItemStack stack : this.stacks) {
            PacketBuffer pb = new PacketBuffer(dataOutput);
            try {
                pb.func_150788_a(stack);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void readData(ByteBuf dataInput) {
        int amount = dataInput.readInt();
        for (int i = 0; i < amount; ++i) {
            PacketBuffer pb = new PacketBuffer(dataInput);
            try {
                this.stacks.set(i, (Object)pb.func_150791_c());
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174887_a_(int id) {
        return id;
    }

    public int func_174890_g() {
        int count = 0;
        for (int slot = 0; slot < this.stacks.size(); ++slot) {
            if (((ItemStack)this.stacks.get(slot)).func_190926_b()) continue;
            ++count;
        }
        return count;
    }

    public void func_174888_l() {
        for (int slot = 0; slot < this.stacks.size(); ++slot) {
            ItemStack itemstack = (ItemStack)this.stacks.get(slot);
            if (itemstack.func_190926_b()) continue;
            this.stacks.set(slot, (Object)ItemStack.field_190927_a);
        }
        this.func_70296_d();
    }

    public boolean func_191420_l() {
        for (ItemStack stacks : this.stacks) {
            if (stacks.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

