/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.client.overlay;

import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.entities.bosses.slider.EntitySlider;
import com.legacy.aether.entities.bosses.sun_spirit.EntitySunSpirit;
import com.legacy.aether.entities.bosses.valkyrie_queen.EntityValkyrieQueen;
import com.legacy.aether.entities.passive.mountable.EntityMoa;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.player.PlayerAether;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AetherOverlay {
    private static final ResourceLocation TEXTURE_JUMPS = new ResourceLocation("aether_legacy", "textures/gui/jumps.png");
    private static final ResourceLocation TEXTURE_COOLDOWN_BAR = new ResourceLocation("aether_legacy", "textures/gui/cooldown_bar.png");
    private static final ResourceLocation TEXTURE_POISON_VIGNETTE = new ResourceLocation("aether_legacy", "textures/blur/poison_vignette.png");
    private static final ResourceLocation TEXTURE_CURE_VIGNETTE = new ResourceLocation("aether_legacy", "textures/blur/cure_vignette.png");

    public static void renderPoison(Minecraft mc) {
        PlayerAether playerAether = PlayerAether.get((EntityPlayer)mc.field_71439_g);
        if (playerAether.isPoisoned()) {
            ScaledResolution scaledresolution = new ScaledResolution(mc);
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer renderer = tessellator.func_178180_c();
            float alpha = AetherOverlay.getPoisonAlpha((float)(playerAether.poisonInstance().poisonTime % 50) / 50.0f);
            int width = scaledresolution.func_78326_a();
            int height = scaledresolution.func_78328_b();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179118_c();
            mc.field_71446_o.func_110577_a(TEXTURE_POISON_VIGNETTE);
            renderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            renderer.func_181662_b(0.0, (double)height, -90.0).func_187315_a(0.0, 1.0).func_181666_a(0.5f, 0.5f, 0.5f, alpha).func_181675_d();
            renderer.func_181662_b((double)width, (double)height, -90.0).func_187315_a(1.0, 1.0).func_181666_a(0.5f, 0.5f, 0.5f, alpha).func_181675_d();
            renderer.func_181662_b((double)width, 0.0, -90.0).func_187315_a(1.0, 0.0).func_181666_a(0.5f, 0.5f, 0.5f, alpha).func_181675_d();
            renderer.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181666_a(0.5f, 0.5f, 0.5f, alpha).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    public static void renderCure(Minecraft mc) {
        PlayerAether playerAether = PlayerAether.get((EntityPlayer)mc.field_71439_g);
        if (playerAether.isCured()) {
            ScaledResolution scaledresolution = new ScaledResolution(mc);
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer renderer = tessellator.func_178180_c();
            float alpha = 0.5f;
            int width = scaledresolution.func_78326_a();
            int height = scaledresolution.func_78328_b();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179118_c();
            mc.field_71446_o.func_110577_a(TEXTURE_CURE_VIGNETTE);
            renderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            renderer.func_181662_b(0.0, (double)height, -90.0).func_187315_a(0.0, 1.0).func_181666_a(0.5f, 0.5f, 0.5f, alpha).func_181675_d();
            renderer.func_181662_b((double)width, (double)height, -90.0).func_187315_a(1.0, 1.0).func_181666_a(0.5f, 0.5f, 0.5f, alpha).func_181675_d();
            renderer.func_181662_b((double)width, 0.0, -90.0).func_187315_a(1.0, 0.0).func_181666_a(0.5f, 0.5f, 0.5f, alpha).func_181675_d();
            renderer.func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181666_a(0.5f, 0.5f, 0.5f, alpha).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    public static void renderIronBubble(Minecraft mc) {
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        int width = scaledresolution.func_78326_a();
        int height = scaledresolution.func_78328_b();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        mc.field_71446_o.func_110577_a(Gui.field_110324_m);
        int bubbleAmount = PlayerAether.get((EntityPlayer)mc.field_71439_g).getAccessoryCount(ItemsAether.iron_bubble);
        if (mc.field_71442_b.func_78755_b() && mc.field_71439_g.func_70090_H() && mc.field_71439_g.func_70055_a(Material.field_151586_h)) {
            for (int i = 0; i < bubbleAmount; ++i) {
                AetherOverlay.drawTexturedModalRect(width / 2 - 8 * i + 81, height - 49, 16.0f, 18.0f, 9.0f, 9.0f);
            }
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static void renderCooldown(Minecraft mc) {
        PlayerAether playerInfo = PlayerAether.get((EntityPlayer)mc.field_71439_g);
        if (playerInfo.getCooldown() != 0) {
            ScaledResolution scaledresolution = new ScaledResolution(mc);
            int cooldownRemaining = (int)((float)playerInfo.getCooldown() / (float)playerInfo.getCooldownMax() * 128.0f);
            int width = scaledresolution.func_78326_a();
            mc.field_71466_p.func_175063_a(playerInfo.getCooldownName() + " Cooldown", (float)(width / 2 - mc.field_71466_p.func_78256_a(playerInfo.getCooldownName() + " Cooldown") / 2), 32.0f, -1);
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179118_c();
            mc.field_71446_o.func_110577_a(TEXTURE_COOLDOWN_BAR);
            AetherOverlay.drawTexturedModalRect(width / 2 - 64, 42.0f, 0.0f, 8.0f, 128.0f, 8.0f);
            AetherOverlay.drawTexturedModalRect(width / 2 - 64, 42.0f, 0.0f, 0.0f, cooldownRemaining, 8.0f);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    public static void renderJumps(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || player.func_184187_bx() == null || !(player.func_184187_bx() instanceof EntityMoa)) {
            return;
        }
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        EntityMoa moa = (EntityMoa)player.func_184187_bx();
        int width = scaledresolution.func_78326_a();
        GlStateManager.func_179094_E();
        mc.field_71446_o.func_110577_a(TEXTURE_JUMPS);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int jump = 0; jump < moa.getMaxJumps(); ++jump) {
            int yPos = 18;
            int xPos = width / 2 + jump * 8 - moa.getMaxJumps() * 8 / 2;
            if (jump < moa.getRemainingJumps()) {
                AetherOverlay.drawTexturedModalRect(xPos, yPos, 0.0f, 0.0f, 9.0f, 11.0f);
                continue;
            }
            AetherOverlay.drawTexturedModalRect(xPos, yPos, 10.0f, 0.0f, 9.0f, 11.0f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static void renderAetherPortal(float timeInPortal, ScaledResolution scaledRes) {
        if (timeInPortal < 1.0f) {
            timeInPortal *= timeInPortal;
            timeInPortal *= timeInPortal;
            timeInPortal = timeInPortal * 0.8f + 0.2f;
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)timeInPortal);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        TextureAtlasSprite textureatlassprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(BlocksAether.aether_portal.func_176223_P());
        float f = textureatlassprite.func_94209_e();
        float f1 = textureatlassprite.func_94206_g();
        float f2 = textureatlassprite.func_94212_f();
        float f3 = textureatlassprite.func_94210_h();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(0.0, (double)scaledRes.func_78328_b(), -90.0).func_187315_a((double)f, (double)f3).func_181675_d();
        vertexbuffer.func_181662_b((double)scaledRes.func_78326_a(), (double)scaledRes.func_78328_b(), -90.0).func_187315_a((double)f2, (double)f3).func_181675_d();
        vertexbuffer.func_181662_b((double)scaledRes.func_78326_a(), 0.0, -90.0).func_187315_a((double)f2, (double)f1).func_181675_d();
        vertexbuffer.func_181662_b(0.0, 0.0, -90.0).func_187315_a((double)f, (double)f1).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderBossHP(Minecraft mc) {
        PlayerAether player = PlayerAether.get((EntityPlayer)mc.field_71439_g);
        EntityLiving boss = (EntityLiving)player.getCurrentBoss();
        if (player.getCurrentBoss() != null) {
            String bossTitle = "";
            ScaledResolution scaledresolution = new ScaledResolution(mc);
            int healthRemaining = (int)(boss.func_110143_aJ() / boss.func_110138_aP() * 256.0f);
            int width = scaledresolution.func_78326_a();
            bossTitle = boss instanceof EntitySlider ? ((EntitySlider)boss).getBossTitle() : (boss instanceof EntityValkyrieQueen ? ((EntityValkyrieQueen)boss).getBossTitle() : ((EntitySunSpirit)boss).getBossTitle());
            GlStateManager.func_179094_E();
            mc.field_71466_p.func_175063_a(bossTitle, (float)(width / 2 - mc.field_71466_p.func_78256_a(bossTitle) / 2), 2.0f, -1);
            mc.field_71446_o.func_110577_a(new ResourceLocation("aether_legacy", "textures/gui/boss_bar.png"));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            AetherOverlay.drawTexturedModalRect(width / 2 - 128, 12.0f, 0.0f, 16.0f, 256.0f, 32.0f);
            AetherOverlay.drawTexturedModalRect(width / 2 - 128, 12.0f, 0.0f, 0.0f, healthRemaining, 16.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    public static void drawTexturedModalRect(float x, float y, float u, float v, float width, float height) {
        float zLevel = -90.0f;
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.func_178181_a();
        VertexBuffer renderer = var9.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b((double)(x + 0.0f), (double)(y + height), (double)zLevel).func_187315_a((double)((u + 0.0f) * var7), (double)((v + height) * var8)).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((u + width) * var7), (double)((v + height) * var8)).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + 0.0f), (double)zLevel).func_187315_a((double)((u + width) * var7), (double)((v + 0.0f) * var8)).func_181675_d();
        renderer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), (double)zLevel).func_187315_a((double)((u + 0.0f) * var7), (double)((v + 0.0f) * var8)).func_181675_d();
        var9.func_78381_a();
    }

    public static float getPoisonAlpha(float f) {
        return f * f / 5.0f + 0.4f;
    }

    public static float getCureAlpha(float f) {
        return f * f / 10.0f + 0.4f;
    }
}

