/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.blocks.portal;

import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.blocks.portal.BlockAetherPortal;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AetherPortalSize {
    private final World world;
    private final EnumFacing.Axis axis;
    public final EnumFacing rightDir;
    public final EnumFacing leftDir;
    public int portalBlockCount;
    public BlockPos bottomLeft;
    public int height;
    public int width;

    public AetherPortalSize(World worldIn, BlockPos position, EnumFacing.Axis axis) {
        this.world = worldIn;
        this.axis = axis;
        if (axis == EnumFacing.Axis.X) {
            this.leftDir = EnumFacing.EAST;
            this.rightDir = EnumFacing.WEST;
        } else {
            this.leftDir = EnumFacing.NORTH;
            this.rightDir = EnumFacing.SOUTH;
        }
        BlockPos blockpos = position;
        while (position.func_177956_o() > blockpos.func_177956_o() - 21 && position.func_177956_o() > 0 && this.isEmptyBlock(worldIn.func_180495_p(position.func_177977_b()).func_177230_c())) {
            position = position.func_177977_b();
        }
        int i = this.getDistanceUntilEdge(position, this.leftDir) - 1;
        if (i >= 0) {
            this.bottomLeft = position.func_177967_a(this.leftDir, i);
            this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
            if (this.width < 2 || this.width > 21) {
                this.bottomLeft = null;
                this.width = 0;
            }
        }
        if (this.bottomLeft != null) {
            this.height = this.calculatePortalHeight();
        }
    }

    protected int getDistanceUntilEdge(BlockPos position, EnumFacing axis) {
        BlockPos blockpos;
        int i;
        for (i = 0; i < 22 && this.isEmptyBlock(this.world.func_180495_p(blockpos = position.func_177967_a(axis, i)).func_177230_c()) && this.world.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_150426_aN; ++i) {
        }
        Block block = this.world.func_180495_p(position.func_177967_a(axis, i)).func_177230_c();
        return block == Blocks.field_150426_aN ? i : 0;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    protected int calculatePortalHeight() {
        this.height = 0;
        block0: while (this.height < 21) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                Block block = this.world.func_180495_p(blockpos).func_177230_c();
                if (!this.isEmptyBlock(block)) break block0;
                if (block == BlocksAether.aether_portal) {
                    ++this.portalBlockCount;
                }
                if (i == 0 ? (block = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir)).func_177230_c()) != Blocks.field_150426_aN : i == this.width - 1 && (block = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir)).func_177230_c()) != Blocks.field_150426_aN) break block0;
            }
            ++this.height;
        }
        for (int j = 0; j < this.width; ++j) {
            if (this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height)).func_177230_c() == Blocks.field_150426_aN) continue;
            this.height = 0;
            break;
        }
        if (this.height <= 21 && this.height >= 3) {
            return this.height;
        }
        this.bottomLeft = null;
        this.width = 0;
        this.height = 0;
        return 0;
    }

    protected boolean isEmptyBlock(Block blockIn) {
        return blockIn.func_176223_P().func_185904_a() == Material.field_151579_a || blockIn == Blocks.field_150480_ab || blockIn == BlocksAether.aether_portal;
    }

    public boolean isValid() {
        return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void placePortalBlocks() {
        for (int i = 0; i < this.width; ++i) {
            BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
            for (int j = 0; j < this.height; ++j) {
                this.world.func_180501_a(blockpos.func_177981_b(j), BlocksAether.aether_portal.func_176223_P().func_177226_a((IProperty)BlockAetherPortal.field_176550_a, (Comparable)this.axis), 2);
            }
        }
    }
}

