/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.blocks.natural;

import com.legacy.aether.Aether;
import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.blocks.util.EnumLogType;
import com.legacy.aether.blocks.util.IAetherMeta;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.items.tools.ItemAetherTool;
import com.legacy.aether.items.tools.ItemGravititeTool;
import com.legacy.aether.items.tools.ItemSkyrootTool;
import com.legacy.aether.items.tools.ItemValkyrieTool;
import com.legacy.aether.items.util.EnumAetherToolType;
import com.legacy.aether.registry.creative_tabs.AetherCreativeTabs;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAetherLog
extends BlockLog
implements IAetherMeta {
    public static final PropertyEnum<EnumLogType> wood_type = PropertyEnum.func_177709_a((String)"aether_logs", EnumLogType.class);
    public static final PropertyBool double_drop = PropertyBool.func_177716_a((String)Aether.doubleDropNotifier());

    public BlockAetherLog() {
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(AetherCreativeTabs.blocks);
        this.func_180632_j(this.func_176223_P().func_177226_a(wood_type, (Comparable)((Object)EnumLogType.Skyroot)).func_177226_a((IProperty)double_drop, (Comparable)Boolean.TRUE).func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a(wood_type, (Comparable)((Object)EnumLogType.getType(meta))).func_177226_a((IProperty)double_drop, (Comparable)Boolean.FALSE).func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k()));
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.func_175707_a(pos.func_177982_a(-5, -5, -5), pos.func_177982_a(5, 5, 5))) {
            for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-4, -4, -4), (BlockPos)pos.func_177982_a(4, 4, 4))) {
                IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                if (!iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, blockpos)) continue;
                iblockstate.func_177230_c().beginLeavesDecay(iblockstate, worldIn, blockpos);
            }
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stackIn) {
        player.func_71029_a(StatList.func_188055_a((Block)state.func_177230_c()));
        player.func_71020_j(0.025f);
        int size = ((Boolean)state.func_177229_b((IProperty)double_drop)).equals(true) ? 2 : 1;
        ItemStack stack = player.field_71071_by.func_70448_g();
        IBlockState defaults = BlocksAether.aether_log.func_176223_P();
        if (stack != null && stack.func_77973_b() instanceof ItemAetherTool && ((ItemAetherTool)stack.func_77973_b()).toolType == EnumAetherToolType.AXE) {
            if (stack.func_77973_b() instanceof ItemGravititeTool || stack.func_77973_b() instanceof ItemValkyrieTool) {
                if (state.func_177229_b(wood_type) == EnumLogType.Oak) {
                    BlockAetherLog.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(ItemsAether.golden_amber, 1 + RANDOM.nextInt(2)));
                }
                defaults.func_177230_c().func_176226_b(worldIn, pos, defaults, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca()));
            } else if (stack.func_77973_b() instanceof ItemSkyrootTool) {
                for (int i = 0; i < size; ++i) {
                    defaults.func_177230_c().func_176226_b(worldIn, pos, defaults, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca()));
                }
            } else {
                defaults.func_177230_c().func_176226_b(worldIn, pos, defaults, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca()));
            }
        } else {
            BlockAetherLog.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(defaults.func_177230_c()));
        }
    }

    @Override
    public String getMetaName(ItemStack stack) {
        return ((EnumLogType)((Object)this.func_176203_a(stack.func_77952_i()).func_177229_b(wood_type))).func_176610_l();
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 1));
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a(wood_type, (Comparable)((Object)EnumLogType.getType(meta))).func_177226_a((IProperty)double_drop, (Comparable)Boolean.valueOf(meta % 4 < 2));
        switch (meta & 0xC) {
            case 0: {
                iblockstate = iblockstate.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
                break;
            }
            case 4: {
                iblockstate = iblockstate.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.X);
                break;
            }
            case 8: {
                iblockstate = iblockstate.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
                break;
            }
            default: {
                iblockstate = iblockstate.func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
            }
        }
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta |= ((EnumLogType)((Object)state.func_177229_b(wood_type))).getMeta();
        if (!((Boolean)state.func_177229_b((IProperty)double_drop)).booleanValue()) {
            meta |= 2;
        }
        switch ((BlockLog.EnumAxis)state.func_177229_b((IProperty)field_176299_a)) {
            case Y: {
                break;
            }
            case X: {
                meta |= 4;
                break;
            }
            case Z: {
                meta |= 8;
                break;
            }
            case NONE: {
                meta |= 0xC;
            }
        }
        return meta;
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{wood_type, double_drop, field_176299_a});
    }
}

