/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether;

import com.legacy.aether.AetherLogger;
import java.io.File;
import java.io.IOException;
import net.minecraftforge.common.config.Configuration;

public class AetherConfig {
    private static boolean christmas_content;
    private static int aether_biome_id;
    private static int aether_dimension_id;
    private static boolean disable_trivia;
    private static boolean skyrootBucketOnly;
    private static boolean developer_mode;

    public static void init(File location) {
        File newFile = new File(location + "/aether/Aether_Legacy.cfg");
        try {
            newFile.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Configuration config = new Configuration(newFile);
        config.load();
        christmas_content = config.get("Aether World Generation", "Christmas Content", false).getBoolean(false);
        aether_dimension_id = config.get("World Identification", "Aether Dimension ID", 4).getInt(4);
        aether_biome_id = config.get("World Identification", "Aether Biome ID", 127).getInt(127);
        skyrootBucketOnly = config.get("Misc", "Activate portal with only Skyroot bucket", false).getBoolean(false);
        disable_trivia = config.get("Trivia", "Disable random trivia", false).getBoolean(false);
        developer_mode = config.get("Developer Options", "Enable extra logging for certain features", false).getBoolean(false);
        config.save();
    }

    public static int getAetherDimensionID() {
        return aether_dimension_id;
    }

    public static int getAetherBiomeID() {
        return aether_biome_id;
    }

    public static boolean triviaDisabled() {
        return disable_trivia;
    }

    public static boolean shouldLoadHolidayContent() {
        return christmas_content;
    }

    public static boolean activateOnlyWithSkyroot() {
        return skyrootBucketOnly;
    }

    public static void autoDeveloperMode(String versionNumber) {
        if (versionNumber.contains("dev")) {
            developer_mode = true;
            AetherLogger.print("It appears that you are using a development build of Aether Legacy. As such, developer mode has automatically been enabled regardless of configuration setting.");
        }
    }

    public static boolean developerMode() {
        return developer_mode;
    }
}

