/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.world.dungeon;

import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.blocks.dungeon.BlockDungeonBase;
import com.legacy.aether.blocks.util.EnumStoneType;
import com.legacy.aether.entities.bosses.slider.EntitySlider;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.world.dungeon.util.AetherDungeon;
import com.legacy.aether.world.dungeon.util.PositionData;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BronzeDungeon
extends AetherDungeon {
    private int numRooms = 4;
    private int n;
    private boolean finished = false;

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        this.replaceAir = true;
        this.replaceSolid = true;
        this.n = 0;
        if (!this.isBoxSolid(world, new PositionData(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), new PositionData(16, 12, 16)) || !this.isBoxSolid(world, new PositionData(pos.func_177958_n() + 20, pos.func_177956_o(), pos.func_177952_p() + 2), new PositionData(12, 12, 12))) {
            return false;
        }
        this.setBlocks(this.lockedBlock(), this.lockedLightBlock(), 20);
        this.addHollowBox(world, random, new PositionData(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), new PositionData(16, 12, 16));
        this.addHollowBox(world, random, new PositionData(pos.func_177958_n() + 6, pos.func_177956_o() - 2, pos.func_177952_p() + 6), new PositionData(4, 4, 4));
        EntitySlider slider = new EntitySlider(world);
        slider.func_70107_b(pos.func_177958_n() + 8, pos.func_177956_o() + 2, pos.func_177952_p() + 8);
        slider.setDungeon(slider.field_70165_t - 8.0, slider.field_70163_u - 2.0, slider.field_70161_v - 8.0);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)slider);
        }
        world.func_175656_a(pos.func_177982_a(7, -1, 7), BlocksAether.treasure_chest.func_176223_P());
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177956_o();
        x = pos.func_177958_n() + 20;
        y = pos.func_177956_o();
        z = pos.func_177952_p() + 2;
        if (!this.isBoxSolid(world, new PositionData(x, y, z), new PositionData(12, 12, 12))) {
            return true;
        }
        this.setBlocks(this.mainBlock(), this.mainLightBlock(), 20);
        this.addHollowBox(world, random, new PositionData(x, y, z), new PositionData(12, 12, 12));
        this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
        this.addSquareTube(world, random, new PositionData(x - 5, y, z + 3), new PositionData(6, 6, 6), 0);
        for (int p = x + 2; p < x + 10; p += 3) {
            for (int q = z + 2; q < z + 10; q += 3) {
                world.func_180501_a(new BlockPos(p, pos.func_177956_o(), q), BlocksAether.dungeon_trap.func_176223_P(), 2);
            }
        }
        ++this.n;
        this.generateNextRoom(world, random, new PositionData(x, y, z));
        this.generateNextRoom(world, random, new PositionData(x, y, z));
        if (this.n > this.numRooms || !this.finished) {
            this.endCorridor(world, random, new PositionData(x, y, z));
        }
        return true;
    }

    public boolean generateNextRoom(World world, Random random, PositionData pos) {
        int q;
        int p;
        if (this.n > this.numRooms && !this.finished) {
            this.endCorridor(world, random, pos);
            return false;
        }
        int dir = random.nextInt(4);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (dir == 0) {
            x += 16;
            z += 0;
        } else if (dir == 1) {
            x += 0;
            z += 16;
        } else if (dir == 2) {
            x -= 16;
            z += 0;
        } else if (dir == 3) {
            x += 0;
            z -= 16;
        }
        if (!this.isBoxSolid(world, new PositionData(x, y, z), new PositionData(12, 8, 12))) {
            return false;
        }
        this.setBlocks(this.mainBlock(), this.mainLightBlock(), 20);
        this.addHollowBox(world, random, new PositionData(x, y, z), new PositionData(12, 8, 12));
        for (p = x; p < x + 12; ++p) {
            for (q = y; q < y + 8; ++q) {
                for (int r = z; r < z + 12; ++r) {
                    if (world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(p, q, r)) != this.mainBlock() || random.nextInt(100) != 0) continue;
                    world.func_175656_a(new BlockPos(p, q, r), BlocksAether.dungeon_trap.func_176223_P());
                }
            }
        }
        for (p = x + 2; p < x + 10; p += 7) {
            for (q = z + 2; q < z + 10; q += 7) {
                world.func_175656_a(new BlockPos(p, pos.getY(), q), BlocksAether.dungeon_trap.func_176223_P());
            }
        }
        this.addPlaneY(world, random, new PositionData(x + 4, y + 1, z + 4), new PositionData(4, 0, 4));
        int type = random.nextInt(2);
        int p2 = x + 5 + random.nextInt(2);
        int q2 = z + 5 + random.nextInt(2);
        switch (type) {
            case 0: {
                world.func_175656_a(new BlockPos(p2, y + 2, q2), BlocksAether.chest_mimic.func_176223_P());
                break;
            }
            case 1: {
                if (world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(p2, y + 2, q2)).func_177230_c() != Blocks.field_150350_a) break;
                world.func_175656_a(new BlockPos(p2, y + 2, q2), Blocks.field_150486_ae.func_176223_P());
                TileEntityChest chest = (TileEntityChest)world.func_175625_s(new BlockPos(p2, y + 2, q2));
                for (p2 = 0; p2 < 3 + random.nextInt(3); ++p2) {
                    chest.func_70299_a(random.nextInt(chest.func_70302_i_()), this.getNormalLoot(random));
                }
                break;
            }
        }
        this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
        switch (dir) {
            case 0: {
                this.addSquareTube(world, random, new PositionData(x - 5, y, z + 3), new PositionData(6, 6, 6), 0);
                break;
            }
            case 1: {
                this.addSquareTube(world, random, new PositionData(x + 3, y, z - 5), new PositionData(6, 6, 6), 2);
                break;
            }
            case 2: {
                this.addSquareTube(world, random, new PositionData(x + 11, y, z + 3), new PositionData(6, 6, 6), 0);
                break;
            }
            case 3: {
                this.addSquareTube(world, random, new PositionData(x + 3, y, z + 11), new PositionData(6, 6, 6), 2);
            }
        }
        ++this.n;
        if (!this.generateNextRoom(world, random, new PositionData(x, y, z))) {
            return false;
        }
        return this.generateNextRoom(world, random, new PositionData(x, y, z));
    }

    public void endCorridor(World world, Random random, PositionData pos) {
        boolean flag;
        this.replaceAir = false;
        boolean tunnelling = true;
        int dir = random.nextInt(3);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (dir == 0) {
            x += 11;
            z += 3;
            while (tunnelling) {
                if (this.isBoxEmpty(world, new PositionData(x, y, z), new PositionData(1, 8, 6))) {
                    tunnelling = false;
                }
                flag = true;
                while (flag && (world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z)) == this.mainBlock() || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z)) == this.lockedBlock() || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z)) == this.lockedLightBlock() || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z)) == this.mainLightBlock())) {
                    if (world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x + 1, y, z)) == this.mainBlock() || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x + 1, y, z)) == this.lockedBlock() || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x + 1, y, z)) == this.lockedLightBlock() || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x + 1, y, z)) == this.mainLightBlock()) {
                        ++x;
                        continue;
                    }
                    flag = false;
                }
                this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                this.addPlaneX(world, random, new PositionData(x, y, z), new PositionData(0, 8, 6));
                this.setBlocks(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 1);
                this.addPlaneX(world, random, new PositionData(x, y + 1, z + 1), new PositionData(0, 6, 4));
                ++x;
            }
        }
        if (dir == 1) {
            x += 3;
            z += 11;
            while (tunnelling) {
                if (this.isBoxEmpty(world, new PositionData(x, y, z), new PositionData(6, 8, 1))) {
                    tunnelling = false;
                }
                flag = true;
                while (flag && (world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z)) == this.mainBlock() || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z)) == this.lockedBlock() || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z)) == this.lockedLightBlock() || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z)) == this.mainLightBlock())) {
                    if (world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z + 1)) == this.mainBlock() || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z + 1)) == this.lockedBlock() || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z + 1)) == this.lockedLightBlock() || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z + 1)) == this.mainLightBlock()) {
                        ++z;
                        continue;
                    }
                    flag = false;
                }
                this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                this.addPlaneZ(world, random, new PositionData(x, y, z), new PositionData(6, 8, 0));
                this.setBlocks(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 1);
                this.addPlaneZ(world, random, new PositionData(x + 1, y + 1, z), new PositionData(4, 6, 0));
                ++z;
            }
        }
        if (dir == 2) {
            x += 3;
            z += 0;
            while (tunnelling) {
                if (this.isBoxEmpty(world, new PositionData(x, y, z), new PositionData(6, 8, 1))) {
                    tunnelling = false;
                }
                flag = true;
                while (flag && (world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z)) == this.mainBlock() || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z)) == this.lockedBlock() || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z)) == this.lockedLightBlock() || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z)) == this.mainLightBlock())) {
                    if (world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z - 1)) == this.mainBlock() || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z - 1)) == this.lockedBlock() || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z - 1)) == this.lockedLightBlock() || world.func_180495_p((BlockPos)new BlockPos.MutableBlockPos().func_181079_c(x, y, z - 1)) == this.mainLightBlock()) {
                        --z;
                        continue;
                    }
                    flag = false;
                }
                this.setBlocks(this.fillerBlock(), this.fillerBlock1(), 5);
                this.addPlaneZ(world, random, new PositionData(x, y, z), new PositionData(6, 8, 0));
                this.setBlocks(Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 1);
                this.addPlaneZ(world, random, new PositionData(x + 1, y + 1, z), new PositionData(4, 6, 0));
                --z;
            }
        }
        this.finished = true;
    }

    private ItemStack getNormalLoot(Random random) {
        int item = random.nextInt(15);
        switch (item) {
            case 0: {
                return new ItemStack(ItemsAether.zanite_pickaxe);
            }
            case 1: {
                return new ItemStack(ItemsAether.zanite_axe);
            }
            case 2: {
                return new ItemStack(ItemsAether.zanite_sword);
            }
            case 3: {
                return new ItemStack(ItemsAether.zanite_shovel);
            }
            case 4: {
                return new ItemStack(ItemsAether.swet_cape);
            }
            case 5: {
                return new ItemStack(ItemsAether.ambrosium_shard, random.nextInt(10) + 1);
            }
            case 6: {
                return new ItemStack(ItemsAether.dart, random.nextInt(5) + 1, 0);
            }
            case 7: {
                return new ItemStack(ItemsAether.dart, random.nextInt(3) + 1, 1);
            }
            case 8: {
                return new ItemStack(ItemsAether.dart, random.nextInt(3) + 1, 2);
            }
            case 9: {
                if (random.nextInt(20) != 0) break;
                return new ItemStack(ItemsAether.aether_tune);
            }
            case 10: {
                return new ItemStack(ItemsAether.skyroot_bucket, 1, 2);
            }
            case 11: {
                if (random.nextInt(10) != 0) break;
                return new ItemStack(Items.field_151093_ce);
            }
            case 12: {
                if (random.nextInt(4) != 0) break;
                return new ItemStack(ItemsAether.iron_ring);
            }
            case 13: {
                if (random.nextInt(10) != 0) break;
                return new ItemStack(ItemsAether.golden_ring);
            }
        }
        return new ItemStack(BlocksAether.ambrosium_torch);
    }

    public static ItemStack getBronzeLoot(Random random) {
        int item = random.nextInt(9);
        switch (item) {
            case 0: {
                return new ItemStack(ItemsAether.gummy_swet, random.nextInt(7) + 1, random.nextInt(2));
            }
            case 1: {
                return new ItemStack(ItemsAether.phoenix_bow);
            }
            case 2: {
                return new ItemStack(ItemsAether.flaming_sword);
            }
            case 3: {
                return new ItemStack(ItemsAether.notch_hammer);
            }
            case 4: {
                return new ItemStack(ItemsAether.lightning_knife, random.nextInt(15) + 1);
            }
            case 5: {
                return new ItemStack(ItemsAether.valkyrie_lance);
            }
            case 6: {
                return new ItemStack(ItemsAether.agility_cape);
            }
            case 7: {
                return new ItemStack(ItemsAether.sentry_boots);
            }
        }
        return new ItemStack(ItemsAether.cloud_staff);
    }

    public IBlockState lockedLightBlock() {
        return BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Sentry));
    }

    public IBlockState lockedBlock() {
        return BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Carved));
    }

    public IBlockState mainLightBlock() {
        return BlocksAether.dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Sentry));
    }

    public IBlockState mainBlock() {
        return BlocksAether.dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Carved));
    }

    public IBlockState fillerBlock() {
        return BlocksAether.holystone.func_176223_P();
    }

    public IBlockState fillerBlock1() {
        return BlocksAether.mossy_holystone.func_176223_P();
    }
}

