/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.world;

import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.world.biome.decoration.AetherGenGoldenIsland;
import com.legacy.aether.world.dungeon.BronzeDungeon;
import com.legacy.aether.world.dungeon.SilverDungeon;
import com.legacy.aether.world.dungeon.util.AetherDungeon;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenerator;

public class ChunkProviderAether
implements IChunkGenerator {
    private Random rand;
    private World worldObj;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves perlinNoise1;
    private double[] buffer;
    double[] pnr;
    double[] ar;
    double[] br;
    public static int gumCount;
    protected WorldGenerator golden_island = new AetherGenGoldenIsland();
    protected AetherDungeon dungeon_bronze = new BronzeDungeon();
    protected AetherDungeon dungeon_silver = new SilverDungeon();

    public ChunkProviderAether(World world, long seed) {
        this.worldObj = world;
        this.rand = new Random(seed);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.perlinNoise1 = new NoiseGeneratorOctaves(this.rand, 8);
    }

    public void setBlocksInChunk(int x, int z, ChunkPrimer chunkPrimer) {
        this.buffer = this.setupNoiseGenerators(this.buffer, x * 2, z * 2);
        for (int i1 = 0; i1 < 2; ++i1) {
            for (int j1 = 0; j1 < 2; ++j1) {
                for (int k1 = 0; k1 < 32; ++k1) {
                    double d1 = this.buffer[(i1 * 3 + j1) * 33 + k1];
                    double d2 = this.buffer[(i1 * 3 + (j1 + 1)) * 33 + k1];
                    double d3 = this.buffer[((i1 + 1) * 3 + j1) * 33 + k1];
                    double d4 = this.buffer[((i1 + 1) * 3 + (j1 + 1)) * 33 + k1];
                    double d5 = (this.buffer[(i1 * 3 + j1) * 33 + (k1 + 1)] - d1) * 0.25;
                    double d6 = (this.buffer[(i1 * 3 + (j1 + 1)) * 33 + (k1 + 1)] - d2) * 0.25;
                    double d7 = (this.buffer[((i1 + 1) * 3 + j1) * 33 + (k1 + 1)] - d3) * 0.25;
                    double d8 = (this.buffer[((i1 + 1) * 3 + (j1 + 1)) * 33 + (k1 + 1)] - d4) * 0.25;
                    for (int l1 = 0; l1 < 4; ++l1) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.125;
                        double d13 = (d4 - d2) * 0.125;
                        for (int i2 = 0; i2 < 8; ++i2) {
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.125;
                            for (int k2 = 0; k2 < 8; ++k2) {
                                int x1 = i2 + i1 * 8;
                                int y = l1 + k1 * 4;
                                int z1 = k2 + j1 * 8;
                                IBlockState filler = Blocks.field_150350_a.func_176223_P();
                                if (d15 > 0.0) {
                                    filler = BlocksAether.holystone.func_176223_P();
                                }
                                chunkPrimer.func_177855_a(x1, y, z1, filler);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void buildSurfaces(int i, int j, ChunkPrimer chunkPrimer) {
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                int j1 = -1;
                int i1 = (int)(3.0 + this.rand.nextDouble() * 0.25);
                IBlockState top = BlocksAether.aether_grass.func_176223_P();
                IBlockState filler = BlocksAether.aether_dirt.func_176223_P();
                for (int k1 = 127; k1 >= 0; --k1) {
                    Block block = chunkPrimer.func_177856_a(k, k1, l).func_177230_c();
                    if (block == Blocks.field_150350_a) {
                        j1 = -1;
                        continue;
                    }
                    if (block != BlocksAether.holystone) continue;
                    if (j1 == -1) {
                        if (i1 <= 0) {
                            top = Blocks.field_150350_a.func_176223_P();
                            filler = BlocksAether.holystone.func_176223_P();
                        }
                        j1 = i1;
                        if (k1 >= 0) {
                            chunkPrimer.func_177855_a(k, k1, l, top);
                            continue;
                        }
                        chunkPrimer.func_177855_a(k, k1, l, filler);
                        continue;
                    }
                    if (j1 <= 0) continue;
                    --j1;
                    chunkPrimer.func_177855_a(k, k1, l, filler);
                }
            }
        }
    }

    private double[] setupNoiseGenerators(double[] buffer, int x, int z) {
        if (buffer == null) {
            buffer = new double[3366];
        }
        double d = 1368.824;
        double d1 = 684.412;
        this.pnr = this.perlinNoise1.func_76304_a(this.pnr, x, 0, z, 3, 33, 3, d / 80.0, d1 / 160.0, d / 80.0);
        this.ar = this.noiseGen1.func_76304_a(this.ar, x, 0, z, 3, 33, 3, d, d1, d);
        this.br = this.noiseGen1.func_76304_a(this.br, x, 0, z, 3, 33, 3, d, d1, d);
        int id = 0;
        for (int j2 = 0; j2 < 3; ++j2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                for (int j3 = 0; j3 < 33; ++j3) {
                    double d10 = this.ar[id] / 512.0;
                    double d11 = this.br[id] / 512.0;
                    double d12 = (this.pnr[id] / 10.0 + 1.0) / 2.0;
                    double d8 = d12 < 0.0 ? d10 : (d12 > 1.0 ? d11 : d10 + (d11 - d10) * d12);
                    d8 -= 8.0;
                    if (j3 > 1) {
                        double d13 = (float)(j3 - 1) / 31.0f;
                        d8 = d8 * (1.0 - d13) + -30.0 * d13;
                    }
                    if (j3 < 8) {
                        double d14 = (float)(8 - j3) / 7.0f;
                        d8 = d8 * (1.0 - d14) + -30.0 * d14;
                    }
                    buffer[id] = d8;
                    ++id;
                }
            }
        }
        return buffer;
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, chunkPrimer);
        this.buildSurfaces(x, z, chunkPrimer);
        Chunk chunk = new Chunk(this.worldObj, chunkPrimer, x, z);
        chunk.func_76603_b();
        return chunk;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.worldObj.func_72959_q().func_180631_a(pos);
        return biome != null ? biome.func_76747_a(creatureType) : null;
    }

    public boolean func_185933_a(Chunk chunkIn, int chunkX, int chunkZ) {
        return false;
    }

    public void func_180514_a(Chunk p_180514_1_, int p_180514_2_, int p_180514_3_) {
    }

    public BlockPos func_180513_a(World worldIn, String p_180513_2_, BlockPos p_180513_3_) {
        return null;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BlockPos pos = new BlockPos(x, 0, z);
        Biome biome = this.worldObj.func_180494_b(pos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.worldObj.func_72905_C());
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        long l2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * l1 + (long)chunkZ * l2 ^ this.worldObj.func_72905_C());
        biome.func_180624_a(this.worldObj, this.rand, pos);
        if (gumCount < 800) {
            ++gumCount;
        } else if (this.rand.nextInt(100) == 0) {
            boolean resetCounter = false;
            resetCounter = this.golden_island.func_180709_b(this.worldObj, this.rand, pos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(64) + 32, this.rand.nextInt(16) + 8));
            if (resetCounter) {
                gumCount = 0;
            }
        }
        if (this.rand.nextInt(3) == 0) {
            this.dungeon_bronze.func_180709_b(this.worldObj, this.rand, pos.func_177982_a(this.rand.nextInt(16), this.rand.nextInt(64) + 32, this.rand.nextInt(16)));
        }
        if (this.rand.nextInt(500) == 0) {
            BlockPos newPos = pos.func_177982_a(this.rand.nextInt(16), this.rand.nextInt(32) + 64, this.rand.nextInt(16));
            this.dungeon_silver.func_180709_b(this.worldObj, this.rand, newPos);
        }
        WorldEntitySpawner.func_77191_a((World)this.worldObj, (Biome)biome, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.rand);
    }
}

