/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.tile_entities;

import com.legacy.aether.api.AetherAPI;
import com.legacy.aether.api.events.AetherHooks;
import com.legacy.aether.api.freezables.AetherFreezable;
import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.blocks.container.BlockAetherContainer;
import com.legacy.aether.tile_entities.util.AetherTileEntity;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFreezer
extends AetherTileEntity {
    public int progress;
    public int ticksRequired;
    public int powerRemaining;
    private ItemStack[] frozenItemStacks = new ItemStack[3];
    private AetherFreezable currentFreezable;

    public TileEntityFreezer() {
        super("freezer");
    }

    @Override
    public ItemStack[] getTileInventory() {
        return this.frozenItemStacks;
    }

    @Override
    public void onSlotChanged(int index) {
    }

    public void func_73660_a() {
        boolean flag = this.isFreezing();
        if (this.powerRemaining > 0) {
            --this.powerRemaining;
            if (this.currentFreezable != null) {
                this.progress = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()).func_177230_c() == BlocksAether.icestone ? (this.progress += 2) : ++this.progress;
            }
        }
        if (this.currentFreezable != null) {
            if (this.func_70301_a(0) == null || this.func_70301_a(0) != null && AetherAPI.getInstance().getFreezable(this.func_70301_a(0)) != this.currentFreezable) {
                this.currentFreezable = null;
                this.progress = 0;
                return;
            }
            if (this.progress >= this.currentFreezable.getTimeRequired()) {
                if (!this.field_145850_b.field_72995_K) {
                    ItemStack result = this.currentFreezable.getOutput().func_77946_l();
                    EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)this.func_70301_a(0)), (ItemStack)result);
                    if (this.func_70301_a(2) != null) {
                        result.field_77994_a = this.func_70301_a((int)2).field_77994_a + 1;
                        this.func_70299_a(2, result);
                    } else {
                        this.func_70299_a(2, result);
                    }
                    if (this.func_70301_a(0).func_77973_b().func_77668_q() != null) {
                        this.func_70299_a(0, new ItemStack(this.func_70301_a(0).func_77973_b().func_77668_q()));
                    } else {
                        this.func_70298_a(0, 1);
                    }
                }
                this.progress = 0;
                AetherHooks.onItemFreeze(this, this.currentFreezable);
            }
            if (this.powerRemaining <= 0 && this.func_70301_a(1) != null && AetherAPI.getInstance().isFreezableFuel(this.func_70301_a(1))) {
                this.powerRemaining += AetherAPI.getInstance().getFreezableFuel(this.func_70301_a(1)).getTimeGiven();
                if (!this.field_145850_b.field_72995_K) {
                    this.func_70298_a(1, 1);
                }
            }
        } else if (this.func_70301_a(0) != null) {
            ItemStack itemstack = this.func_70301_a(0);
            AetherFreezable freezable = AetherAPI.getInstance().getFreezable(itemstack);
            if (freezable != null && (this.func_70301_a(2) == null || freezable.getOutput().func_77973_b() == this.func_70301_a(2).func_77973_b() && freezable.getOutput().func_77960_j() == this.func_70301_a(2).func_77960_j())) {
                this.currentFreezable = freezable;
                this.ticksRequired = this.currentFreezable.getTimeRequired();
                this.addEnchantmentWeight(itemstack);
                this.ticksRequired = AetherHooks.onSetFreezableTime(this, this.currentFreezable, this.ticksRequired);
            }
        }
        if (flag != this.isFreezing()) {
            this.func_70296_d();
            BlockAetherContainer.setState(this.field_145850_b, this.field_174879_c, this.isFreezing());
        }
    }

    public void addEnchantmentWeight(ItemStack stack) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (!enchantments.isEmpty()) {
            Iterator iterator = enchantments.values().iterator();
            while (iterator.hasNext()) {
                int levels = (Integer)iterator.next();
                this.ticksRequired += levels * 1250;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnchantmentProgressScaled(int i) {
        if (this.ticksRequired == 0) {
            return 0;
        }
        return this.progress * i / this.ticksRequired;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnchantmentTimeRemaining(int i) {
        return this.powerRemaining * i / 500;
    }

    public boolean isFreezing() {
        return this.powerRemaining > 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74762_e("FreezerProgressTime");
        this.ticksRequired = nbttagcompound.func_74762_e("FreezerTimeRequired");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("FreezerProgressTime", this.progress);
        nbttagcompound.func_74768_a("FreezerTimeRequired", this.ticksRequired);
        return super.func_189515_b(nbttagcompound);
    }

    @Override
    public boolean isValidSlotItem(int slot, ItemStack stackInSlot) {
        if (stackInSlot != null) {
            if (AetherAPI.getInstance().hasFreezable(stackInSlot)) {
                return true;
            }
            if (slot == 1 && AetherAPI.getInstance().isFreezableFuel(stackInSlot)) {
                return true;
            }
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 2;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = 1;
        }
        return nArray;
    }

    @Override
    public int func_174887_a_(int id) {
        if (id == 0) {
            return this.progress;
        }
        if (id == 1) {
            return this.powerRemaining;
        }
        if (id == 2) {
            return this.ticksRequired;
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id == 0) {
            this.progress = value;
        } else if (id == 1) {
            this.powerRemaining = value;
        } else if (id == 2) {
            this.ticksRequired = value;
        }
    }

    @Override
    public int func_174890_g() {
        return 3;
    }
}

