/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.registry;

import com.legacy.aether.api.AetherAPI;
import com.legacy.aether.api.accessories.AccessoryType;
import com.legacy.aether.api.accessories.AetherAccessory;
import com.legacy.aether.api.enchantments.AetherEnchantment;
import com.legacy.aether.api.enchantments.AetherEnchantmentFuel;
import com.legacy.aether.api.freezables.AetherFreezable;
import com.legacy.aether.api.freezables.AetherFreezableFuel;
import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.items.ItemsAether;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class AetherRegistries {
    public static void initialization() {
        AetherRegistries.initializeRecipes();
        AetherRegistries.initializeFreezables();
        AetherRegistries.initializeAccessories();
        AetherRegistries.initializeEnchantments();
        AetherRegistries.initializeShapelessRecipes();
        FurnaceRecipes.func_77602_a().func_151393_a(BlocksAether.aether_log, new ItemStack(Items.field_151044_h, 1, 1), 0.15f);
    }

    public static void initializeAccessories() {
        AetherAPI registry = AetherAPI.getInstance();
        registry.register(new AetherAccessory(ItemsAether.leather_gloves, AccessoryType.GLOVE));
        registry.register(new AetherAccessory(ItemsAether.iron_gloves, AccessoryType.GLOVE));
        registry.register(new AetherAccessory(ItemsAether.golden_gloves, AccessoryType.GLOVE));
        registry.register(new AetherAccessory(ItemsAether.chain_gloves, AccessoryType.GLOVE));
        registry.register(new AetherAccessory(ItemsAether.diamond_gloves, AccessoryType.GLOVE));
        registry.register(new AetherAccessory(ItemsAether.zanite_gloves, AccessoryType.GLOVE));
        registry.register(new AetherAccessory(ItemsAether.gravitite_gloves, AccessoryType.GLOVE));
        registry.register(new AetherAccessory(ItemsAether.neptune_gloves, AccessoryType.GLOVE));
        registry.register(new AetherAccessory(ItemsAether.phoenix_gloves, AccessoryType.GLOVE));
        registry.register(new AetherAccessory(ItemsAether.obsidian_gloves, AccessoryType.GLOVE));
        registry.register(new AetherAccessory(ItemsAether.valkyrie_gloves, AccessoryType.GLOVE));
        registry.register(new AetherAccessory(ItemsAether.iron_ring, AccessoryType.RING));
        registry.register(new AetherAccessory(ItemsAether.golden_ring, AccessoryType.RING));
        registry.register(new AetherAccessory(ItemsAether.zanite_ring, AccessoryType.RING));
        registry.register(new AetherAccessory(ItemsAether.ice_ring, AccessoryType.RING));
        registry.register(new AetherAccessory(ItemsAether.iron_pendant, AccessoryType.PENDANT));
        registry.register(new AetherAccessory(ItemsAether.golden_pendant, AccessoryType.PENDANT));
        registry.register(new AetherAccessory(ItemsAether.zanite_pendant, AccessoryType.PENDANT));
        registry.register(new AetherAccessory(ItemsAether.ice_pendant, AccessoryType.PENDANT));
        registry.register(new AetherAccessory(ItemsAether.red_cape, AccessoryType.CAPE));
        registry.register(new AetherAccessory(ItemsAether.blue_cape, AccessoryType.CAPE));
        registry.register(new AetherAccessory(ItemsAether.yellow_cape, AccessoryType.CAPE));
        registry.register(new AetherAccessory(ItemsAether.white_cape, AccessoryType.CAPE));
        registry.register(new AetherAccessory(ItemsAether.swet_cape, AccessoryType.CAPE));
        registry.register(new AetherAccessory(ItemsAether.invisibility_cape, AccessoryType.CAPE));
        registry.register(new AetherAccessory(ItemsAether.agility_cape, AccessoryType.CAPE));
        registry.register(new AetherAccessory(ItemsAether.golden_feather, AccessoryType.MISC));
        registry.register(new AetherAccessory(ItemsAether.regeneration_stone, AccessoryType.MISC));
        registry.register(new AetherAccessory(ItemsAether.iron_bubble, AccessoryType.MISC));
        registry.register(new AetherAccessory(ItemsAether.repulsion_shield, AccessoryType.SHIELD));
    }

    public static void initializeEnchantments() {
        AetherAPI registry = AetherAPI.getInstance();
        registry.register(new AetherEnchantment(ItemsAether.skyroot_pickaxe, 225));
        registry.register(new AetherEnchantment(ItemsAether.skyroot_axe, 225));
        registry.register(new AetherEnchantment(ItemsAether.skyroot_shovel, 225));
        registry.register(new AetherEnchantment(ItemsAether.skyroot_sword, 225));
        registry.register(new AetherEnchantment(ItemsAether.holystone_pickaxe, 550));
        registry.register(new AetherEnchantment(ItemsAether.holystone_axe, 550));
        registry.register(new AetherEnchantment(ItemsAether.holystone_shovel, 550));
        registry.register(new AetherEnchantment(ItemsAether.holystone_sword, 550));
        registry.register(new AetherEnchantment(ItemsAether.zanite_pickaxe, 2250));
        registry.register(new AetherEnchantment(ItemsAether.zanite_axe, 2250));
        registry.register(new AetherEnchantment(ItemsAether.zanite_shovel, 2250));
        registry.register(new AetherEnchantment(ItemsAether.zanite_sword, 2250));
        registry.register(new AetherEnchantment(ItemsAether.gravitite_pickaxe, 5500));
        registry.register(new AetherEnchantment(ItemsAether.gravitite_axe, 5500));
        registry.register(new AetherEnchantment(ItemsAether.gravitite_shovel, 5500));
        registry.register(new AetherEnchantment(ItemsAether.gravitite_sword, 5500));
        registry.register(new AetherEnchantment(ItemsAether.zanite_helmet, 6000));
        registry.register(new AetherEnchantment(ItemsAether.zanite_chestplate, 6000));
        registry.register(new AetherEnchantment(ItemsAether.zanite_leggings, 6000));
        registry.register(new AetherEnchantment(ItemsAether.zanite_boots, 6000));
        registry.register(new AetherEnchantment(ItemsAether.gravitite_helmet, 13000));
        registry.register(new AetherEnchantment(ItemsAether.gravitite_chestplate, 13000));
        registry.register(new AetherEnchantment(ItemsAether.gravitite_leggings, 13000));
        registry.register(new AetherEnchantment(ItemsAether.gravitite_boots, 13000));
        registry.register(new AetherEnchantment(ItemsAether.dart, new ItemStack(ItemsAether.dart, 1, 2), 250));
        registry.register(new AetherEnchantment(ItemsAether.dart_shooter, new ItemStack(ItemsAether.dart_shooter, 1, 2), 500));
        registry.register(new AetherEnchantment(new ItemStack(ItemsAether.skyroot_bucket, 1, 2), new ItemStack(ItemsAether.skyroot_bucket, 1, 3), 1000));
        registry.register(new AetherEnchantment(BlocksAether.holystone, ItemsAether.healing_stone, 750));
        registry.register(new AetherEnchantment(BlocksAether.gravitite_ore, BlocksAether.enchanted_gravitite, 1000));
        registry.register(new AetherEnchantment(BlocksAether.quicksoil, BlocksAether.quicksoil_glass, 250));
        registry.register(new AetherEnchantment(ItemsAether.blue_berry, ItemsAether.enchanted_blueberry, 300));
        registry.register(new AetherEnchantment((Item)Items.field_151031_f, 4000));
        registry.register(new AetherEnchantment((Item)Items.field_151112_aM, 600));
        registry.register(new AetherEnchantment(Items.field_151086_cn, ItemsAether.aether_tune, 2500));
        registry.register(new AetherEnchantment(Items.field_151096_cd, ItemsAether.aether_tune, 2500));
        registry.register(new AetherEnchantment(Items.field_151094_cf, ItemsAether.aether_tune, 2500));
        registry.register(new AetherEnchantment(Items.field_151093_ce, ItemsAether.aether_tune, 2500));
        registry.register(new AetherEnchantment(Items.field_151092_ch, ItemsAether.aether_tune, 2500));
        registry.register(new AetherEnchantment(Items.field_151089_ci, ItemsAether.aether_tune, 2500));
        registry.register(new AetherEnchantment(Items.field_151090_cj, ItemsAether.aether_tune, 2500));
        registry.register(new AetherEnchantment(Items.field_151087_ck, ItemsAether.aether_tune, 2500));
        registry.register(new AetherEnchantment(Items.field_151088_cl, ItemsAether.aether_tune, 2500));
        registry.register(new AetherEnchantment(Items.field_151084_co, ItemsAether.aether_tune, 2500));
        registry.register(new AetherEnchantment(Items.field_151085_cm, ItemsAether.aether_tune, 2500));
        registry.register(new AetherEnchantment(Items.field_151039_o, 225));
        registry.register(new AetherEnchantment(Items.field_151053_p, 225));
        registry.register(new AetherEnchantment(Items.field_151038_n, 225));
        registry.register(new AetherEnchantment(Items.field_151017_I, 225));
        registry.register(new AetherEnchantment(Items.field_151050_s, 550));
        registry.register(new AetherEnchantment(Items.field_151049_t, 550));
        registry.register(new AetherEnchantment(Items.field_151051_r, 550));
        registry.register(new AetherEnchantment(Items.field_151018_J, 550));
        registry.register(new AetherEnchantment(Items.field_151035_b, 2250));
        registry.register(new AetherEnchantment(Items.field_151036_c, 2250));
        registry.register(new AetherEnchantment(Items.field_151037_a, 2250));
        registry.register(new AetherEnchantment(Items.field_151019_K, 2250));
        registry.register(new AetherEnchantment(Items.field_151046_w, 5500));
        registry.register(new AetherEnchantment(Items.field_151056_x, 5500));
        registry.register(new AetherEnchantment(Items.field_151047_v, 5500));
        registry.register(new AetherEnchantment(Items.field_151012_L, 5500));
        registry.register(new AetherEnchantment((Item)Items.field_151024_Q, 550));
        registry.register(new AetherEnchantment((Item)Items.field_151027_R, 550));
        registry.register(new AetherEnchantment((Item)Items.field_151026_S, 550));
        registry.register(new AetherEnchantment((Item)Items.field_151021_T, 550));
        registry.register(new AetherEnchantment((Item)Items.field_151028_Y, 6000));
        registry.register(new AetherEnchantment((Item)Items.field_151030_Z, 6000));
        registry.register(new AetherEnchantment((Item)Items.field_151165_aa, 6000));
        registry.register(new AetherEnchantment((Item)Items.field_151167_ab, 6000));
        registry.register(new AetherEnchantment((Item)Items.field_151169_ag, 2250));
        registry.register(new AetherEnchantment((Item)Items.field_151171_ah, 2250));
        registry.register(new AetherEnchantment((Item)Items.field_151149_ai, 2250));
        registry.register(new AetherEnchantment((Item)Items.field_151151_aj, 2250));
        registry.register(new AetherEnchantment((Item)Items.field_151020_U, 2250));
        registry.register(new AetherEnchantment((Item)Items.field_151023_V, 2250));
        registry.register(new AetherEnchantment((Item)Items.field_151022_W, 2250));
        registry.register(new AetherEnchantment((Item)Items.field_151029_X, 2250));
        registry.register(new AetherEnchantment((Item)Items.field_151161_ac, 10000));
        registry.register(new AetherEnchantment((Item)Items.field_151163_ad, 10000));
        registry.register(new AetherEnchantment((Item)Items.field_151173_ae, 10000));
        registry.register(new AetherEnchantment((Item)Items.field_151175_af, 10000));
        registry.register(new AetherEnchantmentFuel(ItemsAether.ambrosium_shard, 500));
    }

    public static void initializeFreezables() {
        AetherAPI registry = AetherAPI.getInstance();
        registry.register(new AetherFreezable(BlocksAether.aercloud, new ItemStack(BlocksAether.aercloud, 1, 1), 100));
        registry.register(new AetherFreezable(BlocksAether.aether_leaves, BlocksAether.crystal_leaves, 150));
        registry.register(new AetherFreezable(new ItemStack(ItemsAether.skyroot_bucket, 1, 1), Blocks.field_150432_aD, 500));
        registry.register(new AetherFreezable(ItemsAether.ascending_dawn, ItemsAether.welcoming_skies, 800));
        registry.register(new AetherFreezable(Blocks.field_150432_aD, Blocks.field_150403_cj, 750));
        registry.register(new AetherFreezable(Items.field_151131_as, Blocks.field_150432_aD, 500));
        registry.register(new AetherFreezable(Items.field_151129_at, Blocks.field_150343_Z, 500));
        registry.register(new AetherFreezable(ItemsAether.iron_ring, ItemsAether.ice_ring, 2500));
        registry.register(new AetherFreezable(ItemsAether.golden_ring, ItemsAether.ice_ring, 2500));
        registry.register(new AetherFreezable(ItemsAether.iron_pendant, ItemsAether.ice_pendant, 2500));
        registry.register(new AetherFreezable(ItemsAether.golden_pendant, ItemsAether.ice_pendant, 2500));
        registry.register(new AetherFreezableFuel(BlocksAether.icestone, 500));
    }

    public static void initializeShapelessRecipes() {
        AetherRegistries.registerShapeless(new ItemStack(ItemsAether.blue_cape), ItemsAether.white_cape, new ItemStack(Items.field_151100_aR, 1, 4));
        AetherRegistries.registerShapeless(new ItemStack(ItemsAether.red_cape), ItemsAether.white_cape, new ItemStack(Items.field_151100_aR, 1, 1));
        AetherRegistries.registerShapeless(new ItemStack(ItemsAether.yellow_cape), ItemsAether.white_cape, new ItemStack(Items.field_151100_aR, 1, 11));
        AetherRegistries.registerShapeless(new ItemStack(ItemsAether.dart_shooter, 1, 1), new ItemStack(ItemsAether.dart_shooter, 1, 0), new ItemStack(ItemsAether.skyroot_bucket, 1, 2));
        AetherRegistries.registerShapeless(new ItemStack(Items.field_151100_aR, 2, 5), BlocksAether.purple_flower);
        AetherRegistries.registerShapeless(new ItemStack(BlocksAether.skyroot_plank, 4), new ItemStack(BlocksAether.aether_log));
    }

    public static void initializeRecipes() {
        AetherRegistries.register(new ItemStack(BlocksAether.skyroot_plank, 4), "X", Character.valueOf('X'), BlocksAether.aether_log);
        AetherRegistries.register(new ItemStack(ItemsAether.nature_staff), "Y", "X", Character.valueOf('Y'), ItemsAether.zanite_gemstone, Character.valueOf('X'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(ItemsAether.skyroot_stick, 4), "X", "X", Character.valueOf('X'), BlocksAether.skyroot_plank);
        AetherRegistries.register(new ItemStack(Blocks.field_150415_aT, 2), "XXX", "XXX", Character.valueOf('X'), BlocksAether.skyroot_plank);
        AetherRegistries.register(new ItemStack(BlocksAether.holystone_brick, 4), "XX", "XX", Character.valueOf('X'), BlocksAether.holystone);
        AetherRegistries.register(new ItemStack(BlocksAether.zanite_block), "XXX", "XXX", "XXX", Character.valueOf('X'), ItemsAether.zanite_gemstone);
        AetherRegistries.register(new ItemStack(ItemsAether.zanite_gemstone, 9), "X", Character.valueOf('X'), BlocksAether.zanite_block);
        AetherRegistries.register(new ItemStack(ItemsAether.dart_shooter, 1), "X  ", " Y ", "  Y", Character.valueOf('X'), ItemsAether.golden_amber, Character.valueOf('Y'), BlocksAether.skyroot_plank);
        AetherRegistries.register(new ItemStack(ItemsAether.dart, 1), "X", "Y", "Z", Character.valueOf('X'), Items.field_151008_G, Character.valueOf('Y'), ItemsAether.skyroot_stick, Character.valueOf('Z'), ItemsAether.golden_amber);
        AetherRegistries.register(new ItemStack(ItemsAether.dart_shooter, 1, 1), "X", "Y", Character.valueOf('X'), new ItemStack(ItemsAether.dart_shooter, 1), Character.valueOf('Y'), new ItemStack(ItemsAether.skyroot_bucket, 1, 2));
        AetherRegistries.register(new ItemStack(ItemsAether.dart, 8, 1), "XXX", "XYX", "XXX", Character.valueOf('X'), new ItemStack(ItemsAether.dart, 1), Character.valueOf('Y'), new ItemStack(ItemsAether.skyroot_bucket, 1, 2));
        AetherRegistries.register(new ItemStack(BlocksAether.incubator), "XXX", "XZX", "XXX", Character.valueOf('X'), BlocksAether.holystone, Character.valueOf('Z'), BlocksAether.ambrosium_torch);
        AetherRegistries.register(new ItemStack(BlocksAether.freezer), "XXX", "XYX", "ZZZ", Character.valueOf('X'), BlocksAether.holystone, Character.valueOf('Y'), BlocksAether.icestone, Character.valueOf('Z'), BlocksAether.skyroot_plank);
        AetherRegistries.register(new ItemStack(BlocksAether.enchanter), "XXX", "XYX", "XXX", Character.valueOf('X'), BlocksAether.holystone, Character.valueOf('Y'), ItemsAether.zanite_gemstone);
        AetherRegistries.register(new ItemStack(Blocks.field_150468_ap, 4), "X X", "XXX", "X X", Character.valueOf('X'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(Blocks.field_150421_aI), "XXX", "XYX", "XXX", Character.valueOf('X'), BlocksAether.skyroot_plank, Character.valueOf('Y'), BlocksAether.enchanted_gravitite);
        AetherRegistries.register(new ItemStack(Items.field_179570_aq, 3), "XX", "XX", "XX", Character.valueOf('X'), BlocksAether.skyroot_plank);
        AetherRegistries.register(new ItemStack(BlocksAether.ambrosium_torch, 2), "Z", "Y", Character.valueOf('Z'), ItemsAether.ambrosium_shard, Character.valueOf('Y'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(Items.field_151155_ap, 3), "XXX", "XXX", " Y ", Character.valueOf('X'), BlocksAether.skyroot_plank, Character.valueOf('Y'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(Items.field_151058_ca, 2), "YY ", "YX ", "  Y", Character.valueOf('Y'), Items.field_151007_F, Character.valueOf('X'), ItemsAether.swetty_ball);
        AetherRegistries.register(new ItemStack(ItemsAether.zanite_pendant), "XXX", "X X", " Y ", Character.valueOf('Y'), ItemsAether.zanite_gemstone, Character.valueOf('X'), Items.field_151007_F);
        AetherRegistries.register(new ItemStack(ItemsAether.iron_pendant), "XXX", "X X", " Y ", Character.valueOf('Y'), Items.field_151042_j, Character.valueOf('X'), Items.field_151007_F);
        AetherRegistries.register(new ItemStack(ItemsAether.golden_pendant), "XXX", "X X", " Y ", Character.valueOf('Y'), Items.field_151043_k, Character.valueOf('X'), Items.field_151007_F);
        AetherRegistries.register(new ItemStack(ItemsAether.zanite_ring), " X ", "X X", " X ", Character.valueOf('X'), ItemsAether.zanite_gemstone);
        AetherRegistries.register(new ItemStack(ItemsAether.iron_ring), " X ", "X X", " X ", Character.valueOf('X'), Items.field_151042_j);
        AetherRegistries.register(new ItemStack(ItemsAether.golden_ring), " X ", "X X", " X ", Character.valueOf('X'), Items.field_151043_k);
        AetherRegistries.register(new ItemStack(ItemsAether.cloud_parachute, 1), "XX", "XX", Character.valueOf('X'), new ItemStack(BlocksAether.aercloud, 1));
        AetherRegistries.register(new ItemStack(ItemsAether.golden_parachute, 1), "XX", "XX", Character.valueOf('X'), new ItemStack(BlocksAether.aercloud, 1, 2));
        AetherRegistries.register(new ItemStack(Items.field_151141_av, 1), "XXX", "XZX", Character.valueOf('X'), Items.field_151116_aA, Character.valueOf('Z'), Items.field_151007_F);
        AetherRegistries.register(new ItemStack((Block)Blocks.field_150486_ae, 1), "XXX", "X X", "XXX", Character.valueOf('X'), BlocksAether.skyroot_plank);
        AetherRegistries.register(new ItemStack(ItemsAether.skyroot_bucket, 1, 0), "Z Z", " Z ", Character.valueOf('Z'), BlocksAether.skyroot_plank);
        AetherRegistries.register(new ItemStack(Blocks.field_150462_ai, 1), "XX", "XX", Character.valueOf('X'), BlocksAether.skyroot_plank);
        AetherRegistries.register(new ItemStack(ItemsAether.gravitite_helmet, 1), "XXX", "X X", Character.valueOf('X'), BlocksAether.enchanted_gravitite);
        AetherRegistries.register(new ItemStack(ItemsAether.gravitite_chestplate, 1), "X X", "XXX", "XXX", Character.valueOf('X'), BlocksAether.enchanted_gravitite);
        AetherRegistries.register(new ItemStack(ItemsAether.gravitite_leggings, 1), "XXX", "X X", "X X", Character.valueOf('X'), BlocksAether.enchanted_gravitite);
        AetherRegistries.register(new ItemStack(ItemsAether.gravitite_boots, 1), "X X", "X X", Character.valueOf('X'), BlocksAether.enchanted_gravitite);
        AetherRegistries.register(new ItemStack(ItemsAether.zanite_helmet, 1), "XXX", "X X", Character.valueOf('X'), ItemsAether.zanite_gemstone);
        AetherRegistries.register(new ItemStack(ItemsAether.zanite_chestplate, 1), "X X", "XXX", "XXX", Character.valueOf('X'), ItemsAether.zanite_gemstone);
        AetherRegistries.register(new ItemStack(ItemsAether.zanite_leggings, 1), "XXX", "X X", "X X", Character.valueOf('X'), ItemsAether.zanite_gemstone);
        AetherRegistries.register(new ItemStack(ItemsAether.zanite_boots, 1), "X X", "X X", Character.valueOf('X'), ItemsAether.zanite_gemstone);
        AetherRegistries.register(new ItemStack(ItemsAether.skyroot_pickaxe, 1), "ZZZ", " Y ", " Y ", Character.valueOf('Z'), BlocksAether.skyroot_plank, Character.valueOf('Y'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(ItemsAether.holystone_pickaxe, 1), "ZZZ", " Y ", " Y ", Character.valueOf('Z'), BlocksAether.holystone, Character.valueOf('Y'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(ItemsAether.zanite_pickaxe, 1), "ZZZ", " Y ", " Y ", Character.valueOf('Z'), ItemsAether.zanite_gemstone, Character.valueOf('Y'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(ItemsAether.gravitite_pickaxe, 1), "ZZZ", " Y ", " Y ", Character.valueOf('Z'), BlocksAether.enchanted_gravitite, Character.valueOf('Y'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(ItemsAether.skyroot_axe, 1), "ZZ", "ZY", " Y", Character.valueOf('Z'), BlocksAether.skyroot_plank, Character.valueOf('Y'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(ItemsAether.holystone_axe, 1), "ZZ", "ZY", " Y", Character.valueOf('Z'), BlocksAether.holystone, Character.valueOf('Y'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(ItemsAether.zanite_axe, 1), "ZZ", "ZY", " Y", Character.valueOf('Z'), ItemsAether.zanite_gemstone, Character.valueOf('Y'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(ItemsAether.gravitite_axe, 1), "ZZ", "ZY", " Y", Character.valueOf('Z'), BlocksAether.enchanted_gravitite, Character.valueOf('Y'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(ItemsAether.skyroot_shovel, 1), "Z", "Y", "Y", Character.valueOf('Z'), BlocksAether.skyroot_plank, Character.valueOf('Y'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(ItemsAether.holystone_shovel, 1), "Z", "Y", "Y", Character.valueOf('Z'), BlocksAether.holystone, Character.valueOf('Y'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(ItemsAether.zanite_shovel, 1), "Z", "Y", "Y", Character.valueOf('Z'), ItemsAether.zanite_gemstone, Character.valueOf('Y'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(ItemsAether.gravitite_shovel, 1), "Z", "Y", "Y", Character.valueOf('Z'), BlocksAether.enchanted_gravitite, Character.valueOf('Y'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(ItemsAether.skyroot_sword, 1), "Z", "Z", "Y", Character.valueOf('Z'), BlocksAether.skyroot_plank, Character.valueOf('Y'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(ItemsAether.holystone_sword, 1), "Z", "Z", "Y", Character.valueOf('Z'), BlocksAether.holystone, Character.valueOf('Y'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(ItemsAether.zanite_sword, 1), "Z", "Z", "Y", Character.valueOf('Z'), ItemsAether.zanite_gemstone, Character.valueOf('Y'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(ItemsAether.gravitite_sword, 1), "Z", "Z", "Y", Character.valueOf('Z'), BlocksAether.enchanted_gravitite, Character.valueOf('Y'), ItemsAether.skyroot_stick);
        AetherRegistries.register(new ItemStack(ItemsAether.white_cape), "ZZ", "ZZ", "ZZ", Character.valueOf('Z'), new ItemStack(Blocks.field_150325_L, 1, 0));
        AetherRegistries.register(new ItemStack(ItemsAether.blue_cape), "ZZ", "ZZ", "ZZ", Character.valueOf('Z'), new ItemStack(Blocks.field_150325_L, 1, 11));
        AetherRegistries.register(new ItemStack(ItemsAether.yellow_cape), "ZZ", "ZZ", "ZZ", Character.valueOf('Z'), new ItemStack(Blocks.field_150325_L, 1, 4));
        AetherRegistries.register(new ItemStack(ItemsAether.red_cape), "ZZ", "ZZ", "ZZ", Character.valueOf('Z'), new ItemStack(Blocks.field_150325_L, 1, 14));
        AetherRegistries.register(new ItemStack(ItemsAether.leather_gloves), "C C", Character.valueOf('C'), Items.field_151116_aA);
        AetherRegistries.register(new ItemStack(ItemsAether.iron_gloves), "C C", Character.valueOf('C'), Items.field_151042_j);
        AetherRegistries.register(new ItemStack(ItemsAether.golden_gloves), "C C", Character.valueOf('C'), Items.field_151043_k);
        AetherRegistries.register(new ItemStack(ItemsAether.diamond_gloves), "C C", Character.valueOf('C'), Items.field_151045_i);
        AetherRegistries.register(new ItemStack(ItemsAether.zanite_gloves), "C C", Character.valueOf('C'), ItemsAether.zanite_gemstone);
        AetherRegistries.register(new ItemStack(ItemsAether.gravitite_gloves), "C C", Character.valueOf('C'), BlocksAether.enchanted_gravitite);
        AetherRegistries.register(new ItemStack(BlocksAether.skyroot_fence, 3), "ZXZ", "ZXZ", Character.valueOf('Z'), new ItemStack(BlocksAether.skyroot_plank), Character.valueOf('X'), new ItemStack(ItemsAether.skyroot_stick));
        AetherRegistries.register(new ItemStack(BlocksAether.skyroot_fence_gate), "ZXZ", "ZXZ", Character.valueOf('X'), new ItemStack(BlocksAether.skyroot_plank), Character.valueOf('Z'), new ItemStack(ItemsAether.skyroot_stick));
        AetherRegistries.register(new ItemStack(BlocksAether.skyroot_bookshelf), "ZZZ", "XXX", "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.skyroot_plank), Character.valueOf('X'), new ItemStack(Items.field_151122_aG));
        AetherRegistries.register(new ItemStack(BlocksAether.carved_slab, 6), "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.dungeon_block, 1, 0));
        AetherRegistries.register(new ItemStack(BlocksAether.angelic_slab, 6), "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.dungeon_block, 1, 2));
        AetherRegistries.register(new ItemStack(BlocksAether.hellfire_slab, 6), "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.dungeon_block, 1, 4));
        AetherRegistries.register(new ItemStack(BlocksAether.holystone_slab, 6), "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.holystone, 1));
        AetherRegistries.register(new ItemStack(BlocksAether.mossy_holystone_slab, 6), "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.mossy_holystone, 1));
        AetherRegistries.register(new ItemStack(BlocksAether.holystone_brick_slab, 6), "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.holystone_brick, 1));
        AetherRegistries.register(new ItemStack(BlocksAether.skyroot_slab, 6), "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.skyroot_plank));
        AetherRegistries.register(new ItemStack(BlocksAether.aerogel_slab, 6), "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.aerogel));
        AetherRegistries.register(new ItemStack(BlocksAether.carved_wall, 6), "ZZZ", "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.dungeon_block, 1, 0));
        AetherRegistries.register(new ItemStack(BlocksAether.angelic_wall, 6), "ZZZ", "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.dungeon_block, 1, 2));
        AetherRegistries.register(new ItemStack(BlocksAether.hellfire_wall, 6), "ZZZ", "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.dungeon_block, 1, 4));
        AetherRegistries.register(new ItemStack(BlocksAether.holystone_wall, 6), "ZZZ", "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.holystone, 1));
        AetherRegistries.register(new ItemStack(BlocksAether.mossy_holystone_wall, 6), "ZZZ", "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.mossy_holystone, 1));
        AetherRegistries.register(new ItemStack(BlocksAether.holystone_brick_wall, 6), "ZZZ", "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.holystone_brick, 1));
        AetherRegistries.register(new ItemStack(BlocksAether.aerogel_wall, 6), "ZZZ", "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.aerogel, 1));
        AetherRegistries.register(new ItemStack(BlocksAether.carved_stairs, 4), "Z  ", "ZZ ", "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.dungeon_block, 1, 0));
        AetherRegistries.register(new ItemStack(BlocksAether.angelic_stairs, 4), "Z  ", "ZZ ", "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.dungeon_block, 1, 2));
        AetherRegistries.register(new ItemStack(BlocksAether.hellfire_stairs, 4), "Z  ", "ZZ ", "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.dungeon_block, 1, 4));
        AetherRegistries.register(new ItemStack(BlocksAether.holystone_stairs, 4), "Z  ", "ZZ ", "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.holystone, 1));
        AetherRegistries.register(new ItemStack(BlocksAether.mossy_holystone_stairs, 4), "Z  ", "ZZ ", "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.mossy_holystone, 1));
        AetherRegistries.register(new ItemStack(BlocksAether.holystone_brick_stairs, 4), "Z  ", "ZZ ", "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.holystone_brick, 1));
        AetherRegistries.register(new ItemStack(BlocksAether.skyroot_stairs, 4), "Z  ", "ZZ ", "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.skyroot_plank));
        AetherRegistries.register(new ItemStack(BlocksAether.aerogel_stairs, 4), "Z  ", "ZZ ", "ZZZ", Character.valueOf('Z'), new ItemStack(BlocksAether.aerogel));
    }

    public static void register(ItemStack stack, Object ... recipe) {
        GameRegistry.addRecipe((ItemStack)stack, (Object[])recipe);
    }

    public static void registerShapeless(ItemStack stack, Object ... recipe) {
        GameRegistry.addShapelessRecipe((ItemStack)stack, (Object[])recipe);
    }
}

