/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.player.capability;

import com.legacy.aether.player.PlayerAether;
import com.legacy.aether.player.capability.PlayerAetherManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public class PlayerAetherProvider
implements ICapabilityProvider,
INBTSerializable<NBTTagCompound> {
    private final PlayerAether playerAether;

    public PlayerAetherProvider(PlayerAether playerAether) {
        this.playerAether = playerAether;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == PlayerAetherManager.AETHER_PLAYER;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == PlayerAetherManager.AETHER_PLAYER) {
            return (T)this.playerAether;
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound output = new NBTTagCompound();
        if (this.playerAether != null) {
            this.playerAether.saveNBTData(output);
        }
        return output;
    }

    public void deserializeNBT(NBTTagCompound input) {
        if (this.playerAether != null) {
            this.playerAether.loadNBTData(input);
        }
    }
}

