/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.networking.packets;

import com.legacy.aether.networking.packets.AetherPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PacketSetTime
extends AetherPacket<PacketSetTime> {
    public float timeVariable;
    public int dimensionId;

    public PacketSetTime() {
    }

    public PacketSetTime(float timeVariable, int dimensionId) {
        this.dimensionId = dimensionId;
        this.timeVariable = timeVariable;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimensionId = buf.readInt();
        this.timeVariable = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimensionId);
        buf.writeFloat(this.timeVariable);
    }

    @Override
    public void handleClient(PacketSetTime message, EntityPlayer player) {
    }

    @Override
    public void handleServer(PacketSetTime message, EntityPlayer player) {
        message.setTime(message.timeVariable, message.dimensionId);
    }

    public void setTime(float sliderValue, int dimension) {
        long shouldTime = (long)(24000.0f * sliderValue);
        WorldServer world = DimensionManager.getWorld((int)dimension);
        long worldTime = world.func_72912_H().func_76073_f();
        long remainder = worldTime % 24000L;
        long add = shouldTime > remainder ? shouldTime - remainder : shouldTime + 24000L - remainder;
        world.func_72912_H().func_76068_b(worldTime + add);
    }
}

