/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.items.tools;

import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.items.util.EnumSkyrootBucketType;
import com.legacy.aether.items.util.FluidSkyrootBucketWrapper;
import com.legacy.aether.player.PlayerAether;
import com.legacy.aether.registry.creative_tabs.AetherCreativeTabs;
import java.util.List;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSkyrootBucket
extends Item {
    public ItemSkyrootBucket() {
        this.func_77627_a(true);
        this.func_77642_a(this);
        this.func_77637_a(AetherCreativeTabs.misc);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int meta = 0; meta < EnumSkyrootBucketType.values().length; ++meta) {
            list.add(new ItemStack((Item)this, 1, meta));
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return stack.func_77960_j() == 3 ? EnumRarity.RARE : super.func_77613_e(stack);
    }

    public int getItemStackLimit(ItemStack stack) {
        return EnumSkyrootBucketType.getType(stack.func_77952_i()) == EnumSkyrootBucketType.Empty ? 16 : 1;
    }

    public String func_77667_c(ItemStack itemstack) {
        int meta = itemstack.func_77952_i();
        return this.func_77658_a() + "_" + EnumSkyrootBucketType.getType(meta).toString();
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        BlockPos blockpos1;
        int meta = stack.func_77952_i();
        if (EnumSkyrootBucketType.getType(meta) != EnumSkyrootBucketType.Water && EnumSkyrootBucketType.getType(meta) != EnumSkyrootBucketType.Empty) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        boolean isEmpty = EnumSkyrootBucketType.getType(meta) == EnumSkyrootBucketType.Empty;
        RayTraceResult movingobjectposition = this.func_77621_a(world, player, isEmpty);
        ActionResult ret = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)world, (ItemStack)stack, (RayTraceResult)movingobjectposition);
        if (ret != null) {
            return ret;
        }
        if (movingobjectposition == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (movingobjectposition.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        BlockPos blockpos = movingobjectposition.func_178782_a();
        if (!world.func_175660_a(player, blockpos)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (isEmpty) {
            if (!player.func_175151_a(blockpos.func_177972_a(movingobjectposition.field_178784_b), movingobjectposition.field_178784_b, stack)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            IBlockState iblockstate = world.func_180495_p(blockpos);
            Material material = iblockstate.func_185904_a();
            if (material == Material.field_151586_h && (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 11);
                player.func_71029_a(StatList.func_188057_b((Item)this));
                player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)this.fillBucket(stack, player, ItemsAether.skyroot_bucket));
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        boolean flag1 = world.func_180495_p(blockpos).func_177230_c().func_176200_f((IBlockAccess)world, blockpos);
        BlockPos blockPos = blockpos1 = flag1 && movingobjectposition.field_178784_b == EnumFacing.UP ? blockpos : blockpos.func_177972_a(movingobjectposition.field_178784_b);
        if (!player.func_175151_a(blockpos1, movingobjectposition.field_178784_b, stack)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (this.tryPlaceContainedLiquid(player, world, stack, blockpos1)) {
            player.func_71029_a(StatList.func_188057_b((Item)this));
            return !player.field_71075_bZ.field_75098_d ? new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack(ItemsAether.skyroot_bucket)) : new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    private ItemStack fillBucket(ItemStack emptyBuckets, EntityPlayer player, Item fullBucket) {
        if (player.field_71075_bZ.field_75098_d) {
            return emptyBuckets;
        }
        if (--emptyBuckets.field_77994_a <= 0) {
            return new ItemStack(fullBucket, 1, 1);
        }
        if (!player.field_71071_by.func_70441_a(new ItemStack(fullBucket, 1, 1))) {
            player.func_71019_a(new ItemStack(fullBucket, 1, 1), false);
        }
        return emptyBuckets;
    }

    public boolean tryPlaceContainedLiquid(EntityPlayer player, World world, ItemStack stack, BlockPos pos) {
        boolean flag;
        if (EnumSkyrootBucketType.getType(stack.func_77952_i()) != EnumSkyrootBucketType.Water) {
            return false;
        }
        Material material = world.func_180495_p(pos).func_185904_a();
        boolean bl = flag = !material.func_76220_a();
        if (!world.func_175623_d(pos) && !flag) {
            return false;
        }
        if (world.field_73011_w.func_177500_n()) {
            world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            if (!world.field_72995_K && flag && !material.func_76224_d()) {
                world.func_180495_p(pos).func_177230_c().func_180663_b(world, pos, world.func_180495_p(pos));
            }
            player.func_184185_a(SoundEvents.field_187624_K, 1.0f, 1.0f);
            world.func_180501_a(pos, Blocks.field_150358_i.func_176223_P(), 11);
        }
        return true;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            return this.onEaten(stack, worldIn, (EntityPlayer)entityLiving);
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public ItemStack onEaten(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        PlayerAether player = PlayerAether.get(entityplayer);
        int meta = itemstack.func_77952_i();
        if (!entityplayer.field_71075_bZ.field_75098_d) {
            --itemstack.field_77994_a;
        }
        if (EnumSkyrootBucketType.getType(meta) == EnumSkyrootBucketType.Poison) {
            player.afflictPoison();
        } else if (EnumSkyrootBucketType.getType(meta) == EnumSkyrootBucketType.Remedy) {
            player.attainCure(200);
        } else if (EnumSkyrootBucketType.getType(meta) == EnumSkyrootBucketType.Milk && !world.field_72995_K) {
            entityplayer.curePotionEffects(new ItemStack(Items.field_151117_aB));
        }
        return itemstack.field_77994_a <= 0 ? new ItemStack((Item)this, 1, 0) : itemstack;
    }

    public int func_77626_a(ItemStack itemstack) {
        int meta = itemstack.func_77952_i();
        if (EnumSkyrootBucketType.getType(meta) != EnumSkyrootBucketType.Water) {
            return 32;
        }
        return 0;
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        int meta = itemstack.func_77952_i();
        if (EnumSkyrootBucketType.getType(meta) != EnumSkyrootBucketType.Water) {
            return EnumAction.DRINK;
        }
        return EnumAction.NONE;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidSkyrootBucketWrapper(stack);
    }
}

