/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.items.accessories;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.legacy.aether.Aether;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.player.PlayerAether;
import com.legacy.aether.registry.creative_tabs.AetherCreativeTabs;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAccessory
extends Item {
    public static final String ROOT = Aether.modAddress() + "textures/slots/slot_";
    public ResourceLocation texture = Aether.locate("textures/armor/accessory_base.png");
    public ResourceLocation texture_slim = Aether.locate("textures/armor/accessory_base_slim.png");
    private int colorHex = 0xDDDDDD;
    private boolean isDungeonLoot = false;
    public static final IBehaviorDispenseItem DISPENSER_BEHAVIOR = new BehaviorDefaultDispenseItem(){

        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            ItemStack itemstack = ItemAccessory.dispenseAccessory(source, stack);
            return itemstack != null ? itemstack : super.func_82487_b(source, stack);
        }
    };

    public ItemAccessory() {
        this.func_77625_d(1);
        this.func_77637_a(AetherCreativeTabs.accessories);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)DISPENSER_BEHAVIOR);
    }

    public static ItemStack dispenseAccessory(IBlockSource blockSource, ItemStack stack) {
        BlockPos blockpos = blockSource.func_180699_d().func_177972_a((EnumFacing)blockSource.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
        List list = blockSource.func_82618_k().func_175647_a(EntityLivingBase.class, new AxisAlignedBB(blockpos), Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new EntitySelectors.ArmoredMob(stack)));
        if (list.isEmpty()) {
            return null;
        }
        EntityLivingBase entitylivingbase = (EntityLivingBase)list.get(0);
        if (entitylivingbase instanceof EntityPlayer) {
            ItemStack itemstack = stack.func_77946_l();
            itemstack.field_77994_a = 1;
            PlayerAether playerAether = PlayerAether.get((EntityPlayer)entitylivingbase);
            if (!playerAether.accessories.setInventoryAccessory(itemstack)) {
                BehaviorDefaultDispenseItem.func_82486_a((World)blockSource.func_82618_k(), (ItemStack)itemstack, (int)6, (EnumFacing)((EnumFacing)blockSource.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a)), (IPosition)BlockDispenser.func_149939_a((IBlockSource)blockSource));
            }
            --stack.field_77994_a;
            return stack;
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World worldIn, EntityPlayer player, EnumHand hand) {
        if (itemStack != null && PlayerAether.get((EntityPlayer)player).accessories.setInventoryAccessory(itemStack.func_77946_l())) {
            --itemStack.field_77994_a;
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
    }

    public Item setColor(int color) {
        this.colorHex = color;
        return this;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.isDungeonLoot ? ItemsAether.aether_loot : super.func_77613_e(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int meta) {
        return this.colorHex;
    }

    public ItemAccessory setDungeonLoot() {
        this.isDungeonLoot = true;
        return this;
    }

    public ItemAccessory setTexture(String location) {
        this.texture = new ResourceLocation("aether_legacy", "textures/armor/accessory_" + location + ".png");
        this.texture_slim = Aether.locate("textures/armor/accessory_" + location + "_slim.png");
        return this;
    }
}

