/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.entities.passive.mountable;

import com.legacy.aether.entities.util.EntitySaddleMount;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.registry.achievements.AchievementsAether;
import com.legacy.aether.registry.sounds.SoundsAether;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityPhyg
extends EntitySaddleMount {
    public float wingFold;
    public float wingAngle;
    private float aimingForFold;
    public int maxJumps = 1;
    public int jumpsRemaining = 0;
    public int ticks;

    public EntityPhyg(World world) {
        super(world);
        this.field_70138_W = 1.0f;
        this.field_70158_ak = true;
        this.canJumpMidAir = true;
        this.func_70105_a(0.9f, 1.3f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, ItemsAether.blue_berry, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_70606_j(10.0f);
        if (this.getSaddled()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
            this.func_70606_j(20.0f);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70122_E) {
            this.wingAngle *= 0.8f;
            this.aimingForFold = 0.1f;
            this.jumpsRemaining = this.maxJumps;
        } else {
            this.aimingForFold = 1.0f;
        }
        if (!this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) instanceof EntityPlayer) {
            ((EntityPlayer)this.func_184188_bt().get(0)).func_71029_a((StatBase)AchievementsAether.flying_pig);
        }
        ++this.ticks;
        this.wingAngle = this.wingFold * (float)Math.sin((float)this.ticks / 31.830988f);
        this.wingFold += (this.aimingForFold - this.wingFold) / 5.0f;
        this.field_70143_R = 0.0f;
        this.fall();
    }

    protected SoundEvent func_184615_bR() {
        return SoundsAether.phyg_death;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundsAether.phyg_hurt;
    }

    protected SoundEvent func_184639_G() {
        return SoundsAether.phyg_say;
    }

    public double func_70042_X() {
        return 0.65;
    }

    @Override
    public float getMountedMoveSpeed() {
        return 0.3f;
    }

    protected void func_70664_aZ() {
        if (this.func_184188_bt().isEmpty()) {
            super.func_70664_aZ();
        }
    }

    @Override
    protected void func_70628_a(boolean par1, int par2) {
        int j = this.field_70146_Z.nextInt(3) + 1 + this.field_70146_Z.nextInt(1 + par2);
        for (int k = 0; k < j; ++k) {
            if (this.func_70027_ad()) {
                this.func_145779_a(Items.field_151157_am, 1);
                continue;
            }
            this.func_145779_a(Items.field_151147_al, 1);
        }
        if (this.getSaddled()) {
            this.func_145779_a(Items.field_151141_av, 1);
        }
    }

    private void fall() {
        if (this.field_70181_x < 0.0 && !this.isRiderSneaking()) {
            this.field_70181_x *= 0.6;
        }
        if (!this.field_70122_E && !this.field_70703_bu && this.field_70122_E && !this.field_70170_p.field_72995_K) {
            this.jumpsRemaining = this.maxJumps;
        }
    }

    @Override
    protected double getMountJumpStrength() {
        return 5.0;
    }

    @Override
    protected void func_180429_a(BlockPos pos, Block par4) {
        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187709_dP, SoundCategory.NEUTRAL, 0.15f, 1.0f);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.maxJumps = nbttagcompound.func_74765_d("Jumps");
        this.jumpsRemaining = nbttagcompound.func_74765_d("Remaining");
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74777_a("Jumps", (short)this.maxJumps);
        nbttagcompound.func_74777_a("Remaining", (short)this.jumpsRemaining);
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return new EntityPhyg(this.field_70170_p);
    }
}

