/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.entities.passive;

import com.legacy.aether.entities.ai.SheepuffAIEatAetherGrass;
import com.legacy.aether.entities.passive.EntityAetherAnimal;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.registry.sounds.SoundsAether;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySheepuff
extends EntityAetherAnimal {
    public static final DataParameter<Byte> FLEECE_COLOR = EntityDataManager.func_187226_a(EntitySheepuff.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final DataParameter<Boolean> SHEARED = EntityDataManager.func_187226_a(EntitySheepuff.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> PUFFY = EntityDataManager.func_187226_a(EntitySheepuff.class, (DataSerializer)DataSerializers.field_187198_h);
    private SheepuffAIEatAetherGrass entityAIEatGrass;
    private int sheepTimer;
    private int amountEaten;

    public EntitySheepuff(World world) {
        super(world);
        this.func_70105_a(0.9f, 1.3f);
        this.setFleeceColor(EntitySheepuff.getRandomFleeceColor(this.field_70146_Z));
        this.amountEaten = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, ItemsAether.blue_berry, false));
        this.entityAIEatGrass = new SheepuffAIEatAetherGrass(this);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLEECE_COLOR, (Object)new Byte(0));
        this.field_70180_af.func_187214_a(SHEARED, (Object)false);
        this.field_70180_af.func_187214_a(PUFFY, (Object)false);
    }

    protected void func_70628_a(boolean var1, int ammount) {
        if (!this.getSheared()) {
            this.func_70099_a(new ItemStack(Blocks.field_150325_L, 1 + this.field_70146_Z.nextInt(2), this.getFleeceColor()), 0.0f);
        }
        int i = this.field_70146_Z.nextInt(2) + 1 + this.field_70146_Z.nextInt(1 + ammount);
        for (int j = 0; j < i; ++j) {
            if (this.func_70027_ad()) {
                this.func_145779_a(Items.field_179557_bn, 1);
                continue;
            }
            this.func_145779_a(Items.field_179561_bm, 1);
        }
    }

    protected void func_70619_bc() {
        this.sheepTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.func_70636_d();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        return this.sheepTimer <= 0 ? 0.0f : (this.sheepTimer >= 4 && this.sheepTimer <= 36 ? 1.0f : (this.sheepTimer < 4 ? ((float)this.sheepTimer - p_70894_1_) / 4.0f : -((float)(this.sheepTimer - 40) - p_70894_1_) / 4.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public void func_70615_aA() {
        ++this.amountEaten;
    }

    protected void func_180429_a(BlockPos pos, Block par4) {
        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187765_eK, SoundCategory.NEUTRAL, 0.15f, 1.0f);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack stack) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151097_aZ && !this.getSheared()) {
            if (!this.field_70170_p.field_72995_K) {
                if (this.getPuffed()) {
                    this.setPuffed(false);
                } else {
                    this.setSheared(true);
                }
                int i = 2 + this.field_70146_Z.nextInt(3);
                for (int j = 0; j < i; ++j) {
                    EntityItem entityitem = this.func_70099_a(new ItemStack(Blocks.field_150325_L, 1, this.getFleeceColor()), 1.0f);
                    entityitem.field_70181_x += (double)(this.field_70146_Z.nextFloat() * 0.05f);
                    entityitem.field_70159_w += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                    entityitem.field_70179_y += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                }
            }
            itemstack.func_77972_a(1, (EntityLivingBase)player);
        }
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151100_aR && !this.getSheared()) {
            EnumDyeColor color = EnumDyeColor.func_176766_a((int)itemstack.func_77952_i());
            int colorID = color.func_176765_a();
            if (this.getFleeceColor() != colorID) {
                if (this.getPuffed() && itemstack.field_77994_a >= 2) {
                    this.setFleeceColor(colorID);
                    itemstack.field_77994_a -= 2;
                } else if (!this.getPuffed()) {
                    this.setFleeceColor(colorID);
                    --itemstack.field_77994_a;
                }
            }
        }
        return super.func_184645_a(player, hand, stack);
    }

    protected void func_70664_aZ() {
        if (this.getPuffed()) {
            this.field_70181_x = 1.8;
            this.field_70159_w += this.field_70146_Z.nextGaussian() * 0.5;
            this.field_70179_y += this.field_70146_Z.nextGaussian() * 0.5;
        } else {
            this.field_70181_x = 0.42f;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getPuffed()) {
            this.field_70143_R = 0.0f;
            if (this.field_70181_x < -0.05) {
                this.field_70181_x = -0.05;
            }
        }
        if (this.amountEaten == 5 && !this.getSheared() && !this.getPuffed()) {
            this.setPuffed(true);
            this.amountEaten = 0;
        }
        if (this.amountEaten == 10 && this.getSheared() && !this.getPuffed()) {
            this.setSheared(false);
            this.setFleeceColor(0);
            this.amountEaten = 0;
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Sheared", this.getSheared());
        nbttagcompound.func_74757_a("Puffed", this.getPuffed());
        nbttagcompound.func_74774_a("Color", (byte)this.getFleeceColor());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setSheared(nbttagcompound.func_74767_n("Sheared"));
        this.setPuffed(nbttagcompound.func_74767_n("Puffed"));
        this.setFleeceColor(nbttagcompound.func_74771_c("Color"));
    }

    protected SoundEvent func_184639_G() {
        return SoundsAether.sheepuff_say;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundsAether.sheepuff_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsAether.sheepuff_death;
    }

    public int getFleeceColor() {
        return (Byte)this.field_70180_af.func_187225_a(FLEECE_COLOR) & 0xF;
    }

    public void setFleeceColor(int i) {
        byte byte0 = (Byte)this.field_70180_af.func_187225_a(FLEECE_COLOR);
        this.field_70180_af.func_187227_b(FLEECE_COLOR, (Object)((byte)(byte0 & 0xF0 | i & 0xF)));
    }

    public boolean getSheared() {
        return (Boolean)this.field_70180_af.func_187225_a(SHEARED);
    }

    public void setSheared(boolean flag) {
        this.field_70180_af.func_187227_b(SHEARED, (Object)flag);
    }

    public boolean getPuffed() {
        return (Boolean)this.field_70180_af.func_187225_a(PUFFY);
    }

    public void setPuffed(boolean flag) {
        this.field_70180_af.func_187227_b(PUFFY, (Object)flag);
    }

    public static int getRandomFleeceColor(Random random) {
        int i = random.nextInt(100);
        if (i < 5) {
            return 3;
        }
        if (i < 10) {
            return 9;
        }
        if (i < 15) {
            return 5;
        }
        if (i < 18) {
            return 6;
        }
        return random.nextInt(500) != 0 ? 0 : 10;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return new EntitySheepuff(this.field_70170_p);
    }
}

