/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.entities.passive;

import com.legacy.aether.entities.projectile.crystals.EntityIceyBall;
import com.legacy.aether.registry.sounds.SoundsAether;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityMiniCloud
extends EntityFlying {
    public EntityPlayer owner;
    public int shotTimer;
    public int lifeSpan;
    public boolean hasOwner;
    public boolean direction;
    public boolean hasSpawned = false;
    public double targetX;
    public double targetY;
    public double targetZ;

    public EntityMiniCloud(World worldObj) {
        super(worldObj);
        this.field_70144_Y = 1.75f;
    }

    public EntityMiniCloud(World worldObj, EntityPlayer owner, int direction) {
        this(worldObj);
        this.func_70105_a(0.5f, 0.45f);
        this.owner = owner;
        this.direction = direction == 0;
        this.lifeSpan = 3600;
        this.getTargetPos();
        this.hasOwner = true;
        this.field_70145_X = true;
        this.func_70107_b(this.targetX, this.targetY, this.targetZ);
        this.field_70125_A = this.owner.field_70125_A;
        this.field_70177_z = this.owner.field_70177_z;
    }

    public boolean func_70112_a(double var1) {
        return true;
    }

    public void getTargetPos() {
        if (this.func_70032_d((Entity)this.owner) > 2.0f) {
            this.targetX = this.owner.field_70165_t;
            this.targetY = this.owner.field_70163_u - (double)0.1f;
            this.targetZ = this.owner.field_70161_v;
        } else {
            double var1 = this.owner.field_70177_z;
            var1 = this.direction ? (var1 -= 90.0) : (var1 += 90.0);
            this.targetX = this.owner.field_70165_t + Math.sin(var1 /= -57.29577951308232) * 1.05;
            this.targetY = this.owner.field_70163_u - (double)0.1f;
            this.targetZ = this.owner.field_70161_v + Math.cos(var1) * 1.05;
        }
    }

    public boolean atShoulder() {
        double var1 = this.field_70165_t - this.targetX;
        double var3 = this.field_70163_u - this.targetY;
        double var5 = this.field_70161_v - this.targetZ;
        return Math.sqrt(var1 * var1 + var3 * var3 + var5 * var5) < 0.3;
    }

    public void approachTarget() {
        double var1 = this.targetX - this.field_70165_t;
        double var3 = this.targetY - this.field_70163_u;
        double var5 = this.targetZ - this.field_70161_v;
        double var7 = Math.sqrt(var1 * var1 + var3 * var3 + var5 * var5) * 3.25;
        this.field_70159_w = (this.field_70159_w + var1 / var7) / 2.0;
        this.field_70181_x = (this.field_70181_x + var3 / var7) / 2.0;
        this.field_70179_y = (this.field_70179_y + var5 / var7) / 2.0;
        Math.atan2(var1, var5);
    }

    public void func_70014_b(NBTTagCompound var1) {
        super.func_70014_b(var1);
        var1.func_74777_a("LifeSpan", (short)this.lifeSpan);
        var1.func_74777_a("ShotTimer", (short)this.shotTimer);
        this.hasOwner = this.owner != null;
        var1.func_74757_a("GotPlayer", this.hasOwner);
        var1.func_74757_a("direction", this.direction);
    }

    public void func_70037_a(NBTTagCompound var1) {
        super.func_70037_a(var1);
        this.lifeSpan = var1.func_74765_d("LifeSpan");
        this.shotTimer = var1.func_74765_d("ShotTimer");
        this.hasOwner = var1.func_74767_n("GotPlayer");
        this.direction = var1.func_74767_n("direction");
    }

    public void func_70030_z() {
        super.func_70030_z();
        --this.lifeSpan;
        if (this.lifeSpan <= 0) {
            this.func_70656_aK();
            this.field_70128_L = true;
        } else {
            if (!this.hasOwner || this.owner == null) {
                this.func_70106_y();
                return;
            }
            if (this.hasOwner && this.owner == null) {
                this.hasOwner = false;
                this.func_70106_y();
                return;
            }
            if (this.shotTimer > 0) {
                --this.shotTimer;
            }
            if (!this.owner.field_70128_L) {
                this.getTargetPos();
                if (this.atShoulder()) {
                    this.field_70159_w *= 0.65;
                    this.field_70181_x *= 0.65;
                    this.field_70179_y *= 0.65;
                    this.field_70177_z = this.owner.field_70177_z + (this.direction ? 1.0f : -1.0f);
                    this.field_70125_A = this.owner.field_70125_A;
                    this.field_70759_as = this.owner.field_70759_as;
                    if (this.shotTimer <= 0 && this.owner.field_70733_aJ > 0.0f) {
                        float var7 = this.field_70177_z - (this.direction ? 1.0f : -1.0f);
                        double var1 = this.field_70165_t + Math.sin((double)var7 / -57.29577951308232) * 1.6;
                        double var3 = this.field_70163_u - -1.0;
                        double var5 = this.field_70161_v + Math.cos((double)var7 / -57.29577951308232) * 1.6;
                        EntityIceyBall iceCrystal = new EntityIceyBall(this.field_70170_p, var1, var3, var5, true);
                        Vec3d var9 = this.func_70040_Z();
                        if (var9 != null) {
                            iceCrystal.smotionX = var9.field_72450_a * 1.5;
                            iceCrystal.smotionY = var9.field_72448_b * 1.5;
                            iceCrystal.smotionZ = var9.field_72449_c * 1.5;
                        }
                        iceCrystal.smacked = true;
                        if (!this.field_70170_p.field_72995_K) {
                            this.field_70170_p.func_72838_d((Entity)iceCrystal);
                        }
                        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsAether.zephyr_shoot, SoundCategory.NEUTRAL, 0.75f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f, false);
                        this.shotTimer = 40;
                    }
                } else {
                    this.approachTarget();
                }
            } else {
                this.func_70656_aK();
                this.field_70128_L = true;
            }
        }
    }

    public boolean func_70097_a(DamageSource var1, float var2) {
        if (var1.func_76346_g() == this.owner || var1.func_76355_l() == "inWall") {
            return false;
        }
        return super.func_70097_a(var1, var2);
    }
}

