/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.core;

import com.vicmatskiv.weaponlib.ClassInfo;
import com.vicmatskiv.weaponlib.compatibility.CompatibleClassInfoProvider;
import net.minecraft.item.ItemBlock;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class WeaponlibClassTransformer
implements IClassTransformer {
    private static ClassInfo entityRendererClassInfo = CompatibleClassInfoProvider.getInstance().getClassInfo("net/minecraft/client/renderer/EntityRenderer");
    private static ClassInfo renderBipedClassInfo = CompatibleClassInfoProvider.getInstance().getClassInfo("net/minecraft/client/renderer/entity/RenderBiped");

    public byte[] transform(String par1, String className, byte[] bytecode) {
        if (entityRendererClassInfo.classMatches(className) || renderBipedClassInfo != null && renderBipedClassInfo.classMatches(className)) {
            ClassReader cr = new ClassReader(bytecode);
            ClassWriter cw = new ClassWriter(cr, 1);
            CVTransform cv = new CVTransform((ClassVisitor)cw);
            cr.accept((ClassVisitor)cv, 0);
            return cw.toByteArray();
        }
        return bytecode;
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (entityRendererClassInfo.methodMatches("setupCameraTransform", "(FI)V", this.classname, name, desc)) {
                return new SetupCameraTransformMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (entityRendererClassInfo.methodMatches("setupViewBobbing", "(F)V", this.classname, name, desc)) {
                return new SetupViewBobbingMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (entityRendererClassInfo.methodMatches("hurtCameraEffect", "(F)V", this.classname, name, desc)) {
                return new HurtCameraEffectMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (renderBipedClassInfo != null && renderBipedClassInfo.methodMatches("renderEquippedItems", "(Lnet/minecraft/entity/EntityLiving;F)V", this.classname, name, desc)) {
                return new RenderEquippedItemsMethodVisitor(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }

    private static class RenderEquippedItemsMethodVisitor
    extends MethodVisitor {
        private String itemBlockClassName = ItemBlock.class.getName().replace('.', '/');

        public RenderEquippedItemsMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitTypeInsn(int opcode, String type) {
            if (opcode == 193 && type.equals(this.itemBlockClassName)) {
                this.mv.visitMethodInsn(184, "com/vicmatskiv/weaponlib/Interceptors", "is3dRenderableItem", "(Lnet/minecraft/item/Item;)Z", false);
            } else {
                super.visitTypeInsn(opcode, type);
            }
        }
    }

    private static class SetupCameraTransformMethodVisitor
    extends MethodVisitor {
        public SetupCameraTransformMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (entityRendererClassInfo.methodMatches("hurtCameraEffect", "(F)V", owner, name, desc)) {
                super.visitMethodInsn(opcode, owner, name, desc);
                this.mv.visitVarInsn(23, 1);
                this.mv.visitMethodInsn(184, "com/vicmatskiv/weaponlib/Interceptors", "setupCameraTransformAfterHurtCameraEffect", "(F)V");
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            if (opcode == 158) {
                this.mv.visitVarInsn(23, 1);
                this.mv.visitMethodInsn(184, "com/vicmatskiv/weaponlib/Interceptors", "nauseaCameraEffect", "(F)Z", false);
                this.mv.visitJumpInsn(153, label);
            }
        }
    }

    private static class HurtCameraEffectMethodVisitor
    extends MethodVisitor {
        private boolean visited;

        public HurtCameraEffectMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            if (!this.visited && opcode == 153) {
                this.mv.visitVarInsn(23, 1);
                this.mv.visitMethodInsn(184, "com/vicmatskiv/weaponlib/Interceptors", "hurtCameraEffect", "(F)Z", false);
                this.mv.visitJumpInsn(153, label);
                this.visited = true;
            }
        }
    }

    private static class SetupViewBobbingMethodVisitor
    extends MethodVisitor {
        public SetupViewBobbingMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            if (opcode == 153) {
                this.mv.visitVarInsn(23, 1);
                this.mv.visitMethodInsn(184, "com/vicmatskiv/weaponlib/Interceptors", "setupViewBobbing", "(F)Z", false);
                this.mv.visitJumpInsn(153, label);
            }
        }
    }
}

