/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.compatibility;

import com.vicmatskiv.weaponlib.compatibility.CompatibleEntityJoinWorldEvent;
import com.vicmatskiv.weaponlib.compatibility.CompatibleExposureCapability;
import com.vicmatskiv.weaponlib.compatibility.CompatibleLivingUpdateEvent;
import com.vicmatskiv.weaponlib.compatibility.CompatiblePlayerEntityTrackerProvider;
import com.vicmatskiv.weaponlib.compatibility.CompatibleStartTrackingEvent;
import com.vicmatskiv.weaponlib.compatibility.CompatibleStopTrackingEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public abstract class CompatibleServerEventHandler {
    public abstract String getModId();

    @SubscribeEvent
    public void onItemToss(ItemTossEvent itemTossEvent) {
        this.onCompatibleItemToss(itemTossEvent);
    }

    protected abstract void onCompatibleItemToss(ItemTossEvent var1);

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            ResourceLocation PLAYER_ENTITY_TRACKER = new ResourceLocation(this.getModId(), "PLAYER_ENTITY_TRACKER");
            event.addCapability(PLAYER_ENTITY_TRACKER, (ICapabilityProvider)new CompatiblePlayerEntityTrackerProvider());
        }
        ResourceLocation exposureResourceLocation = new ResourceLocation(this.getModId(), "EXPOSURE");
        event.addCapability(exposureResourceLocation, (ICapabilityProvider)new CompatibleExposureCapability());
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent e) {
        this.onCompatibleEntityJoinWorld(new CompatibleEntityJoinWorldEvent(e));
    }

    protected abstract void onCompatibleEntityJoinWorld(CompatibleEntityJoinWorldEvent var1);

    @SubscribeEvent
    public void playerStartedTracking(PlayerEvent.StartTracking e) {
        this.onCompatiblePlayerStartedTracking(new CompatibleStartTrackingEvent(e));
    }

    @SubscribeEvent
    public void playerStoppedTracking(PlayerEvent.StopTracking e) {
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent e) {
        this.onCompatibleLivingDeathEvent(e);
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent e) {
        this.onCompatibleLivingUpdateEvent(new CompatibleLivingUpdateEvent(e));
    }

    protected abstract void onCompatibleLivingDeathEvent(LivingDeathEvent var1);

    protected abstract void onCompatiblePlayerStartedTracking(CompatibleStartTrackingEvent var1);

    protected abstract void onCompatiblePlayerStoppedTracking(CompatibleStopTrackingEvent var1);

    protected abstract void onCompatibleLivingUpdateEvent(CompatibleLivingUpdateEvent var1);
}

