/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.compatibility;

import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.SpreadableExposure;
import com.vicmatskiv.weaponlib.network.TypeRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CompatibleExposureCapability
implements ICapabilitySerializable<NBTBase> {
    @CapabilityInject(value=ExposureContainer.class)
    static Capability<ExposureContainer> capabilityContainer = null;
    private ExposureContainer instance = (ExposureContainer)capabilityContainer.getDefaultInstance();

    public static void register(ModContext modContext) {
        CapabilityManager.INSTANCE.register(ExposureContainer.class, (Capability.IStorage)new ExposureContainerStorage(), ExposureContainerImpl.class);
    }

    public static <T extends SpreadableExposure> T getExposure(Entity entity, Class<T> targetClass) {
        if (entity == null) {
            return null;
        }
        ExposureContainer container = (ExposureContainer)entity.getCapability(capabilityContainer, null);
        return (T)(container != null ? (SpreadableExposure)targetClass.cast(container.getExposures().get(targetClass)) : null);
    }

    public static Collection<? extends SpreadableExposure> getExposures(Entity entity) {
        if (entity == null) {
            return null;
        }
        ExposureContainer container = (ExposureContainer)entity.getCapability(capabilityContainer, null);
        return container != null ? container.getExposures().values() : null;
    }

    public static <T extends SpreadableExposure> T removeExposure(Entity entity, Class<T> targetClass) {
        if (entity == null) {
            return null;
        }
        ExposureContainer container = (ExposureContainer)entity.getCapability(capabilityContainer, null);
        return (T)(container != null ? (SpreadableExposure)targetClass.cast(container.getExposures().remove(targetClass)) : null);
    }

    public static void updateExposure(Entity entity, SpreadableExposure exposure) {
        if (entity == null) {
            return;
        }
        ExposureContainer container = (ExposureContainer)entity.getCapability(capabilityContainer, null);
        if (container != null) {
            container.getExposures().put(exposure.getClass(), exposure);
        }
    }

    public final boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == capabilityContainer;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == capabilityContainer ? capabilityContainer.cast((Object)this.instance) : null);
    }

    public NBTBase serializeNBT() {
        return capabilityContainer.getStorage().writeNBT(capabilityContainer, (Object)this.instance, null);
    }

    public void deserializeNBT(NBTBase nbt) {
        capabilityContainer.getStorage().readNBT(capabilityContainer, (Object)this.instance, null, nbt);
    }

    public static class ExposureContainerStorage
    implements Capability.IStorage<ExposureContainer> {
        public NBTBase writeNBT(Capability<ExposureContainer> capability, ExposureContainer instance, EnumFacing side) {
            NBTTagList tagList = new NBTTagList();
            for (SpreadableExposure exposure : instance.getExposures().values()) {
                ByteBuf buf = Unpooled.buffer();
                TypeRegistry.getInstance().toBytes(exposure, buf);
                tagList.func_74742_a((NBTBase)new NBTTagByteArray(buf.array()));
            }
            return tagList;
        }

        public void readNBT(Capability<ExposureContainer> capability, ExposureContainer instance, EnumFacing side, NBTBase nbt) {
            NBTTagList tagList = (NBTTagList)nbt;
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagByteArray byteArray = (NBTTagByteArray)tagList.func_179238_g(i);
                ByteBuf buf = Unpooled.wrappedBuffer((byte[])byteArray.func_150292_c());
                SpreadableExposure exposure = (SpreadableExposure)TypeRegistry.getInstance().fromBytes(buf);
                instance.getExposures().put(exposure.getClass(), exposure);
            }
        }
    }

    public static class ExposureContainerImpl
    implements ExposureContainer {
        Map<Class<?>, SpreadableExposure> exposures = new HashMap();

        @Override
        public Map<Class<?>, SpreadableExposure> getExposures() {
            return this.exposures;
        }
    }

    public static interface ExposureContainer {
        public Map<Class<?>, SpreadableExposure> getExposures();
    }
}

