/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.compatibility;

import com.vicmatskiv.weaponlib.Explosion;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.ai.EntityCustomMob;
import com.vicmatskiv.weaponlib.compatibility.Compatibility;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.compatibility.CompatibleAchievement;
import com.vicmatskiv.weaponlib.compatibility.CompatibleAxisAlignedBB;
import com.vicmatskiv.weaponlib.compatibility.CompatibleBiomeType;
import com.vicmatskiv.weaponlib.compatibility.CompatibleBlockPos;
import com.vicmatskiv.weaponlib.compatibility.CompatibleBlockState;
import com.vicmatskiv.weaponlib.compatibility.CompatibleEntityEquipmentSlot;
import com.vicmatskiv.weaponlib.compatibility.CompatibleEnumFacing;
import com.vicmatskiv.weaponlib.compatibility.CompatibleItems;
import com.vicmatskiv.weaponlib.compatibility.CompatibleMathHelper;
import com.vicmatskiv.weaponlib.compatibility.CompatibleParticle;
import com.vicmatskiv.weaponlib.compatibility.CompatibleParticleManager;
import com.vicmatskiv.weaponlib.compatibility.CompatibleRayTraceResult;
import com.vicmatskiv.weaponlib.compatibility.CompatibleRenderGlobal;
import com.vicmatskiv.weaponlib.compatibility.CompatibleRenderingRegistry;
import com.vicmatskiv.weaponlib.compatibility.CompatibleSharedMonsterAttributes;
import com.vicmatskiv.weaponlib.compatibility.CompatibleSound;
import com.vicmatskiv.weaponlib.compatibility.CompatibleVec3;
import com.vicmatskiv.weaponlib.compatibility.CompatibleWorldGenerator;
import com.vicmatskiv.weaponlib.shader.DynamicShaderGroup;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.shader.ShaderManager;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class Compatibility1_11_2
implements Compatibility {
    private static final float DEFAULT_SHELL_CASING_FORWARD_OFFSET = 0.1f;
    private static DamageSource GENERIC_DAMAGE_SOURCE = new DamageSource("generic");
    private static CompatibleMathHelper mathHelper = new CompatibleMathHelper();

    @Override
    public World world(Entity entity) {
        return entity.field_70170_p;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityPlayer clientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setClientPlayer(EntityPlayer player) {
        Minecraft.func_71410_x().field_71439_g = (EntityPlayerSP)player;
    }

    @Override
    public void spawnEntity(EntityLivingBase player, Entity entity) {
        if (player != null) {
            player.field_70170_p.func_72838_d(entity);
        }
    }

    @Override
    public void moveParticle(CompatibleParticle particle, double motionX, double motionY, double motionZ) {
        particle.func_187110_a(motionX, motionY, motionZ);
    }

    @Override
    public int getStackSize(ItemStack consumedStack) {
        return consumedStack.func_190916_E();
    }

    @Override
    public NBTTagCompound getTagCompound(ItemStack itemStack) {
        return itemStack.func_77978_p();
    }

    @Override
    public ItemStack getItemStack(ItemTossEvent event) {
        return event.getEntityItem().func_92059_d();
    }

    @Override
    public EntityPlayer getPlayer(ItemTossEvent event) {
        return event.getPlayer();
    }

    @Override
    public ItemStack getHeldItemMainHand(EntityLivingBase player) {
        return player.func_184614_ca();
    }

    @Override
    public boolean consumeInventoryItem(EntityPlayer player, Item item) {
        return this.consumeInventoryItem(player.field_71071_by, item);
    }

    @Override
    public void ensureTagCompound(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
    }

    @Override
    public void playSound(EntityLivingBase player, CompatibleSound sound, float volume, float pitch) {
        if (sound != null) {
            player.func_184185_a(sound.getSound(), volume, pitch);
        }
    }

    @Override
    public IAttribute getMovementSpeedAttribute() {
        return SharedMonsterAttributes.field_111263_d;
    }

    @Override
    public void setTagCompound(ItemStack itemStack, NBTTagCompound tagCompound) {
        itemStack.func_77982_d(tagCompound);
    }

    @Override
    public boolean isClientSide() {
        return FMLCommonHandler.instance().getSide() == Side.CLIENT;
    }

    @Override
    public CompatibleMathHelper getMathHelper() {
        return mathHelper;
    }

    @Override
    public void playSoundToNearExcept(EntityLivingBase player, CompatibleSound sound, float volume, float pitch) {
        player.field_70170_p.func_184148_a(player instanceof EntityPlayer ? (EntityPlayer)player : null, player.field_70165_t, player.field_70163_u, player.field_70161_v, sound.getSound(), player.func_184176_by(), volume, pitch);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityPlayer getClientPlayer() {
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ScaledResolution getResolution(RenderGameOverlayEvent.Pre event) {
        return event.getResolution();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderGameOverlayEvent.ElementType getEventType(RenderGameOverlayEvent.Pre event) {
        return event.getType();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getHelmet() {
        return Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD);
    }

    @Override
    public CompatibleVec3 getLookVec(EntityPlayer player) {
        return new CompatibleVec3(player.func_70040_Z());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerKeyBinding(KeyBinding key) {
        ClientRegistry.registerKeyBinding((KeyBinding)key);
    }

    @Override
    public void registerWithEventBus(Object object) {
        MinecraftForge.EVENT_BUS.register(object);
    }

    @Override
    public void registerWithFmlEventBus(Object object) {
        MinecraftForge.EVENT_BUS.register(object);
    }

    @Override
    public void registerSound(CompatibleSound sound) {
        GameRegistry.register((IForgeRegistryEntry)sound.getSound(), (ResourceLocation)sound.getResourceLocation());
    }

    @Override
    public void registerItem(Item item, String name) {
        GameRegistry.register((IForgeRegistryEntry)item, (ResourceLocation)new ResourceLocation("mw", name));
    }

    @Override
    public void registerItem(String modId, Item item, String name) {
        if (item.getRegistryName() == null) {
            String registryName = item.func_77658_a().toLowerCase();
            int indexOfPrefix = registryName.indexOf("." + modId);
            if (indexOfPrefix > 0) {
                registryName = registryName.substring(indexOfPrefix + modId.length() + 2);
            }
            item.setRegistryName(modId, registryName);
        }
        GameRegistry.register((IForgeRegistryEntry)item);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void runInMainClientThread(Runnable runnable) {
        Minecraft.func_71410_x().func_152344_a(runnable);
    }

    @Override
    public void registerModEntity(Class<? extends Entity> entityClass, String entityName, int id, Object mod, String modId, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(modId, entityName), entityClass, (String)entityName, (int)id, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderingRegistry(CompatibleRenderingRegistry rendererRegistry) {
        MinecraftForge.EVENT_BUS.register((Object)rendererRegistry);
    }

    @Override
    public <T, E> T getPrivateValue(Class<? super E> classToAccess, E instance, String ... fieldNames) {
        return (T)ObfuscationReflectionHelper.getPrivateValue(classToAccess, instance, (String[])fieldNames);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getButton(MouseEvent event) {
        return event.getButton();
    }

    @Override
    public EntityPlayer getEntity(FOVUpdateEvent event) {
        return event.getEntity();
    }

    @Override
    public EntityLivingBase getEntity(RenderLivingEvent.Pre event) {
        return event.getEntity();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setNewFov(FOVUpdateEvent event, float fov) {
        event.setNewfov(fov);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderPlayer getRenderer(RenderLivingEvent.Pre event) {
        return (RenderPlayer)event.getRenderer();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(GuiOpenEvent event) {
        return event.getGui();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setAimed(RenderPlayer rp, boolean aimed) {
        if (aimed) {
            rp.func_177087_b().field_187075_l = ModelBiped.ArmPose.BOW_AND_ARROW;
            rp.func_177087_b().field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
        } else {
            rp.func_177087_b().field_187075_l = ModelBiped.ArmPose.EMPTY;
            rp.func_177087_b().field_187076_m = ModelBiped.ArmPose.ITEM;
        }
    }

    @Override
    public CompatibleRayTraceResult getObjectMouseOver() {
        return CompatibleRayTraceResult.fromRayTraceResult(Minecraft.func_71410_x().field_71476_x);
    }

    @Override
    public CompatibleBlockState getBlockAtPosition(World world, CompatibleRayTraceResult position) {
        IBlockState blockState = world.func_180495_p(new BlockPos(position.getBlockPosX(), position.getBlockPosY(), position.getBlockPosZ()));
        return CompatibleBlockState.fromBlockState(blockState);
    }

    @Override
    public void destroyBlock(World world, CompatibleRayTraceResult position) {
        world.func_175655_b(new BlockPos(position.getBlockPosX(), position.getBlockPosY(), position.getBlockPosZ()), true);
    }

    @Override
    public boolean consumeInventoryItem(InventoryPlayer inventoryPlayer, Item item) {
        boolean result = false;
        for (int i = 0; i < inventoryPlayer.func_70302_i_(); ++i) {
            ItemStack stack = inventoryPlayer.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item) continue;
            stack.func_190918_g(1);
            if (stack.func_190916_E() <= 0) {
                inventoryPlayer.func_70299_a(i, null);
            }
            result = true;
            break;
        }
        return result;
    }

    @Override
    public ItemStack itemStackForItem(Item item, Predicate<ItemStack> condition, EntityPlayer player) {
        ItemStack result = null;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item || !condition.test(stack)) continue;
            result = stack;
            break;
        }
        return result;
    }

    @Override
    public boolean isGlassBlock(CompatibleBlockState blockState) {
        Block block = blockState.getBlockState().func_177230_c();
        return block == Blocks.field_150359_w || block == Blocks.field_150410_aZ || block == Blocks.field_150399_cn || block == Blocks.field_150397_co;
    }

    @Override
    public float getEffectOffsetX() {
        return -0.02f;
    }

    @Override
    public float getEffectOffsetY() {
        return -1.65f;
    }

    @Override
    public float getEffectScaleFactor() {
        return 2.0f;
    }

    @Override
    public int getCurrentInventoryItemIndex(EntityPlayer player) {
        return player.field_71071_by.field_70461_c;
    }

    @Override
    public boolean addItemToPlayerInventory(EntityPlayer player, Item item, int slot) {
        boolean result = false;
        if (slot == -1) {
            player.field_71071_by.func_70441_a(new ItemStack(item));
        } else if (player.field_71071_by.field_70462_a.get(slot) == null) {
            player.field_71071_by.field_70462_a.set(slot, (Object)new ItemStack(item));
        }
        return result;
    }

    @Override
    public ItemStack getInventoryItemStack(EntityPlayer player, int inventoryItemIndex) {
        return player.field_71071_by.func_70301_a(inventoryItemIndex);
    }

    @Override
    public int getInventorySlot(EntityPlayer player, ItemStack itemStack) {
        int slot = -1;
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            if (player.field_71071_by.field_70462_a.get(i) != itemStack) continue;
            slot = i;
            break;
        }
        return slot;
    }

    @Override
    public boolean consumeInventoryItemFromSlot(EntityPlayer player, int slot) {
        if (player.field_71071_by.func_70301_a(slot) == null) {
            return false;
        }
        player.field_71071_by.func_70301_a(slot).func_190918_g(1);
        if (((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_190916_E() <= 0) {
            player.field_71071_by.func_70304_b(slot);
        }
        return true;
    }

    @Override
    public void addShapedRecipe(ItemStack itemStack, Object ... materials) {
        GameRegistry.addShapedRecipe((ItemStack)itemStack, (Object[])materials);
    }

    @Override
    public void addShapedOreRecipe(ItemStack itemStack, Object ... materials) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, materials).setMirrored(false));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void disableLightMap() {
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void enableLightMap() {
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
    }

    @Override
    public void registerBlock(String modId, Block block, String name) {
        if (block.getRegistryName() == null) {
            if (block.func_149739_a().length() < modId.length() + 2 + 5) {
                throw new IllegalArgumentException("Unlocalize block name too short " + block.func_149739_a());
            }
            String unlocalizedName = block.func_149739_a().toLowerCase();
            String registryName = unlocalizedName.substring(5 + modId.length() + 1);
            block.setRegistryName(modId, registryName);
        }
        GameRegistry.register((IForgeRegistryEntry)block);
        ItemBlock itemBlock = new ItemBlock(block);
        GameRegistry.register((IForgeRegistryEntry)itemBlock.setRegistryName(block.getRegistryName()));
    }

    @Override
    public void registerWorldGenerator(CompatibleWorldGenerator generator, int modGenerationWeight) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)generator, (int)modGenerationWeight);
    }

    @Override
    public ItemArmor.ArmorMaterial addArmorMaterial(String name, String textureName, int durability, int[] reductionAmounts, int enchantability, CompatibleSound soundOnEquip, float toughness) {
        return EnumHelper.addArmorMaterial((String)name, (String)textureName, (int)durability, (int[])reductionAmounts, (int)enchantability, (SoundEvent)(soundOnEquip != null ? soundOnEquip.getSound() : null), (float)toughness);
    }

    @Override
    public boolean inventoryHasFreeSlots(EntityPlayer player) {
        boolean result = false;
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            if (!player.field_71071_by.func_70301_a(i).func_190926_b()) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public String getDisplayName(EntityPlayer player) {
        return player.getDisplayNameString();
    }

    @Override
    public void clickBlock(CompatibleBlockPos blockPos, CompatibleEnumFacing sideHit) {
        Minecraft.func_71410_x().field_71442_b.func_180511_b(blockPos.getBlockPos(), sideHit.getEnumFacing());
    }

    @Override
    public boolean isAirBlock(World world, CompatibleBlockPos blockPos) {
        return world.func_175623_d(blockPos.getBlockPos());
    }

    @Override
    public void addChatMessage(Entity entity, String message) {
        entity.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderGlobal createCompatibleRenderGlobal() {
        return new CompatibleRenderGlobal(Minecraft.func_71410_x());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CompatibleParticleManager createCompatibleParticleManager(WorldClient world) {
        return new CompatibleParticleManager(world);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Entity getRenderViewEntity() {
        return Minecraft.func_71410_x().func_175606_aa();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setRenderViewEntity(Entity entity) {
        Minecraft.func_71410_x().func_175607_a(entity);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CompatibleParticleManager getCompatibleParticleManager() {
        return new CompatibleParticleManager(Minecraft.func_71410_x().field_71452_i);
    }

    @Override
    public void addBlockHitEffect(int x, int y, int z, CompatibleEnumFacing sideHit) {
        for (int i = 0; i < 6; ++i) {
            Minecraft.func_71410_x().field_71452_i.func_180532_a(new BlockPos(x, y, z), sideHit.getEnumFacing());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addBreakingParticle(ModContext modContext, double x, double y, double z) {
        double yOffset = 1.0;
        CompatibleParticle.CompatibleParticleBreaking particle = CompatibleParticle.createParticleBreaking(modContext, this.world((Entity)this.clientPlayer()), x, y + yOffset, z);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
    }

    @Override
    public float getAspectRatio(ModContext modContext) {
        return modContext.getAspectRatio();
    }

    @Override
    public void setStackSize(ItemStack itemStack, int size) {
        itemStack.func_190920_e(size);
    }

    private static int itemSlotIndex(Item item, Predicate<ItemStack> condition, EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            if (player.field_71071_by.func_70301_a(i) == null || player.field_71071_by.func_70301_a(i).func_77973_b() != item || !condition.test(player.field_71071_by.func_70301_a(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ItemStack consumeInventoryItem(Item item, Predicate<ItemStack> condition, EntityPlayer player, int maxSize) {
        if (maxSize <= 0) {
            return null;
        }
        int i = Compatibility1_11_2.itemSlotIndex(item, condition, player);
        if (i < 0) {
            return null;
        }
        ItemStack stackInSlot = player.field_71071_by.func_70301_a(i);
        int consumedStackSize = maxSize >= CompatibilityProvider.compatibility.getStackSize(stackInSlot) ? CompatibilityProvider.compatibility.getStackSize(stackInSlot) : maxSize;
        ItemStack result = stackInSlot.func_77979_a(consumedStackSize);
        if (CompatibilityProvider.compatibility.getStackSize(stackInSlot) <= 0) {
            player.field_71071_by.func_70304_b(i);
        }
        return result;
    }

    @Override
    public ItemStack tryConsumingCompatibleItem(List<? extends Item> compatibleParts, int maxSize, EntityPlayer player, Predicate<ItemStack> ... conditions) {
        ItemStack resultStack = null;
        for (Predicate<ItemStack> condition : conditions) {
            Item item;
            Iterator<? extends Item> iterator = compatibleParts.iterator();
            while (iterator.hasNext() && (resultStack = this.consumeInventoryItem(item = iterator.next(), condition, player, maxSize)) == null) {
            }
            if (resultStack != null) break;
        }
        return resultStack;
    }

    @Override
    public CompatibleRayTraceResult rayTraceBlocks(Entity entity, CompatibleVec3 vec3, CompatibleVec3 vec31) {
        return CompatibleRayTraceResult.fromRayTraceResult(entity.func_130014_f_().func_72933_a(vec3.getVec(), vec31.getVec()));
    }

    @Override
    public CompatibleAxisAlignedBB expandEntityBoundingBox(Entity entity1, double f1, double f2, double f3) {
        return new CompatibleAxisAlignedBB(entity1.func_174813_aQ().func_72314_b(f1, f2, f3));
    }

    @Override
    public CompatibleAxisAlignedBB getBoundingBox(Entity entity) {
        return new CompatibleAxisAlignedBB(entity.func_174813_aQ());
    }

    @Override
    public List<Entity> getEntitiesWithinAABBExcludingEntity(World world, Entity entity, CompatibleAxisAlignedBB boundingBox) {
        return world.func_72839_b(entity, boundingBox.getBoundingBox());
    }

    @Override
    public void spawnParticle(World world, String particleName, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed) {
        EnumParticleTypes particleType = EnumParticleTypes.func_186831_a((String)particleName);
        if (particleType != null) {
            world.func_175688_a(particleType, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, new int[0]);
        }
    }

    @Override
    public CompatibleBlockState getBlockAtPosition(World world, CompatibleBlockPos blockPos) {
        return CompatibleBlockState.fromBlockState(world.func_180495_p(blockPos.getBlockPos()));
    }

    @Override
    public Item findItemByName(String modId, String itemName) {
        return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(modId, itemName));
    }

    @Override
    public String getPlayerName(EntityPlayer player) {
        return player.func_70005_c_();
    }

    @Override
    public boolean isBlockPenetratableByBullets(Block block) {
        return block == Blocks.field_150350_a || block == Blocks.field_150329_H || block == Blocks.field_150362_t || block == Blocks.field_150361_u || block == Blocks.field_150480_ab || block == Blocks.field_150407_cf || block == Blocks.field_150398_cm || block == Blocks.field_150321_G || block == Blocks.field_150464_aj;
    }

    @Override
    public boolean canCollideCheck(Block block, CompatibleBlockState metadata, boolean hitIfLiquid) {
        return block.func_176209_a(metadata.getBlockState(), hitIfLiquid);
    }

    @Override
    public float getCompatibleShellCasingForwardOffset() {
        return 0.1f;
    }

    @Override
    public boolean madeFromHardMaterial(CompatibleBlockState blockState) {
        Material material = blockState.getBlockState().func_185904_a();
        return material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151588_w || material == Material.field_151575_d;
    }

    @Override
    public void playSoundAtEntity(Entity entity, CompatibleSound sound, float volume, float pitch) {
        if (sound != null) {
            entity.func_184185_a(sound.getSound(), volume, pitch);
        }
    }

    @Override
    public double getBlockDensity(World world, CompatibleVec3 vec3, CompatibleAxisAlignedBB boundingBox) {
        return world.func_72842_a(vec3.getVec(), boundingBox.getBoundingBox());
    }

    @Override
    public boolean isImmuneToExplosions(Entity entity) {
        return entity.func_180427_aV();
    }

    @Override
    public boolean isAirBlock(CompatibleBlockState blockState) {
        return blockState.getBlockState().func_177230_c() == Blocks.field_150350_a;
    }

    private net.minecraft.world.Explosion getCompatibleExplosion(Explosion e) {
        return new net.minecraft.world.Explosion(e.getWorld(), e.getExploder(), e.getExplosionX(), e.getExplosionY(), e.getExplosionZ(), e.getExplosionSize(), false, true);
    }

    @Override
    public boolean canDropBlockFromExplosion(CompatibleBlockState blockState, Explosion e) {
        return blockState.getBlockState().func_177230_c().func_149659_a(this.getCompatibleExplosion(e));
    }

    @Override
    public void onBlockExploded(World world, CompatibleBlockState blockState, CompatibleBlockPos blockpos, Explosion explosion) {
        blockState.getBlockState().func_177230_c().onBlockExploded(world, blockpos.getBlockPos(), this.getCompatibleExplosion(explosion));
    }

    @Override
    public float getExplosionResistance(World worldObj, CompatibleBlockState blockState, CompatibleBlockPos blockpos, Entity entity, Explosion explosion) {
        return blockState.getBlockState().func_177230_c().func_149638_a(entity);
    }

    @Override
    public float getExplosionResistance(World worldObj, Entity exploder, Explosion explosion, CompatibleBlockPos blockpos, CompatibleBlockState blockState) {
        return exploder.func_180428_a(this.getCompatibleExplosion(explosion), worldObj, blockpos.getBlockPos(), blockState.getBlockState());
    }

    @Override
    public boolean isSpectator(EntityPlayer entityplayer) {
        return entityplayer.func_175149_v();
    }

    @Override
    public boolean isCreative(EntityPlayer entityplayer) {
        return entityplayer.func_184812_l_();
    }

    @Override
    public void setBlockToFire(World world, CompatibleBlockPos blockpos1) {
        world.func_175656_a(blockpos1.getBlockPos(), Blocks.field_150480_ab.func_176223_P());
    }

    @Override
    public DamageSource getDamageSource(Explosion explosion) {
        return DamageSource.func_94539_a((net.minecraft.world.Explosion)this.getCompatibleExplosion(explosion));
    }

    @Override
    public double getBlastDamageReduction(EntityLivingBase entity, double d10) {
        return EnchantmentProtection.func_92092_a((EntityLivingBase)entity, (double)d10);
    }

    @Override
    public boolean verifyExplosion(World worldObj, Entity exploder, Explosion explosion, CompatibleBlockPos blockpos, CompatibleBlockState blockState, float f) {
        return exploder.func_174816_a(this.getCompatibleExplosion(explosion), worldObj, blockpos.getBlockPos(), blockState.getBlockState(), f);
    }

    @Override
    public boolean isFullBlock(CompatibleBlockState blockState) {
        return blockState.getBlockState().func_185913_b();
    }

    @Override
    public void dropBlockAsItemWithChance(World world, CompatibleBlockState blockState, CompatibleBlockPos blockpos, float f, int i) {
        blockState.getBlockState().func_177230_c().func_180653_a(world, blockpos.getBlockPos(), blockState.getBlockState(), f, i);
    }

    @Override
    public CompatibleBlockState getBlockBelow(World world, CompatibleBlockPos blockPos) {
        return CompatibleBlockState.fromBlockState(world.func_180495_p(blockPos.getBlockPos().func_177977_b()));
    }

    @Override
    public void playSound(World world, double posX, double posY, double posZ, CompatibleSound sound, float volume, float pitch) {
        if (sound != null) {
            world.func_184134_a(posX, posY, posZ, sound.getSound(), SoundCategory.BLOCKS, volume, pitch, false);
        }
    }

    @Override
    public boolean isBlockPenetratableByGrenades(Block block) {
        return block == Blocks.field_150350_a || block == Blocks.field_150329_H || block == Blocks.field_150362_t || block == Blocks.field_150361_u || block == Blocks.field_150480_ab || block == Blocks.field_150407_cf || block == Blocks.field_150398_cm || block == Blocks.field_150321_G || block == Blocks.field_150464_aj;
    }

    @Override
    public DamageSource genericDamageSource() {
        return GENERIC_DAMAGE_SOURCE;
    }

    @Override
    public boolean isCollided(CompatibleParticle particle) {
        return particle.isCollided();
    }

    @Override
    public ItemStack createItemStack(CompatibleItems compatibleItem, int stackSize, int damage) {
        return new ItemStack(compatibleItem.getItem(), stackSize, damage);
    }

    @Override
    public void addSmelting(Block block, ItemStack output, float f) {
        GameRegistry.addSmelting((Block)block, (ItemStack)output, (float)f);
    }

    @Override
    public void addSmelting(Item item, ItemStack output, float f) {
        GameRegistry.addSmelting((Item)item, (ItemStack)output, (float)f);
    }

    @Override
    public boolean isFlying(EntityPlayer player) {
        return player.field_71075_bZ.field_75100_b;
    }

    @Override
    public String getLocalizedString(String format, Object ... args) {
        return I18n.func_74837_a((String)format, (Object[])args);
    }

    @Override
    public void registerEgg(ModContext context, Class<? extends Entity> entityClass, String entityName, int primaryEggColor, int secondaryEggColor) {
        EntityRegistry.registerEgg((ResourceLocation)EntityList.func_191306_a(entityClass), (int)primaryEggColor, (int)secondaryEggColor);
    }

    @Override
    public void addSpawn(Class<? extends EntityLiving> entity, int weightedProb, int min, int max, CompatibleBiomeType ... biomeTypes) {
        HashSet<Biome> biomes = new HashSet<Biome>();
        for (CompatibleBiomeType compatibleType : biomeTypes) {
            for (BiomeDictionary.Type incompatibleType : compatibleType.getTypes()) {
                Set biomesForType = BiomeDictionary.getBiomes((BiomeDictionary.Type)incompatibleType);
                for (Biome b : biomesForType) {
                    biomes.add(b);
                }
            }
        }
        for (CompatibleBiomeType compatibleType : biomeTypes) {
            for (BiomeDictionary.Type incompatibleType : compatibleType.getTypes()) {
                for (Biome biome : ForgeRegistries.BIOMES) {
                    Set types = BiomeDictionary.getTypes((Biome)biome);
                    if (!types.contains(incompatibleType)) continue;
                    biomes.add(biome);
                }
            }
        }
        EntityRegistry.addSpawn(entity, (int)weightedProb, (int)min, (int)max, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes.toArray(new Biome[0]));
    }

    @Override
    public void setItemStackToSlot(Entity entity, CompatibleEntityEquipmentSlot compatibleEquipmentSlot, ItemStack itemStack) {
        entity.func_184201_a(compatibleEquipmentSlot.getSlot(), itemStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ShaderUniform getShaderUniform(ShaderManager shaderManager, String uniformName) {
        return shaderManager.func_147991_a(uniformName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setUniform(ShaderUniform uniform, float value) {
        uniform.func_148090_a(value);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setUniform(ShaderUniform uniform, float value1, float value2) {
        uniform.func_148087_a(value1, value2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setUniform(ShaderUniform uniform, float value1, float value2, float value3) {
        uniform.func_148095_a(value1, value2, value3);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setUniform(ShaderUniform uniform, float value1, float value2, float value3, float value4) {
        uniform.func_148081_a(value1, value2, value3, value4);
    }

    @Override
    public void setEntityAttribute(EntityLivingBase entity, CompatibleSharedMonsterAttributes attributes, double value) {
        entity.func_110148_a(attributes.getAttributes()).func_111128_a(value);
    }

    @Override
    public EnumDifficulty getDifficulty(World world) {
        return world.func_175659_aa();
    }

    @Override
    public void addStat(EntityPlayer entityplayer, CompatibleAchievement achievementList) {
        entityplayer.func_71029_a((StatBase)AchievementList.field_187992_s);
    }

    @Override
    public float getLightBrightness(World world, CompatibleBlockPos pos) {
        return world.func_175724_o(pos.getBlockPos());
    }

    @Override
    public boolean isStrafingSupported() {
        return true;
    }

    @Override
    public void strafe(EntityCustomMob entity, float forward, float strafe) {
        entity.func_70605_aq().func_188488_a(forward, strafe);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void useShader(EntityRenderer entityRenderer, boolean value) {
        ObfuscationReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)entityRenderer, (Object)value, (String[])new String[]{"useShader", "field_175083_ad"});
    }

    @Override
    public boolean is3dRenderable(Item item) {
        return item instanceof ItemBlock;
    }

    @Override
    public float getCompatibleAimingRotationYaw(EntityLivingBase thrower) {
        return thrower.field_70177_z;
    }

    @Override
    public <T> void setPrivateValue(Class<T> class1, T instance, Object value, String ... fieldNames) {
        ObfuscationReflectionHelper.setPrivateValue(class1, instance, (Object)value, (String[])fieldNames);
    }

    @Override
    public ItemStack getHelmet(EntityLivingBase entity) {
        return entity.func_184582_a(EntityEquipmentSlot.HEAD);
    }

    @Override
    public CompatibleVec3 getLookVec(EntityLivingBase player) {
        return new CompatibleVec3(player.func_70040_Z());
    }

    @Override
    public ItemStack createItemStack(NBTTagCompound tagCompound) {
        return new ItemStack(tagCompound);
    }

    @Override
    public EntityAITarget createAINearestAttackableTarget(EntityLivingBase e, Class<? extends EntityLivingBase> targetClass, boolean checkSight) {
        return new EntityAINearestAttackableTarget((EntityCreature)e, targetClass, checkSight);
    }

    @Override
    public EntityAIBase createAiAvoidEntity(EntityLivingBase e, Class<? extends EntityLivingBase> entityClassToAvoid, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
        return new EntityAIAvoidEntity((EntityCreature)e, entityClassToAvoid, avoidDistanceIn, farSpeedIn, nearSpeedIn);
    }

    @Override
    public Entity getTrueDamageSource(DamageSource cause) {
        return cause.func_76364_f();
    }

    @Override
    public ShaderGroup getShaderGroup(EntityRenderer entityRenderer) {
        return (ShaderGroup)this.getPrivateValue(EntityRenderer.class, entityRenderer, "theShaderGroup", "field_147707_d");
    }

    @Override
    public void setShaderGroup(EntityRenderer entityRenderer, DynamicShaderGroup shaderGroup) {
        this.setPrivateValue(EntityRenderer.class, entityRenderer, (Object)shaderGroup, "theShaderGroup", "field_147707_d");
    }

    @Override
    public WorldType getWorldType(World world) {
        return world.func_175624_G();
    }
}

