/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.PlayerItemInstance;
import com.vicmatskiv.weaponlib.compatibility.CompatibilityProvider;
import com.vicmatskiv.weaponlib.network.TypeRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.item.ItemStack;

public final class Tags {
    private static final String AMMO_TAG = "Ammo";
    private static final String DEFAULT_TIMER_TAG = "DefaultTimer";
    private static final String INSTANCE_TAG = "Instance";

    static int getAmmo(ItemStack itemStack) {
        if (itemStack == null || CompatibilityProvider.compatibility.getTagCompound(itemStack) == null) {
            return 0;
        }
        return CompatibilityProvider.compatibility.getTagCompound(itemStack).func_74762_e(AMMO_TAG);
    }

    static void setAmmo(ItemStack itemStack, int ammo) {
        if (itemStack == null) {
            return;
        }
        CompatibilityProvider.compatibility.ensureTagCompound(itemStack);
        CompatibilityProvider.compatibility.getTagCompound(itemStack).func_74768_a(AMMO_TAG, ammo);
    }

    public static long getDefaultTimer(ItemStack itemStack) {
        if (itemStack == null || CompatibilityProvider.compatibility.getTagCompound(itemStack) == null) {
            return 0L;
        }
        return CompatibilityProvider.compatibility.getTagCompound(itemStack).func_74763_f(DEFAULT_TIMER_TAG);
    }

    static void setDefaultTimer(ItemStack itemStack, long ammo) {
        if (itemStack == null || CompatibilityProvider.compatibility.getTagCompound(itemStack) == null) {
            return;
        }
        CompatibilityProvider.compatibility.getTagCompound(itemStack).func_74772_a(DEFAULT_TIMER_TAG, ammo);
    }

    public static PlayerItemInstance<?> getInstance(ItemStack itemStack) {
        if (itemStack == null || CompatibilityProvider.compatibility.getTagCompound(itemStack) == null) {
            return null;
        }
        byte[] bytes = CompatibilityProvider.compatibility.getTagCompound(itemStack).func_74770_j(INSTANCE_TAG);
        if (bytes != null && bytes.length > 0) {
            return (PlayerItemInstance)TypeRegistry.getInstance().fromBytes(Unpooled.wrappedBuffer((byte[])bytes));
        }
        return null;
    }

    public static <T extends PlayerItemInstance<?>> T getInstance(ItemStack itemStack, Class<T> targetClass) {
        if (itemStack == null || CompatibilityProvider.compatibility.getTagCompound(itemStack) == null) {
            return null;
        }
        byte[] bytes = CompatibilityProvider.compatibility.getTagCompound(itemStack).func_74770_j(INSTANCE_TAG);
        if (bytes != null && bytes.length > 0) {
            try {
                return (T)((PlayerItemInstance)targetClass.cast(TypeRegistry.getInstance().fromBytes(Unpooled.wrappedBuffer((byte[])bytes))));
            }
            catch (RuntimeException e) {
                return null;
            }
        }
        return null;
    }

    public static void setInstance(ItemStack itemStack, PlayerItemInstance<?> instance) {
        if (itemStack == null) {
            return;
        }
        CompatibilityProvider.compatibility.ensureTagCompound(itemStack);
        ByteBuf buf = Unpooled.buffer();
        if (instance != null) {
            TypeRegistry.getInstance().toBytes(instance, buf);
            CompatibilityProvider.compatibility.getTagCompound(itemStack).func_74773_a(INSTANCE_TAG, buf.array());
        } else {
            CompatibilityProvider.compatibility.getTagCompound(itemStack).func_82580_o(INSTANCE_TAG);
        }
    }

    public static byte[] getInstanceBytes(ItemStack itemStack) {
        if (itemStack == null || CompatibilityProvider.compatibility.getTagCompound(itemStack) == null) {
            return null;
        }
        return CompatibilityProvider.compatibility.getTagCompound(itemStack).func_74770_j(INSTANCE_TAG);
    }
}

